<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all server listeners tables</re:mark>

<c:set var="obj" >
	listenersList
</c:set>
<wmsform:propertieswarningmsg page="adv"/>

<div class="advanced-table-title">
	<h4 id="listenerTable"><wmsform:getlocalestring page="${page}.listeners" obj="listener"/>
	<small><wmsform:getlocalestring page="${page}.listeners" obj="listenerHelp"/></small></h4>
	<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/serversetup/edit_listeners.htm?','vhost=${wmsutil:urlEncode(vhost)}')"/>
</div>
<table class="table table-striped" style="width:auto">
	<tr>
		<th><wmsform:getlocalestring page="${page}.listeners" obj="baseClass"/></th>
	</tr>
	<c:forEach items="${requestScope.formDataListeners[obj]}" var="item">
		<tr>
			<td class="breakall">${item['baseClass']}</td>
		</tr>
	</c:forEach>
</table>
