<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all encodes tables</re:mark>

<c:set var="obj" >
	encodesList
</c:set>
<h5><wmsform:getlocalestring page="${page}" obj="encodesList"/></h5> 
<c:choose>
	<c:when test="${fn:length(requestScope.formData[obj]) == 0}">
		<div class="value">
			-None-
		</div>
	</c:when>
	<c:otherwise>
		<table class="table table-striped">
			<tr>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.enabled"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.encode"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.streamName"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
			</tr>
			<c:forEach items="${requestScope.formData[obj]}" var="item" varStatus="varStatus">
				<tr>
					<td>
						<c:choose>
							<c:when test="${item['enable']=='true'}">
								<center><input type="checkbox" disabled="disabled" checked="checked"></center>
							</c:when>
							<c:otherwise>
								<center><input type="checkbox" disabled="disabled"></center>
							</c:otherwise>
						</c:choose>
					</td>
					<td class="breakall">
						<a onclick="javascript:showEncode('${wmsutil:escapeHtml(item['encodeName'])}')">${wmsutil:escapeHtml(item['encodeName'])}</a>
					</td>
					<td>${item['streamName']}</td>
					<td>
						<sec:authorize access="hasAnyRole('admin')">		
							<a onclick="javascript:showEditEncode('${wmsutil:escapeHtml(item['encodeName'])}')" ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this preset'></i></a>
							<a onclick="javascript:removeEncode('${wmsutil:escapeHtml(item['encodeName'])}')"><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this preset'></i></a>
							<a onclick="javascript:copyEncode('${wmsutil:escapeHtml(item['encodeName'])}','${wmsutil:escapeHtml(templateDisplayName)}')"><i class='fa fa-files-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Copy this preset to create a new preset'></i></a>
						</sec:authorize>
					</td>
				</tr>
			</c:forEach>
		</table>
	</c:otherwise>
</c:choose>
<wmsdialog:deletetranscoderencode page="${page}"/>
<wmsdialog:copytranscoderencode page="${page}"/>
<script>

function showEncode(encodeName)
{
	encodeName=encodeURIComponent(encodeName);
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/transcoderencode/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName="+encodeName); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/transcoderencode/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName="+encodeName);		
	}
	
}

function showEditEncode(encodeName)
{
	encodeName=encodeURIComponent(encodeName);
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/transcoderencode/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName="+encodeName+"&action=quickEdit"); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/transcoderencode/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName="+encodeName+"&action=quickEdit");		
	}
	
}
function copyEncode(encodeName,templateDisplayName)
{
	copyEncodeName=encodeName;
	copyEncodeDisplayName=encodeName;
	copyTranscoderEncodeShow();
	return;
}

function removeEncode(encodeName)
{
	deleteEncode=encodeName;
	deleteEncodeShow();
}
/*
var tblDataEncode = new Array();
var tblIdxEncode=0;

initTableDataEncode();

function initTableDataEncode()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxEncode++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.enable = "${item['enable']}"=="true";
		newItem.encodeName = "${item['encodeName']}";
		newItem.streamName = "${item['streamName']}";
		tblDataEncode.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
*/
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>