<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>
<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClassTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="cssSize" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="readonly" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="options" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="getLocalString" required="false" rtexprvalue="true" %>
<%@ attribute name="onClick" required="false" rtexprvalue="true" %>


<re:mark>Display a single dropdown box sourced from </re:mark>

<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<c:if test="${ empty bind}">
	<c:set var="bind" value="true"/>
</c:if>
<c:if test="${ empty cssClass}">
	<c:set var="cssClass" value="form-control"/>
</c:if>
<c:if test="${ empty cssClassTitle}">
	<c:set var="cssClassTitle" value="control-label"/>
</c:if>
<c:if test="${ empty getLocalString}">
	<c:set var="getLocalString" value="false"/>
</c:if>
<c:if test="${ empty cssSize}">
	<c:set var="cssSize" value="col-md-12"/>
</c:if>

<%--
c:choose>
	<c:when test="${ !empty onClick }">
		<c:set var="onClickEntry" value="onClick=\"if (typeof(this.selectedIndex) != 'undefined') ${onClick}(this.selectedIndex)\""/>
	</c:when>
	<c:when test="${ empty onClick }">
		<c:set var="onClickEntry" value=""/>
	</c:when>
</c:choose>
--%>
 
<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
	<c:if test="${ empty showTitle}">
		<label class="${cssClassTitle}">
			<wmsform:getlocalestring page="${page}" obj="${obj}"/>	
			<c:if test="${! empty required}">
			*
			</c:if>
		</label>
	</c:if>
	<re:mark>Get list of items</re:mark>
	<c:choose>
		<c:when test="${ empty options }">
			<c:if test="${bind=='true'}">
				<c:set var="objOptions" value="${obj}Options"/>
				<c:choose>
					<c:when test='${fn:endsWith(page, "Adv")}'>
						<c:set var="optionsList" value="${requestScope.formDataAdv[objOptions]}"/>
					</c:when>
					<c:otherwise>
						<c:set var="optionsList" value="${requestScope.formData[objOptions]}"/>
					</c:otherwise>
				</c:choose>
			</c:if>
		</c:when>
		<c:otherwise>
			<c:set var="optionsList">
				${options}
			</c:set>
		</c:otherwise>
	</c:choose>
	
	<re:mark>Get currently set value</re:mark>
	<c:if test="${bind=='true'}">
		<c:set var="objValues">
			<wmsform:objvaluearray page="${page}" obj="${obj}" />
		</c:set>
	</c:if>
	<re:mark>Display the dropdown picker</re:mark>
	<div class="row">
		<div class="${cssSize}">

	<re:mark>getLocalString is what is in the strings translation table (messages_en.properties) </re:mark>
	<re:mark>valueString is used do get the strings from messageg_en.properties </re:mark>
	<c:choose>
		<c:when test="${empty bind or bind=='true'}">
			<form:select id="${obj}" path="${obj}" class="${cssClass}">
				<c:forEach var="itemKey" items="${optionsList}">
					<c:set var="displayString" value="${wmsutil:escapeHtml(fn:trim(itemKey))}"/>
					<c:set var="valueString" value="${wmsutil:escapeHtml(fn:trim(itemKey))}"/>
					<c:if test="${getLocalString=='true'}">
						<c:set var="displayString">
							<wmsform:getlocalestring page="${page}" obj="${obj}.${valueString}"/>
						</c:set>
					</c:if>
					<c:choose>
						<c:when test="${fn:trim(itemKey) == fn:trim(objValues)}">
							<option value="${valueString}" selected="selected">
								${displayString}
							</option>
						</c:when>
						<c:otherwise>
							<option value="${valueString}">
								${displayString}
							</option>
						</c:otherwise>
					</c:choose>
				</c:forEach>
			</form:select>
		</c:when>
		<c:otherwise>
			<select id="${obj}" class="form-control">
				<c:forEach var="itemKey" items="${fn:split(optionsList,',')}">
					<c:choose>
						<c:when test="${fn:trim(itemKey) == fn:trim(objValues)}">
							<option value="${fn:trim(itemKey)}" selected>${fn:trim(itemKey)}</option>
						</c:when>
						<c:otherwise>
							<option value="${fn:trim(itemKey)}">${fn:trim(itemKey)}</option>
						</c:otherwise>
					</c:choose>
				</c:forEach>
			</select>
		</c:otherwise>
	</c:choose>
		</div>
	</div>	
	<re:mark>Errors and warnings</re:mark>
	<c:if test="${bind=='true'}">
		<wmsform:errors path="${obj}"/>
		<wmsform:warnings path="${obj}"/>
	</c:if>
	<c:set var="objhelp">
		<wmsform:getlocalestring page="${page}" obj="${obj}.help"/>
	</c:set>
	<c:choose>
		<c:when test='${ not (fn:endsWith(objhelp,"help"))}'>
			<span class="help-block">${fn:trim(objhelp)}</span>
		</c:when>
	</c:choose>
</div>