<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="href" required="true" rtexprvalue="true" %>
<%@ attribute name="src" required="true" rtexprvalue="true" %>
<%@ attribute name="buttonNumber" required="true" rtexprvalue="true" %>
<%@ attribute name="pathName" required="true" rtexprvalue="true" %>

<re:mark>Display a destinations button</re:mark>
<c:set var="btnValue">
	<wmsform:getlocalestring page="${page}" obj="${obj}"/>
</c:set>

<div id="destinationsBtn${buttonNumber}">
	<div id="targetDestBtn${buttonNumber}" onClick="targetDestClick('${buttonNumber}')" class="btn-targetdest btn-targetdest-normal" pathName="${pathName}">
		<img src="${src}">
		<div id="targetDestBtnText${buttonNumber}" class="targetdest-text text-center targetdest-vertical-center" >
			${btnValue}
		</div>
	</div>
	<p class="btn-targetdest-width text-center">
		<a target="_blank" href="${href}"><fmt:message key="common.learnMore" /></a>
	</p>
</div>
