<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="returnPage" required="true" rtexprvalue="true" %>
<%@ attribute name="vhost" required="true" rtexprvalue="true" %>

<div id="restartVHostModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="restartVHostModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:restartVHostClose()">x</button>
					<h4 id="restartVHostModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="restartVHostDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="restartVHostDialog.message"/><b>${wmsutil:escapeHtml(vhost)}</b></p>
						<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="restartVHostDialog.warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:restartVHostClose()"/>
					<wmsform:buttonok  onClick="javascript:doRestartVHost()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>

function restartVHostShow() {
	$('#restartVHostModal').on("shown.bs.modal", function() {
	});
	$('#restartVHostModal').modal('show');	
}

function restartVHostClose() {
	$('#restartVHostModal').modal('hide');
}

function doRestartVHost() {
	$('#restartVHostModal').on('hidden.bs.modal', function() {
		postAJAXForm('vhost/restart.htm','returnPage=${returnPage}');
	});
	restartVHostClose();
}

</script>