<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="copyTranscoderTemplateModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="copyTranscoderTemplateModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="copyForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:copyTranscoderTemplateClose()">x</button>
						<h4 id="copyTranscoderTemplateModalLabel" class="modal-title">
							<wmsform:getlocalestring page="${page}" obj="copyTranscoderTemplateDialog.title" />
						</h4>
					</div>
					<div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="copyTranscoderTemplateDialog.message" /></p>
						<p>
							<select required id="copyTemplateName" class="form-control">
								<option disabled selected>Select a transcoder template to copy</option>
								<c:forEach items="${requestScope.formData['templates']}" var="item">
									<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
									<c:choose>
										<c:when test="${fn:toLowerCase(item)=='transcode'}">
											<option value="${fn:trim(item)}">Transcode (Default)</option>
										</c:when>
										<c:when test="${fn:toLowerCase(item)=='transrate'}">
											<option value="${fn:trim(item)}">Transrate (Default)</option>
										</c:when>
										<c:when test="${fn:toLowerCase(item)=='audioonly'}">
											<option value="${fn:trim(item)}">Audio Only (Default)</option>
										</c:when>
										<c:when test="${fn:toLowerCase(item)=='transcode-h265'}">
											<option value="${fn:trim(item)}">Transcode H.265 (Default)</option>
										</c:when>
										<c:otherwise>
											<option value="${fn:trim(item)}">${fn:trim(item)}</option>
										</c:otherwise>
									</c:choose>
								</c:forEach>
							</select>
						</p>
						<label><wmsform:getlocalestring page="${page}" obj="copyTranscoderTemplateDialog.prompt" /></label><input id="newTemplateName" path="newTemplateName" value="" class="form-control"/>
						<span class="help-block"><wmsform:getlocalestring page="${page}" obj="copyTranscoderTemplateDialog.help" /></span>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="newTemplateNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:copyTranscoderTemplateClose()" />
								<wmsform:buttonok onClick="javascript:doCopyTranscoderTemplate()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupTemplateNameError">
	<wmsform:getlocalestring page="${page}" obj="template.templateName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="${page}" obj="template.templateName.empty"/>
</c:set>
<c:set var="blankSourceError">
	<wmsform:getlocalestring page="${page}" obj="template.templateSourceName.empty"/>
</c:set>
<script>
$(document).ready(function() {
	$("#copyForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {
        	 doCopyTranscoderTemplate();
             return false;
        }
     });
});

function copyTranscoderTemplateShow() {
	$('#newTemplateNameWarnings').hide();
	$('#copyTemplateName').prop("selectedIndex",0);

	$('#newTemplateName').val("");
	$('#copyTranscoderTemplateModal').on("shown.bs.modal", function() {
		$('#newTemplateName').focus();
	});
	$('#copyTranscoderTemplateModal').modal('show');
}

function copyTranscoderTemplateClose() {
	$('#copyTranscoderTemplateModal').modal('hide');
}

function doCopyTranscoderTemplate()
{
	var ok=true;
	if($("#newTemplateName").val().trim()=="")
	{
		$('#newTemplateNameWarnings').text("${blankNameError}");
		$('#newTemplateNameWarnings').show();
		ok=false;
	}
	if($('#copyTemplateName').prop("selectedIndex")==0)
	{
		$('#newTemplateNameWarnings').text("${blankSourceError}");
		$('#newTemplateNameWarnings').show();
		ok=false;
	}
	for (tblItem in tblDataTemplate) {
		if(!tblDataTemplate[tblItem].removed)
		{
			if(tblDataTemplate[tblItem].templateName==$("#newTemplateName").val().trim())
			{
				$('#newTemplateNameWarnings').text("${dupTemplateNameError}");
				$('#newTemplateNameWarnings').show();
				ok=false;
			}
		}
	}
	if(ok)
	{
		createCopyTranscoderTemplate();
	}

}

function createCopyTranscoderTemplate() {
	var result=$('#newTemplateName').val();
	lastTranscoderTemplate=result.trim();
	lastTranscoderTemplateType="${TemplateType}";
	lastTranscoderTemplateSection='main';
	$('#copyTranscoderTemplateModal').on('hidden.bs.modal', function() {
		if("${appType}" == "")
		{
			postAJAXForm('transcoder/copy.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&srcTemplate='+ encodeURIComponent($('#copyTemplateName').val()) +'&dstTemplate='+encodeURIComponent(result.trim()));
		}
		else {
			postAJAXForm('transcoder/copy.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&srcTemplate='+ encodeURIComponent($('#copyTemplateName').val()) +'&dstTemplate='+encodeURIComponent(result.trim()));
		}
	});
	copyTranscoderTemplateClose();
}
</script>