<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="copyApplicationModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="copyApplicationModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="copyForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:copyApplicationClose()">x</button>
						<h4 id="copyApplicationModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="copyApplicationDialog.title"/></h4>
					</div>
					<div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="copyApplicationDialog.message"/> <b>${wmsutil:escapeHtml(appName)}</b>.</p>
						<label><wmsform:getlocalestring page="${page}" obj="copyApplicationDialog.prompt"/></label><br>
						<input class="form-control" id="newAppName" path="newAppName" value=""/>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="newAppNameError" class="alert alert-danger" style="display:none"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel  onClick="javascript:copyApplicationClose()"/>
								<wmsform:buttonok  onClick="javascript:doCopyApplication()"/>
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="$common" obj="common.invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="$common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#copyForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doCopyApplication();
             return false;
        }
     });
});

function copyApplicationShow() {
	$('#newAppNameError').hide();
	$('#newAppName').val("");
	$('#copyApplicationModal').on("shown.bs.modal", function() {
		$('#newAppName').focus();
	});
	$('#copyApplicationModal').modal('show');
}

function copyApplicationClose() {
	$('#copyApplicationModal').modal('hide');
}

function doCopyApplication()
{
	var ok=true;
	var nApp=$('#newAppName').val().trim();
	$('#newAppName').val(nApp);
	if(ok && !isValidFileName(nApp))
	{
		$('#newAppNameError').text("${invalidNameError}");
		$('#newAppNameError').show();
		ok=false;
	}
	if(ok && !isValidFileNameLength(nApp))
	{
		$('#newAppNameError').text("${invalidNameLengthError}");
		$('#newAppNameError').show();
		ok=false;
	}
	if(ok)
	{
	
		$.ajax({
			url : "NewAppName.jsdata",
			data : "vhost="+encodeURIComponent(currentVhost)+"&appName="+nApp,
			cache : false,
			success : function(data) {
				if(data.substring(0, redirectLoginString.length)==redirectLoginString) {
					document.location = "login.htm" + location.hash;
				}
				else {	
					var json_parsed = $.parseJSON(data);
					if(json_parsed.status=="valid")
					{
						createCopyApplication();
					}
					else {
						document.getElementById("newAppNameError").innerHTML=json_parsed.message; 
						document.getElementById("newAppNameError").style.display="";
					}
				}
			},
			error : function (jqXHR, textStatus, thrownError) {
				console.log("Error: (" + this.url +") " + thrownError);
			}
		});
	}
}

function createCopyApplication() {
	var result=$('#newAppName').val();
	lastApplication=result.trim();
	lastApplicationType="${appType}";
	lastApplicationSection='main';
	$('#copyApplicationModal').on('hidden.bs.modal', function() {
		postAJAXForm('applications/copy.htm','srcApp=${wmsutil:urlEncode(appName)}'+'&dstApp='+encodeURIComponent(result.trim())+"&vhostName=${wmsutil:urlEncode(vhost)}&appType=${appType}");
	});
	copyApplicationClose();
}

</script>