<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<div>
    <div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
    </div>
	<div class="row">
        <c:choose>
			<c:when test="${empty appType}">
				<div class="col-md-12">
					<happ>Virtual Host Stream Files > ${wmsutil:escapeHtml(streamName)} </happ><br>
					<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
				</div>
			</c:when>
			<c:otherwise>
				<div class="col-md-5">
					<happ> ${wmsutil:escapeHtml(appName)} >  ${wmsutil:escapeHtml(streamName)} </happ><br>
					<small class="text-muted">${uiAppType}</small>
				</div>
				<wmsform:applicationbuttons page="${page}" appendStream="true"/>
			</c:otherwise>
		</c:choose>
	</div>
	<p><a href="javascript:returnStreamFile()"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="streamFiles.details" obj="return" /></a></p>

	<sec:authorize access="hasAnyRole('advUser')">
	    <div class="row">
			<div class="col-md-12">
				<ul class="nav nav-tabs" >
					<li id="StreamFileBasic" class="active">
						<a href="javascript:showBasicTab('transition')"><wmsform:getlocalestring page="streamFiles.details" obj="basicTab" /></a>
					</li>
					<li id="StreamFileAdvanced" >
						<a href="javascript:showAdvTab('transition')"><wmsform:getlocalestring page="streamFiles.details" obj="propertiesTab" /></a>
					</li>
		    	</ul>
		    </div>
		</div>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	<div class="row" id="tabContent">
		<div class="col-md-12">
	      	<div class="row">
				<div id="ViewMode">
					<div  id="TabBasic" style="display:none">
						<jsp:include page="ViewBasic.jsp" flush="true" />
					</div>
					<div id="TabAdv" style="display:none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
				 	</div>
				 </div>
				 <div id="EditMode">
					<div id="TabEditBasic" style="display:none">
                       	<div class="col-md-8 main-content">
                               <form:form method="post" commandName="formData" id="defaultForm" onsubmit="return false;">
                                   <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                   <wmsform:rightrailhideshow/>
                                   <form:hidden path="ignoreWarnings" />
                                   <jsp:include page="EditBasic.jsp" flush="true" />
                               </form:form>
						</div>
                        <div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
                            <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
                        </div>
					</div>
					<div id="TabEditAdv" style="display:none">
                       	<div class="col-md-12">
                               <form:form method="post" commandName="formDataAdv" id="defaultFormAdv">
                                   <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                            <jsp:include page="EditAdv.jsp" flush="true" />
                                   <form:hidden path="ignoreWarnings" />
                               </form:form>
                        </div>
					</div>
			 	</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>
</div>

<script>
$(document).ready(function() {
	if(typeof(lastTab) === 'undefined') {
		lastTab="Basic";
	}

	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();
		$('#EditMode').show();
		$('#AppButtons').hide();
	}
	else
	{
		$('#ViewMode').show();
		$('#EditMode').hide();
		$('#AppButtons').show();
	}
	if("${idx}"=="-1")
	{
		lastTab='Basic';
		showBasicTab('new');
		$('#StreamFileAdvanced').hide();
	}
	else if(lastTab=="Advanced")
	{
		showAdvTab('new');
	}
	else
	{
		showBasicTab('new');
	}
});

function showBasicTab(event) {
	if (event == "transition")
	{
		lastTab='Basic';
		showStream();
	}
	else
	{
		if("${mode}"=="edit" && lastTab!='Basic')
		{
			lastTab='Basic';
			showStream();
		}
		lastTab='Basic';
		createCookie("lastTab",lastTab);
		$('#TabBasic').show();
		$('#TabEditBasic').show();
		$('#TabAdv').hide();
		$('#TabEditAdv').hide();
		$('#StreamFileBasic').addClass('active');
		$('#StreamFileAdvanced').removeClass();
	}
}

function showAdvTab(event) {
	if (event == "transition")
	{
		lastTab='Advanced';
		showStream();
	}
	else
	{
		if("${mode}"=="edit" && lastTab!='Advanced')
		{
			lastTab='Advanced';
			showStream();
		}
		lastTab='Advanced';
		createCookie("lastTab",lastTab);
		$('#TabBasic').hide();
		$('#TabEditBasic').hide();
		$('#TabAdv').show();
		$('#TabEditAdv').show();
		$('#StreamFileBasic').removeClass();
		$('#StreamFileAdvanced').addClass('active');
	}
}

function returnStreamFile()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/streamfiles/view.htm", "vhost=${wmsutil:urlEncode(vhost)}");
	}
	else
	{
		loadAjaxMainContent("applications/${appType}/streamfiles/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}");
	}
}

</script>

