<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>

<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="vhost"/>
	<form:hidden path="appName"/>
	<form:hidden path="appType"/>
	<form:hidden path="section" />	
	<form:hidden path="streamName"/>
	<form:hidden path="action"/>
	<re:mark>This hidden field has to be here to get it to be 'copied' into the new model for validation</re:mark>
	<form:hidden path="sourceControlEnabled"/>  
</fieldset>

<wmsform:editproperty page="streamFiles.streamFile" obj="uri" cssClass="form-control" required="true"/>

<re:mark>It don't like booleans, so we have to use the requestsocpe instead of the hidden field above to access it</re:mark>
<c:if test="${requestScope.formData['sourceControlEnabled']=='true'}">
	<wmsform:editproperty page="streamFiles.streamFile" obj="sourceControlUserName" required="yes"/>
	<wmsform:editproperty page="streamFiles.streamFile" obj="sourceControlPassword" required="yes" inputType="password"/>
	<wmsform:editproperty page="streamFiles.streamFile" obj="sourceControlPassword2" required="yes" inputType="password"/>
</c:if>
<p>	
	<wmsform:buttonsave onClick="javascript:saveStream()" />
	<c:choose>
		<c:when test="${action=='quickEdit'}">
			<wmsform:buttoncancel onClick="javascript:returnStreamFile()" />
		</c:when>
		<c:otherwise>
			<wmsform:buttoncancel onClick="javascript:showStream()" />
		</c:otherwise>
	</c:choose>
</p>

<script>
function showStream()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/streamfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&streamFile=${wmsutil:urlEncode(streamName)}"); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/streamfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamFile=${wmsutil:urlEncode(streamName)}");
	}
}
function saveStream()
{
	postAJAXForm('server/vhost/streamfile/edit.htm','');
}

</script>
