<h4>About Virtual Hosting</h4>
<p>Wowza Streaming Engine can be configured to serve multiple users from separate virtual hosting environments. Each virtual host (VHost) environment has its own set of configuration files, application folders, and log files. The server only supports IP address/port-based virtual hosting. By default, it ships with a single VHost environment named <strong>_defaultVHost_</strong>. For more information, see "Virtual Hosting" in the <a href="https://www.wowza.com/resources/WowzaStreamingEngine_UsersGuide-4.8.0.pdf" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza Streaming Engine User Guide</a>.</hr></p>

<h5>Name and Description</h5>
<p>Enter a unique name and description that helps you to remember details about this VHost environment.</p>

<h5>Configuration Directory</h5>
<p>Specify the VHost configuration directory where configuration files, application folders, and log files are created. The directory path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.</p>

<h5>Maximum Connections</h5>
<p>Specify the maximum number of simultaneous connections that the VHost can support. Select <strong>Limit number of connections</strong>, and then enter a positive non-zero integer value.</p>

<h5>Transcoder Session Limit</h5>
<p>Specify the maximum number of simultaneous transcoding sessions that the VHost can support. Select <strong>Limit number of concurrent transcodes</strong>, and then enter a positive non-zero integer value. To configure transcoding sessions by creating encodes, go to the <a href="javascript:lastServerMC='vhostTranscoder';loadAjaxSideBar('SB_Server.html','')">Transcoder page</a>.</p>

<h4>About Host Ports</h4>
<p>A <em>host port</em> is an IP address/TCP port combination that a Wowza Streaming Engine server binds to for incoming and outgoing connections. A host port can be configured to use Secure Sockets Layer (SSL) encryption. You must configure at least one host port for each VHost. If you create multiple host posts for a VHost, they each must have a unique name and must define a unique IP address and port combination that doesn't conflict with other host ports that are defined for the VHost.</p>

<p>To add a host port, click <strong>Add Host Port</strong>.</p>

<p>To edit host port settings, click the <strong>Edit</strong> icon for the host port.</p>

<p>To delete a host port, click the <strong>Delete</strong> icon for the host port.</p>

<h5>Host port Name, Type, IP Address, and Port(s)</h5>
<p>Each host port that you create must have a unique <strong>Name</strong> value and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<p>In the <strong>Type</strong> list, specify that the host port is used for streaming (select <strong>Streaming</strong>) or administration (select <strong>Admin</strong>).</p>

<p>In <strong>IP address</strong> and <strong>Port</strong>, specify a combination of values that don't conflict with other host ports that are defined for the VHost. By default, the server uses TCP port&nbsp;1935 for all forms of streaming. The default port for HTTP administration is TCP port&nbsp;8086. You can specify multiple streaming ports and/or port ranges between <strong>1</strong> and <strong>65535</strong> in the <strong>Port(s)</strong> box as a comma-separated list. For more information, see <a href="https://www.wowza.com/docs/how-to-get-started-as-a-wowza-streaming-engine-manager-administrator#openPorts" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure streaming ports</a>.</p>

<blockquote><strong>Note:</strong> The server can't share ports with other programs or services that are running.</blockquote>

<h5>SSL encryption</h5>
<p>RTMP and HTTP-based connections to the VHost can be encrypted using Secure Sockets Layer (SSL) certificates from a certificate authority. Wowza provides free 256-bit SSL certificates to users with Subscription and Perpetual licenses via the Wowza StreamLock&#8482; AddOn. To secure connections to the VHost, select <strong>Enable SSL/StreamLock</strong>, and then specify the path to the SSL certificate file in <strong>Keystore Path (StreamLock certificate path)</strong> and the password for the certificate in <strong>Keystore Password (StreamLock certificate password)</strong>. The <strong>Keystore Path</strong> value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.</p>

<blockquote><strong>Note:</strong> For more information about the Wowza StreamLock security option for network encryption, see <a href="https://www.wowza.com/docs/how-to-get-ssl-certificates-from-the-streamlock-service" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Get SSL certificates from the Wowza Streaming Engine StreamLock service</a>.</blockquote>
