<h4>About Decoding Preset</h4>
<p>Decoding preset settings define how incoming live streams are prepared for encoding. A template has one decoding preset definition. The following video and audio codecs can be decoded:</p>
<p><strong>Video</strong></p>
<ul>
	<li>H.264/AVC
	<li>H.265/HEVC
	<li>MPEG-2
	<li>MPEG-4 Part&nbsp;2
</ul>
<p><strong>Audio</strong></p>
<ul>
	<li>AAC
	<li>G.711 (&#181;-law and A-law)
	<li>MPEG-1 Layer&nbsp;1/2
	<li>MPEG-1 Layer&nbsp;3 (MP3)
	<li>Speex
</ul>

<h5>Decoding Preset Settings</h5>
<p>Click <strong>Edit</strong> to adjust the following settings:
<ul>
	<li><strong>Description</strong>. Information that will help you to remember details about this preset.
	<li><strong>Decoder Implementation</strong>. The decoding implementation to use. The server supports the following software and accelerated hardware decoding implementations:
		<ul>
			<li><strong>Default</strong>. The built-in MainConcept software decoder (not hardware-accelerated).
			<li><strong>QuickSync</strong>. Intel Quick Sync decoding acceleration. If your hardware doesn't support the Quick Sync instruction set, the MainConcept software decoder is used.  Note that QuickSync accelerated decoding isn't supported for H.265 sources.
			<li><strong>CUDA</strong>. NVIDIA CUDA decoding acceleration. If your hardware doesn't support the CUDA instruction set, the MainConcept software decoder is used.
			<li><strong>NVCUVID</strong>. NVIDIA NVCUVID decoding acceleration. If your hardware doesn't support the NVCUVID instruction set, the MainConcept software decoder is used.
		</ul>
	<li><strong>Deinterlace source stream</strong>. Select this option if the source stream must be deinterlaced for progressive scan displays.
</ul></p>

<hr />
<h4>Overlay Images</h4>
<p>You can apply static GIF, JPEG, PNG, and BMP overlay images to streams to achieve stationary image effects such as a watermark to your video. You can customize the location, size, alignment, and opacity of the image using the settings below.</p>

<p>To view overlay image settings, click the overlay image name in the list.</p>

<p>To enable an overlay image, click the <strong>Enabled</strong> check box for the overlay image. You can enable multiple overlay images for a decoded stream. If you enable multiple overlay images, you can use the <strong>Move Up</strong> and <strong>Move Down</strong> icons to arrange them in the proper order. In the video, images that are higher in the list are displayed on top of images that are lower in the list.</p>

<p>To add an overlay image, click <strong>Add Overlay Image</strong>.</p>

<p>To change overlay image settings, click the <strong>Edit</strong> icon for the overlay image.</p>

<p>To delete an overlay image, click the <strong>Delete</strong> icon for the overlay image.</p>

<blockquote><strong>Notes:</strong><br />Images with a transparency require extra CPU resources.<br /><br />If you don't want to have the same overlay image for all encoded output renditions, you can apply it to a single rendition on the template's <strong>Encoding Preset</strong> tab.<br /><br />You can apply dynamic overlay images to video using a Java-based API. For more information, see <a href="https://www.wowza.com/docs/how-to-add-graphic-overlays-to-live-streams-with-wowza-transcoder" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Add graphic overlays to live streams with Wowza Transcoder</a>.</blockquote>

<h5>Overlay Image Settings</h5>
<ul>
	<li><strong>Image Name</strong>. A unique name for the overlay image to differentiate it from other images. The name can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters.
	<li><strong>Image Path</strong>. The path to the overlay image. The path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.
	<li><strong>Update overlay image when source image updates</strong>. Check the source image file for updates every 750 milliseconds and refresh the overlay image if it has changed.
	<li><strong>Width</strong> and <strong>Height</strong>. The overly image width and height. To specify that the source image width and/or height be used, select the <strong>Same as source image</strong> option. The minimum supported width and height is <strong>4</strong> pixels and the sum of these values must be an even number.
	<li><strong>Opacity</strong>. The overlay image opacity. Valid values range from <strong>0</strong> (completely transparent) to <strong>100</strong> (completely opaque).
</ul>

<h5>Overlay Image Placement Settings</h5>
<ul>
	<li><strong>Location</strong>. Select an option button in this box to specify the base position of the overlay image. You can think of the <strong>Location</strong> box as analogous to the display on a playback device.
	<li><strong>Horizontal Offset</strong> and <strong>Vertical Offset</strong>. Specify a horizontal and/or vertical offset (in pixels) for the overlay image from the base position that you specified in the <strong>Location</strong> box. Values must be zero or greater (even-numbered values recommended).
</ul>

<p>As an example, to align an overlay image 10&nbsp;pixels above the lower-right corner of the output frame, select the option button in the lower-right corner of the <strong>Location</strong> box, and then enter <strong>10</strong> in the <strong>Vertical Offset</strong> box.</p>