<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<div>
   	<div id="generic.warnings" class="alert alert-warning" style="display:none"></div>
    <c:forEach var="msg" items="${formData.genericMessages}">
        <div class="row">
        	<div class="col-md-12">
      	    	<div class="alert alert-success">
            		<strong>${msg}</strong>
        		</div> 
            </div>
        </div>
    </c:forEach>

	<div class="row">
			<c:choose>
        		<c:when test="${empty appType}">
			        <div class="col-md-12">
						<happ>Transcoder Template &gt; ${wmsutil:escapeHtml(templateDisplayName)} &gt; ${wmsutil:escapeHtml(encodeName)}</happ><br>
						<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
					</div>
        		</c:when>
        		<c:otherwise>
			        <div class="col-md-5">
			            <happ>${wmsutil:escapeHtml(appName)} > Transcoder > ${wmsutil:escapeHtml(templateDisplayName)} &gt; ${wmsutil:escapeHtml(encodeName)}</happ><br>
			            <small class="text-muted">${uiAppType}</small>
			        </div>
					<wmsform:applicationbuttons page="${page}"/>
          		</c:otherwise>
        	</c:choose>
        </div>
        <!--<div class="col-md-1 appbuttons" id="TranscoderButtons">
	        wmsform:buttonrestart onClick="javascript:restartServerShow()"/>
	        <!--wmsform:buttonstop onClick="javascript:stopServerShow()" />
        </div>-->
    </div>

	<p><a href="javascript:returnTranscoderTemplate()"><i class="fa fa-arrow-left"></i> Return to Transcoder Template</a></p>
	<c:choose>
		<c:when test="${requestScope.formData['enable']}">
			<h5><wmsform:getlocalestring page="transcoder.template.encode" obj="enabledMessage"/></h5>
		</c:when>
		<c:otherwise>
			<h5><wmsform:getlocalestring page="transcoder.template.encode" obj="disabledMessage"/></h5>
		</c:otherwise>
	</c:choose>

    <div class="row">
		<div class="col-md-12">
			<ul class="nav nav-tabs" >
				<li id="Encode" >
					<a href="javascript:showEncodeTab()">Encoding Preset</a>
				</li>
			</ul>
		</div>
	</div>    
	<div class="row" id="tabContent">
		<div class="col-md-12">
	      	<div class="row">
				<div id="ViewMode">
					<div id="TabEncode" style="display:none">
						<jsp:include page="ViewEncode.jsp" flush="true" />
				 	</div>
				 </div>
				 <div id="EditMode">
                    <div id="TabEditEncode" style="display:none">
                       	<div class="col-md-8 main-content">
                            <form:form method="post" commandName="formData" id="encodeEditForm"> 
                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                <wmsform:rightrailhideshow/>
                                <jsp:include page="EditEncode.jsp" flush="true" />
                                <form:hidden path="ignoreWarnings" />	
                            </form:form>
                         </div>
                         <div id="HelpStores" class="col-md-4 right-rail well-help pull-right">
                             <jsp:include page="HelpEncode_${formData.currentLocale}.jsp" flush="true" />
                         </div>
                    </div>
			 	</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>	
</div>
	<c:if test="${!empty commonErrorMessage}">
		<script>
			document.getElementById("common.errors.text").innerHTML="${commonErrorMessage}"; 
			document.getElementById("common.errors").style.display="";
		</script>
	</c:if>
<script>

function returnTranscoderTemplate()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/transcodertemplate/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}"); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/transcodertemplate/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}"); 			
	}
}

$(document).ready(function() {
	if(typeof(lastTab) === 'undefined') {
		lastTab="Encode";
	}
		
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#EditMode').show();
		$('#TranscoderButtons').hide();				
	}
	else 
	{
		$('#ViewMode').show();		
		$('#EditMode').hide();		
		$('#TranscoderButtons').show();				
	}
	showEncodeTab();
	if("${action}" == "new")
	{
	}
	else 
	{
		if("${appType}" == "")
		{
			lastTemplate="${templateName}";
			//createCookie("lastTemplate",lastTemplate);
			lastTemplateEncode="${encodeName}";
			//createCookie("lastTemplateEncode",lastTemplateEncode);
		}
		else 
		{
			lastTemplateApp="${templateName}";
			//createCookie("lastTemplateApp",lastTemplateApp);
			lastTemplateEncodeApp="${encodeName}";
			//createCookie("lastTemplateEncodeApp",lastTemplateEncodeApp);						
		}
	}
});


function showEncodeTab() {
	/*
	if("${mode}"=="edit" && lastTab!='Encode')
	{
		lastTab='Encode';
		alert("need to show template");
		return;
	}
	*/
	lastTab='Encode';
	createCookie("lastTab",lastTab);
	$('#TabEncode').show();
	$('#TabEditEncode').show();
	$('#Encode').addClass('active');	
}

</script>





