<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<script src="js/wowza-facebook.js"></script>
<%@ include file="/WEB-INF/jsp/applications/common/streamtarget/streamTargetsCommon.jsp" %>

<div>
    <div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
    </div>
	<div class="row">
		<div class="col-md-5">
			<c:set var="protocolLabel">
				<c:if test="${destinationName!='wowzastreamingcloud' && destinationName!='wowzacdn'}">
					(${protocol})
				</c:if>
			</c:set>
			<happ> ${wmsutil:escapeHtml(appName)} >  ${wmsutil:escapeHtml(streamTargetName)} ${protocolLabel}</happ><br>
			<small class="text-muted">${uiAppType}</small>
		</div>
		<wmsform:applicationbuttons page="streamtarget"/>
	</div>
	<p><a href="javascript:returnToStreamTargets()"><i class="fa fa-arrow-left"></i> <wmsform:getlocalestring page="appconfig.streamTargets" obj="return"/></a></p>

	<sec:authorize access="hasAnyRole('advUser')">
	    <div class="row">
			<div class="col-md-12">
				<ul class="nav nav-tabs" >
					<li id="StreamTargetBasic" class="active">
						<a href="javascript:showBasicTab('transition')">Basic</a>
					</li>
					<li id="StreamTargetAdvanced" >
						<a href="javascript:showAdvTab('transition')">Advanced</a>
					</li>
					<li id="StreamTargetCustom" >
						<a href="javascript:showCustomTab('transition')">Custom</a>
					</li>
		    	</ul>
		    </div>
		</div>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	<div class="row" id="tabContent">
		<div class="col-md-12">
	      	<div class="row">
				<div id="ViewMode">
					<div id="TabBasic" style="display:none">
						<jsp:include page="ViewBasic.jsp" flush="true" />
					</div>
					<div id="TabAdv" style="display:none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
				 	</div>
					<div id="TabCustom" style="display:none">
						<jsp:include page="ViewCustom.jsp" flush="true" />
				 	</div>
				 </div>

				<form:form method="post" commandName="formData" id="defaultForm">
					<form:hidden path="vhost"/>
					<form:hidden path="uiAppName"/>
					<form:hidden path="enabled"/>
					<form:hidden path="protocol"/>
					<form:hidden path="destinationName"/>
					<form:hidden path="destApplicationRequired"/>
					<form:hidden path="destAppInstanceRequired"/>
					<form:hidden path="usernameRequired"/>
					<form:hidden path="passwordRequired"/>
					<form:hidden path="wowzaCloudDestinationType"/>
					<form:hidden path="facebookUserName"/>
					<form:hidden path="facebookAccessToken"/>
					<form:hidden path="facebookDestName"/>
					<form:hidden path="facebookDestId"/>
					<form:hidden path="wowzaDotComFacebookUrl"/>
					<form:hidden path="wowzaFacebookAppId"/>
					<form:hidden path="wowzaCloudAdaptiveStreaming"/>
					<form:hidden path="wowzaCdnCloudAccountApiKey"/>
					<form:hidden path="wowzaCdnCloudAccountAccessKey"/>
					<form:hidden path="wowzaCdnCloudAccountName"/>
					<form:hidden path="wowzaCdnCloudAccountId"/>
					<form:hidden path="wowzaCdnCloudTargetId"/>
					<form:hidden path="wowzaCdnCloudPlaybackUrl"/>

					<div id="EditMode">
						<div id="TabEditBasic" style="display:none">
							<jsp:include page="EditBasic.jsp" flush="true" />
						</div>
						<div id="TabEditAdv" style="display:none">
							<jsp:include page="EditAdv.jsp" flush="true" />
						</div>
						<div id="TabEditCustom" style="display:none">
							<jsp:include page="EditCustom.jsp" flush="true" />
						</div>
				 	</div>
				</form:form>
				<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
					<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
				</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>
</div>

<script>
var inWizard = false;

$(document).ready(function() {
	var scope = ["publish_video", "manage_pages", "publish_pages", "publish_to_groups", "pages_show_list", "business_management"];
	var wowzaURL = $("#wowzaDotComFacebookUrl").val();
	var wowzaAppId = $("#wowzaFacebookAppId").val();
	WOWZA.Facebook.init(scope, wowzaURL, wowzaAppId);
	
	if(typeof(lastTab) === 'undefined') {
		lastTab="Basic";
	}

	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();
		$('#EditMode').show();
		$('#AppButtons').hide();
	}
	else
	{
		$('#ViewMode').show();
		$('#EditMode').hide();
		$('#AppButtons').hide();
	}
	if("${idx}"=="-1")
	{
		lastTab='Basic';
		showBasicTab("new");
		$('#StreamTargetAdvanced').hide();
	}
	else if(lastTab=="Advanced")
	{
		showAdvTab("new");
	}
	else if(lastTab=="Custom")
	{
		showCustomTab("new");
	}
	else
	{
		showBasicTab("new");
	}
});

function showBasicTab(event) {
	if (event == "transition")
	{
		lastTab='Basic';
		showStreamTarget();
	}
	else
	{
		mode = "View";
		if("${mode}"=="edit")
		{
			mode = "Edit";
		}
		showConfigs("basic", mode);

		if("${mode}"=="edit" && lastTab!='Basic')
		{
			lastTab='Basic';
			showStreamTarget();
		}
		lastTab='Basic';
		createCookie("lastTab",lastTab);

		$('#TabAdv').hide();
		$('#TabEditAdv').hide();
		$('#StreamTargetAdvanced').removeClass('active');
		$('#TabCustom').hide();
		$('#TabEditCustom').hide();
		$('#StreamTargetCustom').removeClass('active');

		if (mode == "View")
		{
			$('#TabBasic').show();
		}
		else
		{
			$('#TabEditBasic').show();
		}
		$('#StreamTargetBasic').addClass('active');
	}
}

function showAdvTab(event) {
	if (event == "transition")
	{
		lastTab='Advanced';
		showStreamTarget();
	}
	else
	{
		mode = "View";
		if("${mode}"=="edit")
		{
			mode = "Edit";
		}
		showConfigs("advanced", mode);

		if("${mode}"=="edit" && lastTab!='Advanced')
		{
			lastTab='Advanced';
			showStreamTarget();
		}
		lastTab='Advanced';
		createCookie("lastTab",lastTab);
		$('#TabBasic').hide();
		$('#TabEditBasic').hide();
		$('#StreamTargetBasic').removeClass('active');
		$('#TabCustom').hide();
		$('#TabEditCustom').hide();
		$('#StreamTargetCustom').removeClass('active');

		if ("${mode}"=="view")
		{
			$('#TabAdv').show();
		}
		else
		{
			$('#TabEditAdv').show();
		}
		$('#StreamTargetAdvanced').addClass('active');
	}
}

function showCustomTab(event) {
	if (event == "transition")
	{
		lastTab='Custom';
		showStreamTarget();
	}
	else
	{
		mode = "View";
		if("${mode}"=="edit")
		{
			mode = "Edit";
		}

		showConfigs("custom", mode);

		if("${mode}"=="edit" && lastTab!='Custom')
		{
			lastTab='Custom';
			showStreamTarget();
		}
		lastTab='Custom';
		createCookie("lastTab",lastTab);
		$('#TabBasic').hide();
		$('#TabEditBasic').hide();
		$('#StreamTargetBasic').removeClass('active');
		$('#TabAdv').hide();
		$('#TabEditAdv').hide();
		$('#StreamTargetAdvanced').removeClass('active');

		if ("${mode}"=="view")
		{
			$('#TabCustom').show();
		}
		else
		{
			$('#TabEditCustom').show();
		}
		$('#StreamTargetCustom').addClass('active');
	}
}

function editStreamTarget()
{
	loadAjaxMainContent("applications/${appType}/streamtarget/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamTargetName=${wmsutil:urlEncode(streamTargetName)}");
}

function showStreamTarget()
{
	loadAjaxMainContent("applications/${appType}/streamtarget/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamTargetName=${wmsutil:urlEncode(streamTargetName)}");
}

function saveStreamTarget()
{
	if (validateBasicConfigOptions())
	{
		postAJAXForm('applications/${appType}/streamtarget/edit.htm');
	}
}

</script>
