<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About JVC ProHD Camcorders</h4>
<p>JVC ProHD camcorders enable delivery of IP video over the Internet. They have a built-in streaming encoder and network connectivity for capturing and publishing live video to Wowza Streaming Engine servers. Use this page to create connection settings that enable this application to deliver the camcorder's video output to players. For detailed instructions, see <a href="https://www.wowza.com/docs/how-to-connect-jvc-prohd-camcorders-to-wowza-streaming-engine" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Connect JVC ProHD camcorders to Wowza Streaming Engine</a>.</p>

<blockquote><strong>Note:</strong> JVC is a <a href="https://www.wowza.com/partners" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Works with Wowza&#8482;</a> partner.</blockquote>

<h4>Configure the Connection Type</h4>
<p>If your camcorder will use the <strong>MPEG-TS&#47;UDP</strong> connection type, select <strong>My camcorder uses MPEG-TS&#47;UDP transport mode</strong>, and then do the following:</p>

<ol><li>Enter a name for your stream in <strong>Stream Name</strong>. The stream name can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (' and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.<br>
The stream name is used to create a stream file that replaces (aliases) the JVC camcorder's complex stream URI so that players can use the stream file name in playback URLs in place of the camcorder's complex stream name. Stream files are stored in an application's streaming file directory and have a <strong>.stream</strong> file name extension. You must enter a stream name value that creates a unique stream file name.</li>
<li>Enter the camcorder's MPEG-TS port in <strong>MPEG-TS UDP Port</strong>. Use <strong>6504</strong> as a default port value or refer to your camcorder user manual to determine the correct port value.</li>
<li>Click <strong>Create Connection</strong>. Wowza Streaming Engine will create the JVC camcorder stream URI in the stream file, and then connect to the camcorder stream URI to re-stream the camcorder's output to players. If the camcorder is offline, the Wowza Streaming Engine instance will try to connect every 3&nbsp;seconds until the camcorder comes online.</li></ol>

<p>If your camcorder will use the <strong>RTMP</strong> connection type, select <strong>My camcorder uses RTMP</strong>.</p>

<blockquote><strong>Note</strong>: Your JVC ProHD camcorder must use the latest firmware that supports the RTMP protocol.<br>
<a href="http://www.wowza.com/docredirect.php?doc=external_encodersJVCProHDFirmware" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Download JVC ProHD firmware</a></blockquote>

<h4>Configure the Camcorder</h4>
<blockquote><strong>Note</strong>: Refer to your JVC camcorder Operation Manual for detailed instructions.</blockquote>

<ol><li>Press the <strong>MENU&#47;THUMB</strong> button on the side control panel of the camcorder or on the LCD monitor to display the menu screen on the LCD monitor and viewfinder.</li>
<li>Select <strong>Main Menu</strong> &gt; <strong>System</strong> &gt; <strong>Network&#47;Settings</strong> &gt; <strong>Live Streaming Set</strong>.</li>
<li>For <strong>MPEG-TS</strong> connections, set the <strong>Type</strong> to <strong>MPEG2-TS/UDP</strong>.<br>
For <strong>RTMP</strong> connections, set the <strong>Type</strong> to <strong>RTMP</strong>, enter the Wowza Streaming Engine application URL (rtmp://[wowza-ip-address]:[port]/[application]) in <strong>Destination URL</strong>, and a stream name in <strong>Stream Key</strong>.</li>
<li>Configure any other required encoding settings for your broadcast.</li>
<li>To start distributing the video, set <strong>Live Streaming</strong> to <strong>On</strong> in the <strong>Live Streaming Set</strong> screen (found in <strong>Main Menu</strong> &gt; <strong>System</strong> &gt; <strong>Network&#47;Settings</strong> &gt; <strong>Live Streaming Set</strong>).</li></ol>

<blockquote><strong>Note</strong>: JVC ProHD camcorders don't support RTMP authentication. If you use the RTMP connection type, turn off authentication for RTMP sources on the <strong><a href="javascript:loadSourceSecurity()">Source Security</a></strong> page for this application.</blockquote>