<%@ include file="/WEB-INF/jsp/taglibs.jsp"%>

<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="vhost"/>
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType"/>
	<form:hidden path="section" />
	<form:hidden path="action" />
	<form:hidden path="publishUserOptions" />
</fieldset>

<p><a href="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','publishers')"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="appconfig.publishers" obj="incoming.returnlink" /></a></p>
<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

<div class="row">
	<div class="col-md-12">
		<div class="media">
			<img src="img/${encoderName}-logo.png" />
			<div class="media-body">
				<p class="lead">
					<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.${encoderName}.description" />
				</p>
			</div>
			<div class="text-muted">
				<c:choose>
					<c:when test="${encoderName=='matrox'}">
						<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.${encoderName}.description2" />
					</c:when>
				</c:choose>
			</div>
		</div>
	</div>
</div>
<div class="row live-encoder" id="${encoderName}">
	<ol style="font-weight: bold;">
		<li style="padding-bottom:0px;"><h5><b><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.liveenc.step1" /></b></h5>
			<div class="row">
				<div class="col-md-12">
					<!--  have to set the fmlePublishUser id for every single encoder page to a unique value  -->
					<wmsform:editproperty page="appconfig.publishers.encoders" obj="hostServer" cssSize="col-md-4" cssClass="form-control" required="true"/>
					<wmsform:editproperty page="appconfig.publishers.encoders" obj="hostPort" cssSize="col-md-4" cssClass="form-control" required="true"/>
					<wmsform:editproperty page="appconfig.publishers.encoders" obj="streamName" cssSize="col-md-4" cssClass="form-control" required="true"/>
					<wmsform:editpropertydropdown obj="publishUser" page="appconfig.publishers.encoders" cssSize="col-md-4" />
				</div>
			</div></li>
		<li style="padding-bottom:5px;"><h5><b><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.liveenc.step2" /></b></h5>
			<div class="row">
				<div class="input-group col-md-7">
					<span class="input-group-btn"><button class="btn btn-default" name="downloadFile" id="downloadFile"><!-- Firefox still posts the form event. use jQuery instead of onClick="javascript:getEncoderConfigFile()" -->
							<i class="fa fa-download"></i>
							<fmt:message key='appconfig.publishers.encoders.liveenc.download' />
						</button></span>
				</div>
			</div></li>
		<li style="padding-bottom:5px;"><h5><b><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.liveenc.step3" /></b></h5>
			<div class="row">
				<div class="col-md-12">
					<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.${encoderName}.support" />
				</div>
			</div></li>
	</ol>
</div>
<script>
$(document).ready(function() {
	$('#downloadFile').click(function(event) {
		//validate the form data
		postAJAXForm('applications/${appType}/publishers/encoder/validateEncoder.htm','appName=${wmsutil:urlEncode(appName)}'); // vhost is included in form:hidden vhost=${wmsutil:urlEncode(vhost)}&
		// we are in a form:form where method is post (MainAppView.jsp). prevent that.
		event.preventDefault ? event.preventDefault() : event.returnValue = false;
	});

	if ( $("#action").val() == "jspAction" )
	{
		//validated the form data, now take action
		//IE can't access action.value, use jquery
		$("#action").val("false");
		var page = "applications/${appType}/${appSection}/encoder/";
		var win="_blank";
		if ("${encoderName}"=="newtek") {
			page += "${encoderName}"+".html";
		}
		else {
			page += "${encoderName}"+".xml";
		}

		//without setter defined grab visible //var serv = $("input[name='hostServer']:visible").val();
		var params = { "streamName" : $("#streamName").val(),
		"vhost" : "${vhost}",
		"appName" : "${appName}",
		"publishUser" : $("select[id='publishUser'] option:selected").val(),
		"hostServer" : $("#hostServer").val(),
		"hostPort" : $("#hostPort").val()
		};

		//window.location.href = page + "?" + encodeParameters(params);
		window.open(page + "?" + encodeParameters(params), win);
		return false;
	}
});

function encodeParameters(data) {
	var ret = [];
	for ( var d in data)
		ret.push(encodeURIComponent(d) + "=" + encodeURIComponent(data[d]));
	return ret.join("&");
}
</script>
