<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>

<c:choose>
	<c:when test="${requestScope.formData['appType']=='live'}">
		<re:mark>This is the player page for Live app type</re:mark>
		<h4>About Wowza Player</h4>
		<p>Use this page to pass information about your live stream to Wowza Player Builder, where you can customize your player and create your player embed code. For detailed instructions on how to get and configure Wowza Player, see <a href="https://www.wowza.com/docs/getting-started-with-wowza-player" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Get started with Wowza Player</a>.</p>

		<p>To send a live stream playback URL to Wowza Player Builder, select the playback URL for an incoming stream that's published to this application in <strong>Select a playback URL</strong> or enter a live stream playback URL in <strong>Enter a playback URL</strong>.</p>

		<p>If you have configured your media server with an SSL certificate, you can select either HTTP or secure HTTP streaming (HTTPS) versions of your published stream playback URLs in the <strong>Select a playback URL</strong> list. Wowza provides free 256-bit SSL certificates to users with Perpetual and Subscription licenses via the <a href="https://www.wowza.com/docs/how-to-get-ssl-certificates-from-the-streamlock-service" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza StreamLock&#8482; AddOn</a></p>

		<p>If this application is delivering a live stream via the Stream Targets feature to a CDN, and if that CDN provides an Apple HLS playback URL, you can enter that URL in <strong>Enter a playback URL</strong>.

		If this application is delivering a live stream that's transcoded to multiple output renditions, you can enter the Apple HLS URL for the SMIL file or Stream Name Group that describes the adaptive bitrate stream in <strong>Enter a playback URL</strong>.</p>

		<blockquote><strong>Notes:</strong><br />If your Wowza Streaming Engine host server address is null, you have to enter the media server's IP address in <strong>Stream Source (HLS)</strong> in Wowza Player Builder.<br /><br />If you're using the Google Chrome browser and the Player Builder webpage doesn't launch when you click <strong>Launch Player Builder</strong>, you may have to allow pop-ups for Wowza Streaming Engine Manager. Click the <strong>Pop-ups blocked</strong> icon on the right side of the browser window address bar to allow the manager to create pop-ups, and then click <strong>Launch Player Builder</strong> again.</blockquote>

		</c:when>
</c:choose>
<c:choose>
	<c:when test="${requestScope.formData['appType']=='vod'}">
		<re:mark>This is the player page for VOD app type</re:mark>
		<h4>About Wowza Player</h4>
		<p>Use this page to pass information about your on-demand stream to Wowza Player Builder, where you can customize your player and create your player embed code. For detailed instructions on how to get and configure Wowza Player, see <a href="https://www.wowza.com/docs/getting-started-with-wowza-player" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Getting started with Wowza Player</a>.</p>

		<p>Create a complete Apple HLS playback URL by selecting a <strong>Host</strong> IP address and entering the details for your video source file asset in the <strong>Instance</strong> and <strong>File Path</strong> boxes in the URL. A preview of the URL that will be passed to Player Builder is shown next to <strong>Result</strong>. </p>

		<p>If you have configured your media server to use an SSL certificate, you have the option of selecting a secure HTTP streaming (HTTPS) domain created from your certificate file in the <strong>Host</strong> list. Wowza provides free 256-bit SSL certificates to users with Perpetual and Subscription licenses via the <a href="https://www.wowza.com/docs/how-to-get-ssl-certificates-from-the-streamlock-service" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza StreamLock AddOn</a>.</p>

		<blockquote><strong>Note:</strong> If your Wowza Streaming Engine host server address is null, you have to enter the media server's address in <strong>Stream Source (HLS)</strong> in Wowza Player Builder.</blockquote>

		<p>To connect to the default application instance, keep the default application instance name (<strong>_definst_</strong>) in the <strong>Instance</strong> box. If you're streaming a video file from a subfolder of the default <strong>content</strong> folder (<strong>[installdir]/content</strong>), you must keep the application instance in your playback URL. </p>

		<p>Enter the <strong>File Path</strong> for your video source. This path is composed of a media type prefix, the relative file path from <strong>[installdir]/content</strong>, the file name, and file extension. If the video source file is in the default <strong>content</strong> folder, omit the file path and prepend the media type prefix to the file name. For more information on media type prefixes, see <a href="https://www.wowza.com/docs/understanding-streaming-protocols-and-output-file-formats#supportedMedia" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Supported media file formats</a>. </p>

		<p>The following are some examples of what to enter and the resulting playback URLs.</p>

		<p>To stream <strong>sample.mp4</strong> from the default <strong>content</strong> folder, enter <strong>sample.mp4</strong> in <strong>File Path</strong>. You don't have to specify a media type prefix when streaming mp4 files.</p>

		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>sample.mp4</strong>&#47;playlist&#46;m3u8</ul>

		<p>To stream other types of media files from the default <strong>content</strong> folder, enter the media type prefix and the full file name in <strong>File Path</strong>.</p>
		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>flv&#58;sample&#46;flv</strong>&#47;playlist&#46;m3u8</ul>

		<p>To stream an adaptive bitrate set of files in the default <strong>content</strong> folder, enter the SMIL file name with the <strong>smil:</strong> media prefix in <strong>File Path</strong>.</p>
		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>smil&#58;myStream&#46;smil</strong>&#47;playlist&#46;m3u8</ul>

		<p>To stream <strong>sample.flv</strong> from <strong>[install-dir]/content/myVideos</strong>, enter <strong>flv:myVideos/sample.mp4</strong> in <strong>File Path</strong>.</p>
		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>flv&#58;myVideos&#47;sample&#46;mp4</strong>&#47;playlist&#46;m3u8</ul>

		<blockquote><strong>Note:</strong> If you're using the Google Chrome browser and the Player Builder webpage doesn't launch when you click <strong>Launch Player Builder</strong>, you may have to allow pop-ups for Wowza Streaming Engine Manager. Click the <strong>Pop-ups blocked</strong> icon on the right side of the browser window address bar to allow the manager to create pop-ups, and then click <strong>Launch Player Builder</strong> again.</blockquote>
	</c:when>
</c:choose>
<c:choose>
	<c:when test="${requestScope.formData['appType']=='vodedge'}">
		<re:mark>This is the player page for VODEdge app type</re:mark>
		<h4>About Wowza Player</h4>
		<p>Use this page to pass information about your on-demand stream to Wowza Player Builder, where you can customize your player and create your player embed code. For detailed instructions on how to get and configure Wowza Player, see <a href="https://www.wowza.com/docs/getting-started-with-wowza-player" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Getting started with Wowza Player</a>.</p>

		<p>Create a complete Apple HLS playback URL by selecting a <strong>Host</strong> IP address and a <Strong>Media Cache</Strong> source and entering the details for your video source file asset in the <strong>Instance</strong> and <strong>File Path</strong> boxes in the URL. A preview of the URL that will be passed to Player Builder is shown next to <strong>Result</strong>. </p>

		<p>If you have configured your media server to use an SSL certificate, you have the option of selecting a secure HTTP streaming (HTTPS) domain created from your certificate file in the <strong>Host</strong> list. Wowza provides free 256-bit SSL certificates to users with Perpetual and Subscription licenses via the <a href="https://www.wowza.com/docs/how-to-get-ssl-certificates-from-the-streamlock-service" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza StreamLock AddOn</a>.</p>

		<blockquote><strong>Note:</strong> If your Wowza Streaming Engine host server address is null, you have to enter the media server's address in <strong>Stream Source (HLS)</strong> in Wowza Player Builder.</blockquote>

		<p>To connect to the default application instance, keep the default application instance name (<strong>_definst_</strong>) in the <strong>Instance</strong> box.</p>
		
		<p>Enter the <strong>File Path</strong> for your video source. This path is composed of a media type prefix, the file name, and file extension. For more information on media type prefixes, see <a href="https://www.wowza.com/docs/understanding-streaming-protocols-and-output-file-formats#supportedMedia" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Supported media file formats</a>. </p>

		<p>The following are some examples of what to enter and the resulting playback URLs.</p>

		<p>To stream <strong>sample.mp4</strong> from a Media Cache source with the prefix <strong>http/</strong>, enter <strong>sample.mp4</strong> in <strong>File Path</strong>. You don't have to specify a media type prefix when streaming mp4 files.</p>

		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>http</strong>&#47;<strong>sample.mp4</strong>&#47;playlist&#46;m3u8</ul>

		<p>To stream other types of media files from a Media Cache source with the prefix <strong>http/</strong>, enter the media type prefix and the full file name in <strong>File Path</strong>.</p>
		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>http</strong>&#47;<strong>flv&#58;sample&#46;flv</strong>&#47;playlist&#46;m3u8</ul>

		<p>To stream an adaptive bitrate set of files from a Media Cache source with the prefix <strong>http/</strong>, enter the SMIL file name with the <strong>smil:</strong> media prefix in <strong>File Path</strong>.</p>
		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>http</strong>&#47;<strong>smil&#58;myStream&#46;smil</strong>&#47;playlist&#46;m3u8</ul>

		<p>To stream <strong>sample.flv</strong> from a Media Cache source with the prefix <strong>http/</strong>, enter <strong>flv:myVideos/sample.mp4</strong> in <strong>File Path</strong>.</p>
		<ul>http&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;1935&#47;<wbr>vod&#47;&#95;definst&#95;&#47;<strong>flv&#58;myVideos&#47;sample&#46;mp4</strong>&#47;playlist&#46;m3u8</ul>

		<blockquote><strong>Note:</strong> If you're using the Google Chrome browser and the Player Builder webpage doesn't launch when you click <strong>Launch Player Builder</strong>, you may have to allow pop-ups for Wowza Streaming Engine Manager. Click the <strong>Pop-ups blocked</strong> icon on the right side of the browser window address bar to allow the manager to create pop-ups, and then click <strong>Launch Player Builder</strong> again.</blockquote>
	</c:when>
</c:choose>
