<?php
ini_set("date.timezone","America/Sao_Paulo");
ini_set("max_execution_time", 1800);

require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/conecta.php");
require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/funcoes.php");

// Funes Internas Estatisticas
function get_stats_robot($ip,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":555/stats");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
curl_setopt($ch, CURLOPT_USERPWD, "admin:".code_decode($senha,"D").""); 
curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); 
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; pt-BR; rv:1.9.2.3) Gecko/20100401 Firefox/3.6.3 ( .NET CLR 3.5.30729)');
$resultado = curl_exec($ch);
curl_close($ch);

return $resultado;
}

function pais_ip_ec($ip,$tipo) {

$dados_api_geoip = api_geoip_ec($ip);

$pais_codigo = $dados_api_geoip["pais_sigla"];
$pais_nome = $dados_api_geoip["pais_nome"];

if($tipo == "nome") {
return $pais_nome;
} else {
return $pais_codigo;
}

}

function api_geoip_ec($ip) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://geoip-db.com/json/".$ip);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); 
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE); 
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.2) Gecko/20100115 Firefox/3.6 (.NET CLR 3.5.30729)');
$resultado = curl_exec($ch);
curl_close($ch);

$dados_geoip = json_decode($resultado);

$pais_codigo = ($dados_geoip->country_code) ? $dados_geoip->country_code : "desconhecido";
$pais_nome = ($dados_geoip->country_name) ? utf8_decode($dados_geoip->country_name) : "Desconhecido/Unknown";

return array("pais_sigla" => $pais_codigo, "pais_nome" => $pais_nome, "estado" => utf8_decode(addslashes($dados_geoip->state)), "cidade" => utf8_decode(addslashes($dados_geoip->city)), "latitude" => $dados_geoip->latitude , "longitude" => $dados_geoip->longitude );
}

// Fim funcoes internas

$inicio_execucao = tempo_execucao();

parse_str($argv[1]);

list($inicial,$final) = explode("-",$registros);

echo "\n\n--------------------------------------------------------------------\n\n";

// Grava cache com o XML do wowza de todos os servidores
$sql_servidores = mysqli_query($conexao,"SELECT * FROM servidores where status = 'on' ORDER by ordem ASC");
while ($dados_servidor = mysqli_fetch_array($sql_servidores)) {

$xml_wowza = simplexml_load_string(utf8_encode(get_stats_robot($dados_servidor["ip"],$dados_servidor["senha"])));

$array_xml["stats"][$dados_servidor["codigo"]] = $xml_wowza;

echo "Servidor Wowza: ".$dados_servidor["nome"]."\n";
echo "\n--------------------------------------------------------------------\n\n";

echo $xml_wowza;

}

echo "\n--------------------------------------------------------------------\n\n";

$array_user_agents = array("Wirecast","Teradek","vmix","Vmix","FMLE");

// Gera as estatisticas
$sql = mysqli_query($conexao,"SELECT * FROM streamings where status = '1' ORDER by login ASC LIMIT ".$inicial.", ".$final."");
while ($dados_stm = mysqli_fetch_array($sql)) {

$array_espectadores = array();

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

if($dados_servidor["status"] == "on") {

$xml_stats_wowza = $array_xml["stats"][$dados_servidor["codigo"]];

$total_registros_wowza = count($xml_stats_wowza->VHost->Application);

if($total_registros_wowza > 0) {

for($i=0;$i<$total_registros_wowza;$i++){

if($xml_stats_wowza->VHost->Application[$i]->Name == $dados_stm["login"] && ($xml_stats_wowza->VHost->Application[$i]->Status == "loaded" || $xml_stats_wowza->VHost->Application[$i]->Status == "")) {

$total_espectadores_wowza = count($xml_stats_wowza->VHost->Application[$i]->ApplicationInstance->Client);

for($ii=0;$ii<$total_espectadores_wowza;$ii++){

if(!@strstr($xml_stats_wowza->VHost->Application[$i]->ApplicationInstance->Client[$ii]->FlashVersion,$array_user_agents)) {

$ip_wowza = $xml_stats_wowza->VHost->Application[$i]->ApplicationInstance->Client[$ii]->IpAddress;
$tempo_conectado_wowza = $xml_stats_wowza->VHost->Application[$i]->ApplicationInstance->Client[$ii]->TimeRunning;
$player_wowza = ($xml_stats_wowza->VHost->Application[$i]->ApplicationInstance->Client[$ii]->Type == "rtmp") ? "Flash" : "HTML5";

if(filter_var($ip_wowza, FILTER_VALIDATE_IP)) {
$array_espectadores["".$ip_wowza.""] = $tempo_conectado_wowza."|".pais_ip_ec($ip_wowza,"nome")."|".$player_wowza."";
}

}

}

break;

}

}

}

// Insere os espectadores no banco de dados
foreach($array_espectadores as $ip => $espectador) {

list($tempo_conectado, $pais, $player) = explode("|",$espectador);

if(!empty($ip) && !empty($tempo_conectado) && !empty($pais) && !empty($player)) {

$verifica_espectador = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND (ip = '".$ip."' AND data = '".date("Y-m-d")."')"));

if($verifica_espectador == 0) {

// Verifica se ja tem no banco de dados de geoip e usa banco de dados ao invez da API
$verifica_ip_geoip_db_atual = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM geoip where ip = '".$ip."'"));

if($verifica_ip_geoip_db_atual == 0) {

$dados_api_geoip = api_geoip_ec($ip);

$ip_pais_codigo = $dados_api_geoip["pais_sigla"];
$ip_pais_nome = $dados_api_geoip["pais_nome"];
$ip_estado = $dados_api_geoip["estado"];
$ip_cidade = $dados_api_geoip["cidade"];

$latitude = $dados_api_geoip["latitude"];
$longitude = $dados_api_geoip["longitude"];

$db_usado = "GEOIP";

mysqli_query($conexao,"INSERT INTO geoip (ip,pais_sigla,pais_nome,estado,cidade,latitude,longitude) VALUES ('".$ip."','".$ip_pais_codigo."','".$ip_pais_nome."','".$ip_estado."','".$ip_cidade."','".$latitude."','".$longitude."')");

} else {

$dados_ip_geoip_db = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM geoip where ip = '".$ip."'"));

$ip_pais_codigo = $dados_ip_geoip_db["pais_sigla"];
$ip_pais_nome = $dados_ip_geoip_db["pais_nome"];
$ip_estado = $dados_ip_geoip_db["estado"];
$ip_cidade = $dados_ip_geoip_db["cidade"];

$db_usado = "DB";

}

mysqli_query($conexao,"INSERT INTO estatisticas (codigo_stm,data,hora,ip,pais,estado,cidade,tempo_conectado,player) VALUES ('".$dados_stm["codigo"]."',NOW(),NOW(),'".$ip."','".$ip_pais_nome."','".addslashes($ip_estado)."','".addslashes($ip_cidade)."','".$tempo_conectado."','".$player."')") or die("Erro MySQL: ".mysqli_error());

echo "[".$dados_stm["login"]."][".$db_usado."] Espectador: ".$ip." adicionado.\n";

} else {

mysqli_query($conexao,"Update estatisticas set tempo_conectado = '".$tempo_conectado."' where codigo_stm = '".$dados_stm["codigo"]."' AND (ip = '".$ip."' AND data = '".date("Y-m-d")."')") or die("Erro MySQL: ".mysqli_error());

echo "[".$dados_stm["login"]."] Espectador: ".$ip." atualizado.\n";

}

}

} // foreach

} // status servidor

} // while

$fim_execucao = tempo_execucao();

$tempo_execucao = number_format(($fim_execucao-$inicio_execucao),2);

echo "\n\n--------------------------------------------------------------------\n\n";
echo "Tempo: ".$tempo_execucao." segundo(s);\n\n";
?>
