#!/bin/sh
# @configurar-ssl-revenda - Script para configurar SSL para dominio da revenda

# Muda prioridade de execussao
renice -20 $$

count=0

sed -i -e 's/\r$//' /home/painelvideo/public_html/admin/lista_dominios_revendas_configurar_ssl.txt

for dominios in `cat /home/painelvideo/public_html/admin/lista_dominios_revendas_configurar_ssl.txt`;
do

dominio_painel=`echo $dominios | cut -d '/' -f 1`
dominio_player=`echo $dominios | cut -d '/' -f 2`

/etc/certbot-auto -n certonly --webroot --webroot-path /home/painelvideo/public_html -d $dominio_painel
/etc/certbot-auto -n certonly --webroot --webroot-path /home/painelvideo/public_html/player -d $dominio_player

if [ -f "/etc/letsencrypt/live/$dominio_painel/cert.pem" ]; then

cat <<EOT > /etc/httpd/conf.d/$dominio_painel.conf
NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painelvideo/public_html
    ServerName $dominio_painel

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_painel/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_painel/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_painel/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

count=`expr $count + 1`

echo
echo "[Painel] $dominio_painel configurado com sucesso."

fi

if [ -f "/etc/letsencrypt/live/$dominio_player/cert.pem" ]; then

cat <<EOT > /etc/httpd/conf.d/$dominio_player.conf
NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painelvideo/public_html/player
    ServerName $dominio_player

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_player/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_player/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_player/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

echo "[Player] $dominio_player configurado com sucesso."

fi

sed -i "/$dominio_painel/d" /home/painelvideo/public_html/admin/lista_dominios_revendas_configurar_ssl.txt

echo

done

if [ "$count" -gt 0 ]; then
systemctl reload httpd
fi

