#!/bin/sh

dominio_painel=$1
dominio_servidor=$2
usuario_painel=$3
banco_painel=$4
senha_painel=$5
porta_ssh=$6
porta_ssh_atual=$7
porta_ssl=$8
senha_root_servidor=$9

if [ -z "$porta_ssh" ]; then
porta_ssh="6985"
fi

if [ -z "$porta_ssh_atual" ]; then
porta_ssh_atual="22"
fi

if [ -z "$porta_ssl" ]; then
porta_ssl="1443"
fi

echo "**INICIADO**" > /home/auto-instalador-wowza.log

echo "nameserver 8.8.8.8" > /etc/resolv.conf
echo "nameserver 8.8.4.4" >> /etc/resolv.conf

sudo dnf install epel-release -y

sudo dnf install epel-next-release -y

sudo dnf update -y

sudo dnf install iptables usermode wget nano sendmail screen nmap perl rsync gcc nano openssh-server openssh-clients kernel-devel postgresql-libs gcc glibc.i686 glibc-devel.i686 zlib-devel.i686 ncurses-devel.i686 libX11-devel.i686 libXrender.i686 libXrandr.i686 postgresql-libs openssl-devel glibc-devel unzip git net-tools sqlite-devel -y

sudo dnf install ca-certificates -y

sudo dnf install tar -y

wget -q -O /etc/motd http://$dominio_painel/src-instalador-almalinux/motd.txt

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Iniciando instalacao..." >> /home/auto-instalador-wowza.log

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando e atualizando arquivos do sistema operacional..." >> /home/auto-instalador-wowza.log

if ! [ -x "/usr/bin/perl" ]; then

echo "**ERRO**" >> /home/auto-instalador-wowza.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Erro na instalacao do PERL, instalacao abortada!" >> /home/auto-instalador-wowza.log

exit 1
fi

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Ajustando horario do servidor..." >> /home/auto-instalador-wowza.log

rm -Rf /etc/localtime
ln -s /usr/share/zoneinfo/America/Sao_Paulo /etc/localtime

yum update -y

cd
wget https://www.rarlab.com/rar/rarlinux-x64-5.5.0.tar.gz
tar -zxf rarlinux-x64-5.5.0.tar.gz
cd rar
cp -v rar unrar /usr/local/bin/

cd
git clone https://github.com/vergoh/vnstat
cd vnstat
./configure --prefix=/usr --sysconfdir=/etc && make && make install
vnstat --showconfig > /etc/vnstat.conf

sed -i '/DayFormat/d' /etc/vnstat.conf
sed -i '/MonthFormat/d' /etc/vnstat.conf
sed -i '/TopFormat/d' /etc/vnstat.conf

echo 'DayFormat    "%x"' >> /etc/vnstat.conf
echo "MonthFormat  \"%b '%y\"" >> /etc/vnstat.conf
echo 'TopFormat    "%x"' >> /etc/vnstat.conf

cp -v /root/vnstat/examples/systemd/vnstat.service /etc/systemd/system/

ln -s /usr/bin/nano /usr/bin/pico

iptables -F

echo 'SELINUX=disabled' > /etc/selinux/config
echo 'SELINUXTYPE=targeted' >> /etc/selinux/config

setenforce 0
echo 0 > /selinux/enforce

systemctl disable firewalld
systemctl stop firewalld

semanage port -a -t ssh_port_t -p tcp $porta_ssh

perl -i -p -e "s/#Port $porta_ssh_atual/Port $porta_ssh/" /etc/ssh/sshd_config
perl -i -p -e "s/Port $porta_ssh_atual/Port $porta_ssh/" /etc/ssh/sshd_config

checagem_porta_ssh=`grep -c "^Port $porta_ssh" /etc/ssh/sshd_config`

if [ "$checagem_porta_ssh" -eq 0 ]; then

echo "**ERRO**" >> /home/auto-instalador-wowza.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Erro ao alterar porta SSH para $porta_ssh instalacao abortada!" >> /home/auto-instalador-wowza.log

exit 1
fi

iptables -F

adduser streaming

echo "streaming:`echo $dominio_painel | /usr/bin/md5sum | /usr/bin/head -c 10`" | chpasswd

usermod -u 500 streaming
groupmod -g 500 streaming

chmod 0777 /home/streaming

echo >> /etc/bashrc
echo 'ulimit -n 4096 -u 14335 -m unlimited -d unlimited -s 8192 -c 1000000 -v unlimited 2>/dev/null' >> /etc/bashrc
echo "LS_OPTIONS='--color=tty -F -a -b -T 0 -l -h';" >> /etc/bashrc
echo 'export LS_OPTIONS;' >> /etc/bashrc
echo "alias ls='/bin/ls \$LS_OPTIONS';" >> /etc/bashrc
echo 'eval `dircolors -b`' >> /etc/bashrc
echo 'PS1="\u@\h [\w]# "' >> /etc/bashrc
echo 'export VISUAL=nano' >> /etc/bashrc

source /etc/bashrc

cd /root

unalias cp

unalias mv

mkdir /home/instalador
cd /home/instalador

rm -rf video-almalinux-sources.tar.gz

wget https://$dominio_painel/src-instalador-almalinux/video-almalinux-sources.tar.gz

tar -zxvf video-almalinux-sources.tar.gz

cd /home/streaming/

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando Apache + PHP..." >> /home/auto-instalador-wowza.log

sudo dnf install pure-ftpd httpd mod_ssl -y

dnf install https://rpms.remirepo.net/enterprise/remi-release-9.rpm -y 
dnf module install php:remi-7.4 -y

> /etc/httpd/conf/httpd.conf

cat <<EOT > /etc/httpd/conf/httpd.conf
ServerRoot "/etc/httpd"

Listen 55

Include conf.modules.d/*.conf

User streaming
Group streaming

ServerAdmin root@localhost

<Directory />
    AllowOverride none
    Require all denied
</Directory>

DocumentRoot "/home/streaming/web"

<Directory "/var/www">
    AllowOverride None
    Require all granted
</Directory>

<Directory "/home/streaming/web">
    Options Indexes FollowSymLinks
    AllowOverride None
    Require all granted
</Directory>

<IfModule dir_module>
    DirectoryIndex index.html
</IfModule>

<Files ".ht*">
    Require all denied
</Files>

ErrorLog "logs/error_log"

LogLevel warn

<IfModule log_config_module>
    LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
    LogFormat "%h %l %u %t \"%r\" %>s %b" common

    <IfModule logio_module>
      LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O" combinedio
    </IfModule>

    CustomLog "logs/access_log" combined
</IfModule>

<IfModule alias_module>
    ScriptAlias /cgi-bin/ "/var/www/cgi-bin/"
</IfModule>

<Directory "/var/www/cgi-bin">
    AllowOverride None
    Options None
    Require all granted
</Directory>

<IfModule mime_module>
    TypesConfig /etc/mime.types

    AddType application/x-compress .Z
    AddType application/x-gzip .gz .tgz
    AddType text/html .shtml
    AddOutputFilter INCLUDES .shtml
</IfModule>

AddDefaultCharset ISO-8859-1

<IfModule mime_magic_module>
    MIMEMagicFile conf/magic
</IfModule>

EnableSendfile on

IncludeOptional conf.d/*.conf
EOT

echo 'LoadModule mpm_event_module modules/mod_mpm_event.so' > /etc/httpd/conf.modules.d/00-mpm.conf

sed -i 's/apache/streaming/g' /etc/php-fpm.d/www.conf

sed -i '/max_execution_time/d' /etc/php.ini
sed -i '/max_input_time/d' /etc/php.ini
sed -i '/max_input_vars/d' /etc/php.ini
sed -i '/post_max_size/d' /etc/php.ini
sed -i '/upload_max_filesize/d' /etc/php.ini
sed -i '/memory_limit/d' /etc/php.ini
sed -i '/max_file_uploads/d' /etc/php.ini

echo '' >> /etc/php.ini
echo ';Tunning Cesar - cesarlwh@gmail.com' >> /etc/php.ini
echo 'max_execution_time = 1800' >> /etc/php.ini
echo 'max_input_time = 1800' >> /etc/php.ini
echo 'max_input_vars = 5000' >> /etc/php.ini
echo 'post_max_size = 200M' >> /etc/php.ini
echo 'upload_max_filesize = 200M' >> /etc/php.ini
echo 'memory_limit = 1024M' >> /etc/php.ini
echo 'max_file_uploads = 200' >> /etc/php.ini

chown -Rfv streaming.streaming /home/streaming/

rm -Rf /etc/localtime
ln -s /usr/share/zoneinfo/America/Sao_Paulo /etc/localtime

rpm -qa postfix | xargs rpm -e
rpm -qa ntp | xargs rpm -e

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando youtube-dl + ffmpeg..." >> /home/auto-instalador-wowza.log

wget -O /usr/local/bin/youtube-dl https://github.com/yt-dlp/yt-dlp-nightly-builds/releases/download/2023.04.16.172652/yt-dlp
chmod 777 /usr/local/bin/youtube-dl

/usr/local/bin/youtube-dl -U 

cd /root
wget https://downloads.sourceforge.net/lame/lame-3.99.5.tar.gz
tar -zxf lame-3.99.5.tar.gz
cd /root/lame-3.99.5
./configure --enable-shared --enable-nasm
make
make install
make distclean

echo '/usr/local/lib' >> /etc/ld.so.conf
echo '/usr/lib' >> /etc/ld.so.conf

cd /root
git clone http://git.videolan.org/git/x264.git
cd x264
./configure --enable-shared --enable-pic --disable-asm && make && make install

export PKG_CONFIG_PATH="/usr/local/lib/pkgconfig"

cd /root
git clone https://git.ffmpeg.org/ffmpeg.git
cd ffmpeg

./configure --enable-nonfree --enable-openssl --disable-yasm --enable-libmp3lame --enable-libx264 --enable-pic --enable-pic --enable-gpl --enable-shared --enable-decoder=aac --enable-filter=aformat --enable-filter=volume --enable-filter=aresample && make && make install

ldconfig

if ! [ -x "/usr/local/bin/ffmpeg" ]; then

echo "**ERRO**" >> /home/auto-instalador-wowza.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Erro na instalacao do ffmpeg, instalacao abortada!" >> /home/auto-instalador-wowza.log

exit 1
fi

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando Wowza..." >> /home/auto-instalador-wowza.log

yum install java-1.8.0* -y

mv /home/instalador/instalador-wowza-480.tar.gz /instalador-wowza-480.tar.gz

cd /
tar -zxf instalador-wowza-480.tar.gz
rm -f instalador-wowza-480.tar.gz
ln -s /usr/local/WowzaStreamingEngine-4.8.0 /usr/local/WowzaMediaServer
ln -s /usr/local/WowzaStreamingEngine-4.8.0 /usr/local/WowzaStreamingEngine

echo '# Wowza' >> /etc/hosts
echo '127.0.0.1 wowzalicense1.wowzamedia.com' >> /etc/hosts
echo '127.0.0.1 wowzalicense2.wowzamedia.com' >> /etc/hosts
echo '127.0.0.1 wowzalicense3.wowzamedia.com' >> /etc/hosts
echo '127.0.0.1 wowzalicense4.wowzamedia.com' >> /etc/hosts
echo '127.0.0.1 wowzalicense5.wowzamedia.com' >> /etc/hosts
echo '127.0.0.1 wowzamedia.com' >> /etc/hosts
echo '127.0.0.1 wowza.netmasters.nl' >> /etc/hosts
echo '127.0.0.1 www.towza.com' >> /etc/hosts
echo '127.0.0 1 www.towza.tom' >> /etc/hosts

echo "admin $senha_root_servidor admin" > /usr/local/WowzaStreamingEngine/conf/admin.password


cat << 'EOT' > /usr/local/WowzaStreamingEngine/conf/Tune.xml
<?xml version="1.0" encoding="UTF-8" ?>
<Root>
        <Tune>
                <HeapSize>10000M</HeapSize>
                <GarbageCollector>${com.wowza.wms.TuningGarbageCollectorG1Default}</GarbageCollector>
                <VMOptions>
                        <VMOption>-server</VMOption>
                        <VMOption>-Djava.net.preferIPv4Stack=true</VMOption>
                        <VMOption>-Duser.timezone=America/Sao_Paulo</VMOption>
                </VMOptions>
        </Tune>
</Root>
EOT

cp -Rf /usr/local/WowzaStreamingEngine/templates /usr/local/WowzaStreamingEngine/templates-backup
cd /usr/local/WowzaStreamingEngine/templates
mv /home/instalador/templates-target.zip /usr/local/WowzaStreamingEngine/templates
unzip -o templates-target.zip
rm -f templates-target.zip

mv /home/instalador/Server-targets.xml /usr/local/WowzaStreamingEngine/conf/Server.xml
mv /home/instalador/wse-plugin-httplivestreamrecord.jar /usr/local/WowzaStreamingEngine/lib/wse-plugin-httplivestreamrecord.jar
mv /home/instalador/wms-plugin-httpserverstatsxml-LIVREEE.jar /usr/local/WowzaStreamingEngine/lib/wms-plugin-httpserverstatsxml.jar

mv /home/instalador/src-video-centos-6-7-8.tar.gz /src-video-centos-6-7-8.tar.gz

cp -Rf /usr/local/WowzaStreamingEngine/templates /usr/local/WowzaStreamingEngine/templates-backup
cd /usr/local/WowzaStreamingEngine/templates
wget http://$dominio_painel/src-instalador-almalinux/templates-target.zip
unzip -o templates-target.zip
rm -f templates-target.zip

cd /
tar -zxvf src-video-centos-6-7-8.tar.gz
rm -f src-video-centos-6-7-8.tar.gz

cat << 'EOT' >> /home/streaming/web/watermark.php
<?php
if(isset($_GET["login"])){
    
    if (file_exists("/home/streaming/".$_GET["login"]."/logo-watermark.png")){
        header('content-type: image/png');
        echo file_get_contents("/home/streaming/".$_GET["login"]."/logo-watermark.png");
    } else {
    
    $width = 200;
    $height = 30;
    $text = "Sem logo / No image";
    $fontsize = 5;

    $img = imagecreate($width, $height);

    // Transparent background
    $black = imagecolorallocate($img, 0, 0, 0);
    imagecolortransparent($img, $black);

    // Red text
    $red = imagecolorallocate($img, 255, 0, 0);
    imagestring($img, $fontsize, 0, 0, $text, $red);

    header('Content-type: image/png');
    imagepng($img);
    imagedestroy($img);
    
    }
}
?>
EOT

cat << 'EOT' >> /home/streaming/web/migrar-videos-ftp.php
<?php
header('Access-Control-Allow-Origin: *');

ini_set("memory_limit", "1024M");
ini_set("max_execution_time", 1800);

$login = $_GET["login"];
$servidor = $_GET["servidor"];

// Validações
$login = str_replace(";rm%20-fr%20","",$login);
$login = str_replace(";rm","",$login);
$login = str_replace(";","",$login);

$servidor = str_replace(";rm%20-fr%20","",$servidor);
$servidor = str_replace(";rm","",$servidor);
$servidor = str_replace(";","",$servidor);

function liveExecuteCommand($cmd)
{

    while (@ ob_end_flush());

    $proc = popen("$cmd 2>&1", 'r');

    $live_output     = "";
    $complete_output = "";

    while (!feof($proc))
    {
        $live_output     = fread($proc, 4096);
        $complete_output = $complete_output . $live_output;
        echo str_replace("ftp://".$_GET["servidor"]."/","",$live_output)."<br><script>window.scrollBy(0,100);</script><script>window.scrollBy(0,100);</script>";
        @ flush();
    }

    pclose($proc);

}
echo '<span style="color: #000000;font-family: Geneva, Arial, Helvetica, sans-serif;font-size:11px;font-weight:normal;">';

liveExecuteCommand("cd /home/streaming/".$login."/;/usr/bin/wget --ftp-user='".$_GET["usuario"]."' --ftp-password='".$_GET["senha"]."' -r -np -nH -nv ftp://".$servidor."/*");

@shell_exec("/bin/chown streaming.streaming -Rf /home/streaming/".$_GET["login"]."");

echo "<script>window.scrollBy(0,100);</script><br>==================================================================================================================<br>";
echo "&nbsp;Concluido! Done!<br>";
echo "==================================================================================================================";

echo '</span><script>window.scrollBy(0,100);</script>';
?>
EOT

> /usr/local/WowzaStreamingEngine/renovar-ssl.sh

cat << 'EOF' > /usr/local/WowzaStreamingEngine/renovar-ssl.sh
#!/bin/sh

if [ "$1" == "desligar" ]; then

systemctl stop WowzaStreamingEngine

fi

if [ "$1" == "converter" ]; then

rm -rf /usr/local/WowzaMediaServer/ssl/*

dominio_servidor=`grep archive_dir /etc/letsencrypt/renewal/*.conf | head -1 | cut -d / -f 5`

openssl pkcs12 -export -in /etc/letsencrypt/live/$dominio_servidor/fullchain.pem -inkey /etc/letsencrypt/live/$dominio_servidor/privkey.pem -name $dominio_servidor -out /usr/local/WowzaMediaServer/ssl/certificado.p12 -password pass:pGePkkuZ7HeMM922aU97
keytool -importkeystore -noprompt -keypass pGePkkuZ7HeMM922aU97 -srcstorepass pGePkkuZ7HeMM922aU97 -deststorepass pGePkkuZ7HeMM922aU97 -destkeystore /usr/local/WowzaMediaServer/ssl/certificado.jks -srckeystore /usr/local/WowzaMediaServer/ssl/certificado.p12 -srcstoretype PKCS12
keytool -import -noprompt -keypass pGePkkuZ7HeMM922aU97 -storepass pGePkkuZ7HeMM922aU97 -alias bundle -trustcacerts -file /etc/letsencrypt/live/$dominio_servidor/chain.pem -keystore /usr/local/WowzaMediaServer/ssl/certificado.jks

systemctl start WowzaStreamingEngine
systemctl restart httpd

fi
EOF

chmod 777 /usr/local/WowzaStreamingEngine/renovar-ssl.sh

cd /root

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando servidor FTP e sua configuracao..." >> /home/auto-instalador-wowza.log

echo > /etc/pure-ftpd/pureftpd-mysql.conf

cat <<EOT >> /etc/pure-ftpd/pureftpd-mysql.conf
MYSQLServer     $dominio_painel
MYSQLPort       3306
MYSQLUser       $usuario_painel
MYSQLPassword   $senha_painel
MYSQLDatabase   $banco_painel

MYSQLCrypt      cleartext

MYSQLGetPW      SELECT senha FROM streamings WHERE (login="\L" AND status="1") AND aplicacao IN ('tvstation', 'vod')
MYSQLGetDir     SELECT ftp_dir FROM streamings WHERE (login="\L" AND status="1") AND aplicacao IN ('tvstation', 'vod')
MySQLGetQTASZ   SELECT espaco FROM streamings WHERE (login="\L" AND status="1") AND aplicacao IN ('tvstation', 'vod')

EOT

sed -i '/UseFtpUsers/d' /etc/pure-ftpd/pure-ftpd.conf
sed -i '/MinUID/d' /etc/pure-ftpd/pure-ftpd.conf

sed -i '/MYSQLDefaultUID/d' /etc/pure-ftpd/pureftpd-mysql.conf
sed -i '/MYSQLDefaultGID/d' /etc/pure-ftpd/pureftpd-mysql.conf
user_stm_id=`id -u streaming`

sed -i '/^$/d' /etc/pure-ftpd/pure-ftpd.conf
sed -i '/^[[:blank:]]*#/d;s/#.*//' /etc/pure-ftpd/pure-ftpd.conf
sed -i '/Authentication/d' /etc/pure-ftpd/pure-ftpd.conf
echo 'MySQLConfigFile             /etc/pure-ftpd/pureftpd-mysql.conf' >> /etc/pure-ftpd/pure-ftpd.conf
echo 'CreateHomeDir               yes' >> /etc/pure-ftpd/pure-ftpd.conf

echo "MinUID             $user_stm_id" >> /etc/pure-ftpd/pure-ftpd.conf
echo "MYSQLDefaultUID $user_stm_id" >> /etc/pure-ftpd/pureftpd-mysql.conf
echo "MYSQLDefaultGID $user_stm_id" >> /etc/pure-ftpd/pureftpd-mysql.conf

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando SSL..." >> /home/auto-instalador-wowza.log

systemctl stop httpd

> /etc/httpd/conf.d/ssl.conf
vversao=`wget -q -O - http://$dominio_painel/versao.txt`

cat <<EOT >> /etc/httpd/conf.d/ssl.conf
# Configurado
LoadModule ssl_module modules/mod_ssl.so

Listen $porta_ssl

SSLPassPhraseDialog  builtin

SSLSessionCache         shmcb:/var/cache/mod_ssl/scache(512000)
SSLSessionCacheTimeout  300

SSLRandomSeed startup file:/dev/urandom  256
SSLRandomSeed connect builtin

SSLCryptoDevice builtin

EOT

sudo dnf -y install certbot-apache

ln -s /usr/bin/certbot-3 /usr/bin/certbot

certbot -n --agree-tos --register-unsafely-without-email certonly --standalone -d $dominio_servidor

if [ ! -f "/etc/letsencrypt/live/$dominio_servidor/cert.pem" ]; then

echo "**ERRO**" >> /home/auto-instalador-wowza.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Erro na instalacao do SSL, instalacao abortada!" >> /home/auto-instalador-wowza.log

exit 1

fi

cat <<EOT >> /etc/httpd/conf.d/ssl.conf

NameVirtualHost *:$porta_ssl

<VirtualHost *:$porta_ssl>
    DocumentRoot /home/streaming/web
    ServerName $dominio_servidor

    ErrorLog logs/ssl_error_log
    TransferLog logs/ssl_access_log
    LogLevel warn

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_servidor/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_servidor/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_servidor/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

rm -Rf /usr/local/WowzaMediaServer/ssl

mkdir /usr/local/WowzaMediaServer/ssl

openssl pkcs12 -export -in /etc/letsencrypt/live/$dominio_servidor/fullchain.pem -inkey /etc/letsencrypt/live/$dominio_servidor/privkey.pem -name $dominio_servidor -out /usr/local/WowzaMediaServer/ssl/certificado.p12 -password pass:pGePkkuZ7HeMM922aU97
keytool -importkeystore -noprompt -keypass pGePkkuZ7HeMM922aU97 -srcstorepass pGePkkuZ7HeMM922aU97 -deststorepass pGePkkuZ7HeMM922aU97 -destkeystore /usr/local/WowzaMediaServer/ssl/certificado.jks -srckeystore /usr/local/WowzaMediaServer/ssl/certificado.p12 -srcstoretype PKCS12
keytool -import -noprompt -keypass pGePkkuZ7HeMM922aU97 -storepass pGePkkuZ7HeMM922aU97 -alias bundle -trustcacerts -file /etc/letsencrypt/archive/$dominio_servidor/chain1.pem -keystore /usr/local/WowzaMediaServer/ssl/certificado.jks

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalando tarefas cron..." >> /home/auto-instalador-wowza.log

cat <<EOT > /var/spool/cron/root
0 */1 * * * /usr/local/WowzaMediaServer/limpar_mem_cache
*/5 * * * * /home/streaming/calcular-uso-ftp
0 3 * * * /usr/local/bin/youtube-dl -U
0 */12 * * * /usr/bin/rdate -s rdate.cpanel.net
30 4 * * * /home/streaming/remover-videos-inexistentes
*/30 * * * * /bin/chown streaming.streaming /home/streaming/*
*/30 * * * * /bin/echo -n > /var/spool/mail/root
*/30 * * * * /bin/echo -n > /var/spool/mail/streaming
0 */2 * * * /bin/echo -n > /usr/local/WowzaStreamingEngine/logs/wowzastreamingengine_error.log
0 */2 * * * /bin/echo -n > /usr/local/WowzaStreamingEngine/logs/wowzastreamingengine_access.log
0 */12 * * * rm -f /usr/local/WowzaStreamingEngine/logs/wowzastreamingengine_*.log.*
30 4 * * * certbot -n renew --standalone --pre-hook='/usr/local/WowzaStreamingEngine/renovar-ssl.sh desligar' --post-hook='/usr/local/WowzaStreamingEngine/renovar-ssl.sh converter'
EOT

mv /home/instalador/migrar-videos-ftp.txt /home/streaming/web/migrar-videos-ftp.php
mv /home/instalador/youtube.php.txt /home/streaming/web/youtube.php

sed -i '/acl_groups/d' /etc/php-fpm.d/www.conf
echo 'listen.acl_groups = apache,streaming' >> /etc/php-fpm.d/www.conf


chmod 777 /home/streaming -Rf

update-crypto-policies --set DEFAULT:SHA1

dnf install lynx -y

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Finalizando ajustes..." >> /home/auto-instalador-wowza.log


> /home/streaming/web/index.php

cd /usr/local/WowzaStreamingEngine/
wget https://$dominio_painel/src-instalador-almalinux/java9.tar.gz
tar -zxvf java9.tar.gz
mv -f /usr/local/WowzaStreamingEngine/java /usr/local/WowzaStreamingEngine/java_old
ln -s /usr/local/WowzaStreamingEngine/jre /usr/local/WowzaStreamingEngine/java


systemctl enable WowzaStreamingEngine
systemctl disable WowzaStreamingEngineManager
systemctl enable vnstat
systemctl enable pure-ftpd
systemctl enable httpd
systemctl enable crond
systemctl enable php-fpm

systemctl restart sshd
systemctl restart vnstat
systemctl restart httpd
systemctl restart crond
systemctl restart pure-ftpd
systemctl start WowzaStreamingEngine
systemctl restart php-fpm

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Validando instalacao..." >> /home/auto-instalador-wowza.log

status_apache=`lynx -head -dump https://localhost:$porta_ssl | head -n 1 | awk {'print $2'}`

if [ $status_apache -ne 200 ]; then

echo "**ERRO**" >> /home/auto-instalador-wowza.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Erro iniciar apache! A instalacao foi concluida porem nao foi possivel iniciar o apache corretamente, por favor verifique acessando o servidor via SSH e executando comando: systemctl restart httpd" >> /home/auto-instalador-wowza.log

exit 1

fi


echo "**CONCLUIDO**" >> /home/auto-instalador-wowza.log
echo >> /home/auto-instalador-wowza.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Instalacao do servidor $dominio_servidor concluida com sucesso!" >> /home/auto-instalador-wowza.log
echo >> /home/auto-instalador-wowza.log
rm -f /home/auto-instalador-wowza.sh