#!/bin/bash

# validate passed silent install key
#required input is the silentinstall key string from the user in $1. It should be a single word (no spaces) and without quotes
# it is mandatory

# Return values are 0 for success and non-zero for failure.


# get the parameters 
INSTALLKEY=$1
strindex() { 
  x="${1%%$2*}"
  [[ $x = $1 ]] && echo -1 || echo ${#x}
}

BIGINTCHARS=ABCDEFGHIJKLMNPQRSTUVWXYZ123456789
INSTALLKEYLEN=${#INSTALLKEY}
BIGINTLEN=${#BIGINTCHARS}
echo $INSTALLKEY

if [ $INSTALLKEYLEN -eq 29 ]; then

	CHECKSUMTOTAL=0
	CHECKSUMVALUE=-1

	for ((i=0;i<29;i++))
	do
		THECHAR=${INSTALLKEY:$i:1}
		THECHARINDEX=$(strindex $BIGINTCHARS $THECHAR)
		if [ $i -eq 0 ]; then
			CHECKSUMVALUE=$(($THECHARINDEX + 1))
		else
			if [ $THECHARINDEX -ge 0 ]; then
				CHECKSUMTOTAL=$(($CHECKSUMTOTAL + $THECHARINDEX + 1))
#				echo "checksum[" $THECHAR "]: " $CHECKSUMTOTAL
#				echo "checksum[" $THECHAR "]: " $THECHARINDEX   $CHECKSUMTOTAL
			fi
		fi
	done
	
	CHECKSUMCALC=$(($CHECKSUMTOTAL % 34 + 1))
#	echo $CHECKSUMVALUE '=' $CHECKSUMCALC
	if [ "$CHECKSUMVALUE" == "$CHECKSUMCALC" ] ; then
		exit 0
	else
		# invalid key, return fail
#		echo 'failure - invalid key'
		exit 1
	fi			

else
	# The key was too short, return fail
#	echo 'failure - key too short'
	exit 1
fi

