<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all encodes tables</re:mark>

<c:set var="obj" >
	streamNameGroupsList
</c:set>
<h5><wmsform:getlocalestring page="${page}" obj="streamNameGroupsList"/></h5> 
<c:choose>
	<c:when test="${fn:length(requestScope.formData[obj]) == 0}">
		<div class="value">
			-None-
		</div>
	</c:when>
	<c:otherwise>
		<table class="table table-striped">
			<tr>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.groupName"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.streamName"/></th>
				<th style="width:15px"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
			</tr>
			<c:forEach items="${requestScope.formData[obj]}" var="item" varStatus="varStatus">
				<tr>
					<td class="breakall">
						<a onclick="javascript:streamNameGroupShow('${wmsutil:escapeHtml(item['groupName'])}')">${wmsutil:escapeHtml(item['groupName'])}</a>
					</td>
					<td>${wmsutil:escapeHtml(item['streamName'])}<br>
						<small>
							<c:forEach items="${item['members']}" var="memberItem" varStatus="count">
								<c:if test="${count.index>0}">
									,
								</c:if>
								${wmsutil:escapeHtml(memberItem['memberName'])}
							</c:forEach>
						</small>
					</td>
					<td>
						<sec:authorize access="hasAnyRole('admin')">		
							<a onclick="javascript:streamNameGroupEditShow('${wmsutil:escapeHtml(item['groupName'])}')" ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this stream name group'></i></a>
							<a onclick="javascript:removeStreamNameGroup('${wmsutil:escapeHtml(item['groupName'])}')"><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this stream name group'></i></a>
						</sec:authorize>
					</td>
				</tr>
			</c:forEach>
		</table>
	</c:otherwise>
</c:choose>

<wmsdialog:deletestreamnamegroup page="transcoder.template.streamNameGroup"/>
<script>
/*
var tblDataStreamNameGroup = new Array();
var tblIdxStreamNameGroup=0;

initTableDataStreamNameGroup();

function initTableDataStreamNameGroup()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxStreamNameGroup++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.groupName = "${item['groupName']}";
		newItem.streamName = "${item['streamName']}";
		newItem.members = new Array();
		<c:forEach items="${item['members']}" var="memberItem">
			var newMember = new Object();
			newMember.memberName="${memberItem['memberName']}";
			newMember.encodeName="${memberItem['encodeName']}";
			newMember.wowzaVideoOnly="${memberItem['wowzaVideoOnly']}"=="true";
			newMember.wowzaAudioOnly="${memberItem['wowzaAudioOnly']}"=="true";
			newItem.members.push(newMember);
		</c:forEach>
		tblDataStreamNameGroup.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
function showStreamNameGroup(idx)
{
	streamNameGroupShow(idx);
}
*/

function removeStreamNameGroup(name)
{
	deleteStreamNameGroup=name;
	deleteStreamNameGroupShow();
}

function streamNameGroupShow(streamNameGroup) 
{
	var sngDiv = $("#streamNameGroupDiv");
	if (sngDiv.length > 0)
	{
		$("#streamNameGroupModal").remove();
	} 
	//else
	{
		sngDiv = $("<div id='streamNameGroupDiv' style='display: hidden;'></div>").appendTo($("body"));
		$(document).on("preContentNavigation", function(e)
		{
			if(streamNameGroupClose) {
				streamNameGroupClose();
			}
			sngDiv.remove();
			$(document).off("preContentNavigation", arguments.callee);
		});
		document.body.style.cursor = "wait";

		streamNameGroup=encodeURIComponent(streamNameGroup);
		if("${appType}" == "")
		{
			sngDiv.load('server/transcoderstreamnamegroup/view.htm?vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&streamNameGroup='+streamNameGroup, function() {
				if($(this).html().substring(0,redirectLoginString.length)==redirectLoginString) {
					document.location="login.htm"+location.hash;					
				}
			});
		}
		else 
		{
			sngDiv.load('applications/{appType}/transcoderstreamnamegroup/view.htm?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&streamNameGroup='+streamNameGroup, function() {
				if($(this).html().substring(0,redirectLoginString.length)==redirectLoginString) {
					document.location="login.htm"+location.hash;					
				}
			});
		}
		document.body.style.cursor = "default";
	}
}

function streamNameGroupEditShow(streamNameGroup) 
{
	var sngDiv = $("#streamNameGroupDiv");
	if (sngDiv.length > 0)
	{
		$("#streamNameGroupModal").remove();
	} 
	sngDiv = $("<div id='streamNameGroupDiv' style='display: hidden;'></div>").appendTo($("body"));
	$(document).on("preContentNavigation", function(e)
	{
		if(streamNameGroupClose) {
			streamNameGroupClose();
		}
		sngDiv.remove();
		$(document).off("preContentNavigation", arguments.callee);
	});
	document.body.style.cursor = "wait";

	action="";
	if(streamNameGroup=="[new]")
	{
		streamNameGroup="";
		action="new";
	}
	
	streamNameGroup=encodeURIComponent(streamNameGroup);
	if("${appType}" == "")
	{
		sngDiv.load('server/transcoderstreamnamegroup/edit.htm?vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&streamNameGroup='+streamNameGroup+"&action="+action, function() {
			if($(this).html().substring(0,redirectLoginString.length)==redirectLoginString) {
				document.location="login.htm"+location.hash;					
			}
		});
	}
	else 
	{
		sngDiv.load('applications/{appType}/transcoderstreamnamegroup/edit.htm?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&streamNameGroup='+streamNameGroup+"&action="+action, function() {
			if($(this).html().substring(0,redirectLoginString.length)==redirectLoginString) {
				document.location="login.htm"+location.hash;					
			}
		});
	}
	document.body.style.cursor = "default";
}

</script>
