<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all modules tables</re:mark>

<c:set var="obj" >
	modulesList
</c:set>
<wmsform:propertieswarningmsg page="adv"/>
<div class="row advanced-table-title">
	<div class="col-md-12">
		<h4 id="modules"><wmsform:getlocalestring page="${page}" obj="modules"/>
		<small><wmsform:getlocalestring page="${page}" obj="modulesHelp"/></small></h4>
		<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/edit_mod.htm?','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')"/>
	</div>
</div>
<table class="table table-striped">
	<tr>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.description"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.className"/></th>
	</tr>
	<c:forEach items="${requestScope.formDataMod[obj]}" var="item">
		<tr>
			<td class="breakall">${item['name']}</td>
			<td>${item['description']}</td>
			<td class="breakall">${item['className']}</td>
		</tr>
	</c:forEach>
</table>
