<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="appType" required="true" rtexprvalue="true" %>
<%@ attribute name="showSectionName" required="false" rtexprvalue="true" %>
<%@ attribute name="tabView" required="false" rtexprvalue="true" %>
<%@ attribute name="showPath" required="false" rtexprvalue="true" %>

<re:mark>Display custom properties tables</re:mark>
<c:set var="obj" >
	customList
</c:set>
<c:if test="${ empty showSectionName}">
	<c:set var="showSectionName" value="false"/>
</c:if>
<c:if test="${ empty tabView}">
	<re:mark>The custom properties table is being listed on a standalone Custom tab, so labels and instructions are a bit different</re:mark>
	<c:set var="tabView" value="false"/>
</c:if>
<c:if test="${ empty showPath}">
	<c:set var="showPath" value="true"/>
</c:if>

<div class="row advanced-table-title">
	<div class="col-md-10">
		<c:if test="${tabView=='false'}">
			<h4 id="customTableAnchor"><wmsform:getlocalestring page="${page}" obj="custom"/>
			<small><wmsform:getlocalestring page="${page}" obj="customHelp"/></small></h4>
		</c:if>
		<c:choose>
			<c:when test="${appType=='vhost' }">
				<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/vhostsetup/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&advSection=Custom')"/>
			</c:when>
			<c:when test="${appType=='server' }">
				<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/serversetup/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&advSection=Custom')"/>
			</c:when>
			<c:when test="${appType=='mediacache' }">
				<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacache/edit_adv.htm?','advSection=Custom')"/>
			</c:when>
			<c:when test="${appType=='mediacachestore' }">
				<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacachestore/edit_adv.htm?','storeName=${storeName}&advSection=Custom')"/>
			</c:when>
			<c:when test="${appType=='mediacachesource' }">
				<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacachesource/edit_adv.htm?','sourceName=${sourceName}&advSection=Custom')"/>
			</c:when>
			<c:when test="${appType=='streamtarget' }">
				<wmsform:buttonedit onClick="javascript:editStreamTarget()"/>
			</c:when>
			<c:otherwise>
				<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&advSection=Custom')"/>
			</c:otherwise>
		</c:choose>
	</div>
	<c:if test="${tabView=='false'}">
		<div class="col-md-2">
			<a href="#apptop" class="return-to-top pull-right">Return to top <i class="fa fa-arrow-up"></i></a>
		</div>
	</c:if>
</div>

<c:choose>
	<c:when test="${fn:length(requestScope.formDataAdv[obj])>0}">
		<table class="table table-striped">
			<tr>
				<c:if test="${showPath}">
					<th><wmsform:getlocalestring page="${page}" obj="${obj}.path"/></th>
				</c:if>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.type"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.value"/></th>
			</tr>
			<c:set var="search" value="\\\\" />
            <c:set var="replace" value="\\" />
 			<c:forEach var="item" items="${requestScope.formDataAdv[obj]}">
 			<c:set var="originalVal" value="${item['value']}" />
			<c:set var="myContent" value="${fn:replace(originalVal, search, replace)}"/>
				<tr>
					<c:if test="${showPath}">
						<c:choose>
							<c:when test="${showSectionName}">
								<td>${item['sectionName']}</td>
							</c:when>
							<c:otherwise>
								<td>${item['section']}</td>
							</c:otherwise>
						</c:choose>
					</c:if>
					<td class="breakall">${item['name']}</td>
					<td>${item['type']}</td>
					<td class="breakall">${myContent}</td>
				</tr>
			</c:forEach>
		</table>
	</c:when>
	<c:otherwise>
		<p><i><wmsform:getlocalestring page="${page}" obj="customEmpty"/></i></p>
		<c:choose>
			<c:when test="${tabView}">
				<p><wmsform:getlocalestring page="${page}" obj="customTabEmptyHelp"/></p>
			</c:when>
			<c:otherwise>
				<p><wmsform:getlocalestring page="${page}" obj="customEmptyHelp"/></p>
			</c:otherwise>
		</c:choose>
	</c:otherwise>
</c:choose>