<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="group" required="true" rtexprvalue="true" %>

<re:mark>Display true/false radio buttons</re:mark>

<re:mark>Radio button</re:mark>
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<tr ${group} style="display:none">
	<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
		<c:set var="objName"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="${obj}"/></c:set>
		<c:set var="objDesc"><wmsform:getlocalestring page="appconfigAdv.advancedTables.streamTarget.description" obj="${obj}" defaultStr="Missing description for ${objName}"/></c:set>
		<c:set var="objValue">${requestScope.formData[obj]}</c:set>
		<td>
			${objName}
		</td>
		<td>
			<label class="radio-inline">
			<re:mark>Would be easier to use the form:radiobutton, but it would not check true when the obj equaled true, always false, for advanced settings</re:mark>
				<c:choose>
					<c:when test='${objValue=="true"}'>
						<input id="${obj}1" name="${obj}" type="radio" value="true" checked="checked">
					</c:when>
					<c:otherwise>
						<input id="${obj}1" name="${obj}" type="radio" value="true">
					</c:otherwise>
				</c:choose>
				True
			</label>
			<label class="radio-inline">
				<c:choose>
					<c:when test='${objValue=="false"}'>
						<input id="${obj}2" name="${obj}" type="radio" value="false" checked="checked">
					</c:when>
					<c:otherwise>
						<input id="${obj}2" name="${obj}" type="radio" value="false">
					</c:otherwise>
				</c:choose>
				False
			</label>
		</td>
		<td>
			<i id="${obj}EditDesc" class="fa fa-question-circle fa-2x" style="float:right" rel="popover" data-html="true" data-content="${objDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${objName}"></i>
			<script>WOWZA.Util.Popover("#${obj}EditDesc");</script>
		</td>
		<re:mark>Errors and warnings</re:mark>
		<wmsform:errors path="${obj}"/>
		<wmsform:warnings path="${obj}"/>
	</div>
</tr>
