<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="readonly" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="onChange" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="ctrlGroupClass" required="false" rtexprvalue="true" %>

<re:mark>Display a checkbox box</re:mark>

<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>
<c:if test="${ empty bind}">
	<c:set var="bind" value="true"/>
</c:if>
<c:if test="${ empty readonly}">
	<c:set var="readonly" value=""/>
</c:if>
<c:if test="${ empty ctrlGroupClass}">
	<c:set var="ctrlGroupClass" value="checkbox"/>
</c:if>

<re:mark>Checkbox</re:mark>
<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<label>	
		<c:choose>
			<c:when test="${bind=='true'}">
				<c:choose>
					<c:when test="${readonly=='false' || readonly==''}">	
						<form:checkbox path="${obj}" class="checkbox-inline" onchange="${onChange}" />
					</c:when>
					<c:otherwise>
						<form:checkbox path="${obj}" class="checkbox-inline" onchange="${onChange}" disabled = "true"/>
					</c:otherwise>
				</c:choose>
			</c:when>
			<c:otherwise>
				<c:choose>
					<c:when test="${readonly=='false' || readonly==''}">
						<input type="checkbox" title="${tooltip_msg}" id="${obj}" class="checkbox-inline" />
						<span class="help-block-has-error" id="${obj}ErrorMsg" style="display:none"></span>
					</c:when>
					<c:otherwise>
						<input type="checkbox" title="${tooltip_msg}" id="${obj}" class="checkbox-inline" readonly/>
						<span class="help-block-has-error" id="${obj}ErrorMsg" style="display:none"></span>
					</c:otherwise>
				</c:choose>
			</c:otherwise>
		</c:choose>
		<re:mark>Title</re:mark>
		<c:if test="${ empty showTitle}">
			<wmsform:getlocalestring page="${page}" obj="${obj}"/>	
		</c:if>
		<c:if test="${! empty required}">
		*
		</c:if>
	</label>
	<re:mark>Errors and warnings</re:mark>
	<c:if test="${bind=='true'}">
		<wmsform:errors path="${obj}"/>
		<wmsform:warnings path="${obj}"/>
	</c:if>
	<c:set var="objhelp">
		<wmsform:getlocalestring page="${page}" obj="${obj}.help"/>
	</c:set>
	<c:choose>
		<c:when test='${ not (fn:endsWith(objhelp,"help"))}'>
			<span class="help-block">${fn:trim(objhelp)}</span>
		</c:when>
	</c:choose>
</div>