<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="href" required="true" rtexprvalue="true" %>
<%@ attribute name="src" required="true" rtexprvalue="true" %>
<%@ attribute name="buttonNumber" required="true" rtexprvalue="true" %>

<re:mark>Display a publishers button</re:mark>
<c:set var="btnValue">
	<wmsform:getlocalestring page="${page}" obj="${obj}"/>
</c:set>

<div id="publisherBtn${buttonNumber}">
	<div id="encoderBtn${buttonNumber}" onClick="publisherClick('${buttonNumber}')" class="btn-publisher btn-publisher-normal">
		<img src="${src}">
		<div id="encoderBtnText${buttonNumber}" class="text-center encoder-vertical-center" >
			${btnValue}
		</div>
	</div>
	<p class="btn-publisher-width text-center">
		<a target="_blank" href="${href}"><fmt:message key="common.learnMore" /></a>
	</p>
</div>
