<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="restartApplicationModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="restartApplicationModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:restartApplicationClose()">x</button>
					<h4 id="restartApplicationModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="restartApplicationDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="restartApplicationDialog.message"/> <b>${wmsutil:escapeHtml(appName)}</b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="restartApplicationDialog.warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:restartApplicationClose()"/>
					<wmsform:buttonok  onClick="javascript:doRestart()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
$(document).ready(function() {
});

function restartApplicationShow() {
	$('#restartApplicationModal').modal('show');
	var pageName = new String("${page}");
	if ( pageName == 'streamTargets' )
	{
		stopRefresh();
	}

}


function restartApplicationClose() {
	$('#restartApplicationModal').modal('hide');
	var pageName = new String("${page}");
	if ( pageName == 'streamTargets' )
	{
		restartRefresh();
	}

}

function doRestart() {
	var pageName = new String("${page}");
	if ( pageName == 'streamTargets' )
	{
		stopRefresh();
	}
	$('#restartApplicationModal').on('hidden.bs.modal', function() {
		postAJAXForm('applications/${appType}/${appSection}/restart.htm','restartVhostName=${wmsutil:urlEncode(vhost)}&restartAppName=${wmsutil:urlEncode(appName)}');
	});
	restartApplicationClose();
}

</script>
