<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="resetStreamGroupModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="resetStreamGroupModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:resetStreamGroupClose()">x</button>
					<h4 id="resetStreamGroupModalLabel" class="modal-title"><wmsform:getlocalestring page="resetStreamGroupDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="resetStreamGroupDialog" obj="message"/> <b><span id="resetGroupName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="resetStreamGroupDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:resetStreamGroupClose()"/>
					<wmsform:buttonok  onClick="javascript:doResetStreamGroup()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance;
var currentStream;
var currentApp;

function resetStreamGroupShow(app, appInstance, streamGroup) {
	$('#resetGroupName').text(streamGroup);
	currentApp=app;
	currentInstance=appInstance;
	currentGroup=streamGroup;
	$('#resetStreamGroupModal').on("shown.bs.modal", function() {});
	$('#resetStreamGroupModal').modal('show');	
}

function resetStreamGroupClose() {
	$('#resetStreamGroupModal').modal('hide');
}

function doResetStreamGroup() {
	$('#resetStreamGroupModal').on('hidden.bs.modal', function() {
		postAJAXForm('groups/${page}/resetGroup.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&group='+encodeURIComponent(currentGroup)+'&returnPage=${page}');
	});
	resetStreamGroupClose();
}

</script>