<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="disableStreamTargetingModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="disableStreamTargetingModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:disableStreamTargetingClose()">x</button>
					<h4 id="disableStreamTargetingModalLabel" class="modal-title"><wmsform:getlocalestring page="disableStreamTargetingDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="disableStreamTargetingDialog" obj="message"/></p>
						<p class="text-warning"><wmsform:getlocalestring page="disableStreamTargetingDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:disableStreamTargetingClose()"/>
					<wmsform:buttonok  onClick="javascript:doDisableStreamTargeting()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentStreamTarget;
var currentApp;

function disableStreamTargetingShow(app, streamTargetName) {
	$('#disableStreamTargetingName').text(streamTargetName);
	currentApp=app;
	currentStreamTarget=streamTargetName;
	$('#disableStreamTargetingModal').on("shown.bs.modal", function() {});
	$('#disableStreamTargetingModal').modal('show');
}

function disableStreamTargetingClose() {
	$('#disableStreamTargetingModal').modal('hide');
	restartRefresh();
}

function doDisableStreamTargeting() {
	$('#disableStreamTargetingModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('applications/${appType}/streamtargets/disableStreamTargetsBtn.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&banner=disable');
	});
	disableStreamTargetingClose();
}

</script>