<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteSMILFileStreamModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteSMILFileStreamModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteSMILFileStreamClose()">x</button>
						<h4 id="deleteSMILFileStreamModalLabel" class="modal-title"><wmsform:getlocalestring page="deleteSMILFileStreamDialog" obj="title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="deleteSMILFileStreamDialog" obj="message"/> <b><span id="deleteSMILFileStreamName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="deleteSMILFileStreamDialog" obj="warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteSMILFileStreamClose()"/>
						<wmsform:buttonok  onClick="javascript:doDelete()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteSMILFileStreamShow() {
	$('#deleteSMILFileStreamName').html(deleteSMILFileStreamName);
	//document.getElementById("deleteSMILFileStreamName").innerHTML=deleteSmileFileName;
	$('#deleteSMILFileStreamModal').on("shown.bs.modal", function() {
	});
	$('#deleteSMILFileStreamModal').modal('show');
}

function deleteSMILFileStreamClose() {
	$('#deleteSMILFileStreamModal').modal('hide');
}

function doDelete() {
	$('#deleteSMILFileStreamModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent("server/vhost/smilfile/stream/delete.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&appType=${appType}&smilFile=${wmsutil:urlEncode(smilName)}&idx="+deleteSMILFileStreamIdx);
	});
	deleteSMILFileStreamClose();
	return;
}

</script>
