<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteSMILFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteSMILFileModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteSMILFileClose()">x</button>
						<h4 id="deleteSMILFileModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteSMILFileDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteSMILFileDialog.message"/> <b><span id="deleteSMILFileName"></span>.smil</b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteSMILFileDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteSMILFileClose()"/>
						<wmsform:buttonok  onClick="javascript:doDeleteSMILFile()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteSMILFileShow() {
	$('#deleteSMILFileName').html(deleteSMILFileName);
	//document.getElementById("deleteSMILFileName").innerHTML=deleteSmileFileName;
	$('#deleteSMILFileModal').on("shown.bs.modal", function() {
	});
	$('#deleteSMILFileModal').modal('show');	
}

function deleteSMILFileClose() {
	$('#deleteSMILFileModal').modal('hide');
}

function doDeleteSMILFile() {
	$('#deleteSMILFileModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('server/vhost/smilfile/delete.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&smilFileName='+encodeURIComponent(deleteSMILFileName));
	});
	deleteSMILFileClose();
	return;
}

</script>
