<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteMediaCacheStoreModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteMediaCacheStoreModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteMediaCacheStoreClose()">x</button>
						<h4 id="deleteMediaCacheStoreModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteMediaCacheStoreDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteMediaCacheStoreDialog.message"/> <b><span id="deleteStoreName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteMediaCacheStoreDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteMediaCacheStoreClose()"/>
						<wmsform:buttonok  onClick="javascript:doDeleteStore()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteMediaCacheStoreShow() {
	document.getElementById("deleteStoreName").innerHTML=deleteStoreName;
	$('#deleteMediaCacheStoreModal').on("shown.bs.modal", function() {
	});
	$('#deleteMediaCacheStoreModal').modal('show');	
}

function deleteMediaCacheStoreClose() {
	$('#deleteMediaCacheStoreModal').modal('hide');
}

function doDeleteStore() {
	$('#deleteMediaCacheStoreModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent("server/mediacache/deletestore.htm", "storeName="+encodeURIComponent(deleteStoreName)); 	
	});
	deleteMediaCacheStoreClose();
	return;
}

</script>