<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="copyStreamFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="copyStreamFileModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="copyForm" class="form-modal"> 
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:copyStreamFileClose()">x</button>
						<h4 id="copyStreamFileModalLabel" class="modal-title">
							<wmsform:getlocalestring page="${page}" obj="copyStreamFileDialog.title" />
						</h4>
					</div>
					<div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="copyStreamFileDialog.message" /></p>
						<p>
							<select required id="copyStreamFileName" class="form-control">
								<option disabled selected>Select a Stream File to copy</option>
								<c:forEach items="${requestScope.formData['streamFiles']}" var="item">
									<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
									<c:if test="${fn:substring(item, fn:length(item)-7, fn:length(item)) == '.stream'}">
										<option value="${fn:trim(item)}">${fn:trim(item)}</option>
									</c:if>
								</c:forEach>
							</select>
						</p>
						<label><wmsform:getlocalestring page="${page}" obj="copyStreamFileDialog.prompt" /></label>
						<input id="newStreamFileName" path="newStreamFileName" value="" class="form-control"/>
						<!-- 
						<span class="help-block"><wmsform:getlocalestring page="${page}" obj="copyStreamFileDialog.help" /></span>
						 -->
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="newStreamFileNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:copyStreamFileClose()" />
								<wmsform:buttonok onClick="javascript:doCopyStreamFile()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupStreamFileNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.empty"/>
</c:set>
<c:set var="blankSourceError">
	<wmsform:getlocalestring page="${page}" obj="StreamFileSourceName.empty"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="$common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#copyForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doCopyStreamFile();
             return false;
        }
     });
});

function copyStreamFileShow() {
	$('#newStreamFileNameWarnings').hide();
	$('#copyStreamFileName').prop("selectedIndex",0);

	$('#newStreamFileName').val("");
	$('#copyStreamFileModal').on("shown.bs.modal", function() {
		$('#newStreamFileName').focus();
	});
	$('#copyStreamFileModal').modal('show');
}

function copyStreamFileClose() {
	$('#copyStreamFileModal').modal('hide');
}

function doCopyStreamFile()
{
	var ok=true;
	var fname= $("#newStreamFileName").val().trim();
	if(fname.lastIndexOf(".stream", fname.length - 7) != -1)
	{
		fname = fname.substr(0,fname.length-7);
	}
	if(fname.trim()=="")
	{
		$('#newStreamFileNameWarnings').html("${blankNameError}");
		$('#newStreamFileNameWarnings').show();
		ok=false;					
	}
	if($('#copyStreamFileName').prop("selectedIndex")==0)
	{
		$('#newStreamFileNameWarnings').html("${blankSourceError}");
		$('#newStreamFileNameWarnings').show();
		ok=false;	
	}
	if(ok && !isValidFileName(fname))
	{
		$('#newStreamFileNameWarnings').html("Stream File: ${invalidNameError}");
		$('#newStreamFileNameWarnings').show();
		ok=false;
	}
	if(ok && !isValidFileNameLength(fname))
	{
		$('#newStreamFileNameWarnings').text("Stream File: ${invalidNameLengthError}");
		$('#newStreamFileNameWarnings').show();
		ok=false;
	}
	if(ok)
	{
		for (tblItem in tblDataStreamFiles) {
			if(tblDataStreamFiles[tblItem].name==fname+".stream")
			{
				$('#newStreamFileNameWarnings').html("${dupStreamFileNameError}");
				$('#newStreamFileNameWarnings').show();
				ok=false;			
			}
		}
	}
	if(ok)
	{
		createCopyStreamFile(fname);		
	}

}

function createCopyStreamFile(streamName) {
	//streamName=encodeURIComponent(streamName);
	$('#copyStreamFileModal').on('hidden.bs.modal', function() {
		postAJAXForm('server/vhost/streamfile/copy.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&srcFile='+ encodeURIComponent($('#copyStreamFileName').val()) +'&dstFile='+encodeURIComponent(streamName));
	});
	copyStreamFileClose();
}

</script>
