<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="copySMILFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="copySMILFileModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="copyForm" class="form-modal"> 
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:copySMILFileClose()">x</button>
						<h4 id="copySMILFileModalLabel" class="modal-title">
							<wmsform:getlocalestring page="${page}" obj="copySMILFileDialog.title" />
						</h4>
					</div>
					<div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="copySMILFileDialog.message" /></p>
						<p>
							<select required id="copySMILFileName" class="form-control">
								<option disabled selected>Select a SMIL File to copy</option>
								<c:forEach items="${requestScope.formData['smilFiles']}" var="item">
									<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
									<option value="${fn:trim(item)}">${fn:trim(item)}.smil</option>
								</c:forEach>
							</select>
						</p>
						<label><wmsform:getlocalestring page="${page}" obj="copySMILFileDialog.prompt" /></label>
						<input id="newSMILFileName" path="newSMILFileName" value="" class="form-control"/>
						<!-- 
						<span class="help-block"><wmsform:getlocalestring page="${page}" obj="copySMILFileDialog.help" /></span>
						 -->
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="newSMILFileNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:copySMILFileClose()" />
								<wmsform:buttonok onClick="javascript:doCopySmilFile()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupSMILFileNameError">
	<wmsform:getlocalestring page="${page}" obj="SMILFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="${page}" obj="SMILFileName.empty"/>
</c:set>
<c:set var="blankSourceError">
	<wmsform:getlocalestring page="${page}" obj="SMILFileSourceName.empty"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="$common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#copyForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doCopySmilFile();
             return false;
        }
     });
});

function copySMILFileShow() {
	$('#newSMILFileNameWarnings').hide();
	$('#copySMILFileName').prop("selectedIndex",0);

	$('#newSMILFileName').val("");
	$('#copySMILFileModal').on("shown.bs.modal", function() {
		$('#newSMILFileName').focus();
	});
	$('#copySMILFileModal').modal('show');
}

function copySMILFileClose() {
	$('#copySMILFileModal').modal('hide');
}

function doCopySmilFile()
{
	var ok=true;
	var fname= $("#newSMILFileName").val().trim();
	if(fname.indexOf(".smil", fname.length - 5) != -1)
	{
		fname = fname.substr(0,fname.length-5);
	}

	if(fname.trim() == "")
	{
		$('#newSMILFileNameWarnings').text("${blankNameError}");
		$('#newSMILFileNameWarnings').show();
		ok=false;					
	}
	if(ok && $('#copySMILFileName').prop("selectedIndex")==0)
	{
		$('#newSMILFileNameWarnings').text("${blankSourceError}");
		$('#newSMILFileNameWarnings').show();
		ok=false;	
	}
	if(ok && !isValidFileName(fname))
	{
		$('#newSMILFileNameWarnings').html("SMIL File: ${invalidNameError}");
		$('#newSMILFileNameWarnings').show();
		ok=false;
	}
	if(ok && !isValidFileNameLength(fname))
	{
		$('#newSMILFileNameWarnings').text("SMIL File: ${invalidNameLengthError}");
		$('#newSMILFileNameWarnings').show();
		ok=false;
	}
	if(ok)
	{
		for (tblItem in tblDataSMILFiles) {
			if(tblDataSMILFiles[tblItem].name==fname)
			{
				$('#newSMILFileNameWarnings').text("${dupSMILFileNameError}");
				$('#newSMILFileNameWarnings').show();
				ok=false;			
			}
		}
	}
	if(ok)
	{
		createCopySmilFile(fname);		
	}

}

function createCopySmilFile(smilName) {
	//smilName=encodeURIComponent(smilName);
	$('#copySMILFileModal').on('hidden.bs.modal', function() {
		postAJAXForm('server/vhost/smilfile/copy.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&srcFile='+ encodeURIComponent($('#copySMILFileName').val()) +'&dstFile='+encodeURIComponent(smilName));
	});
	copySMILFileClose();
}

</script>