<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="addStreamFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addStreamFileModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="addForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:addStreamFileClose()">x</button>
						<h4 id="addStreamFileModalLabel" class="modal-title">
							<wmsform:getlocalestring page="${page}" obj="addStreamFileDialog.title" />
						</h4>
					</div>
					<div class="modal-body">
						<p>* = required field</p>
						<p>
							<wmsform:getlocalestring page="${page}" obj="addStreamFileDialog.message" />
						</p>
						<wmsform:editproperty page="${page}.addStreamFileDialog" obj="addStreamFileName" bind="false" required="true" tooltip="Enter Stream File Name"/>
						<wmsform:editproperty page="${page}.addStreamFileDialog" obj="addStreamFileURI" bind="false" required="true"/>

					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="addStreamFileNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:addStreamFileClose()" />
								<wmsform:buttonadd onClick="javascript:doAddStreamFile()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupStreamFileNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.empty"/>
</c:set>
<c:set var="blankuriError">
	<wmsform:getlocalestring page="streamFiles.StreamFile" obj="uri.empty"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidUriPrefixError">
	<wmsform:getlocalestring page="streamFiles.StreamFile" obj="uri.invalidPrefix"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#addForm").bind("keypress", function(e) {
		if (e.keyCode == 13) {
			doAddStreamFile();
			return false;
		}
	});
});

function addStreamFileShow() {
	//$("#addStreamFileName").text(addStreamFileDisplayName);
	$('#addStreamFileNameWarnings').hide();
	$('#addStreamFileNameErrorMsg').hide();
	$('#addStreamFileURIErrorMsg').hide();

	$('#addStreamFileName').val("");
	$('#addStreamFileURI').val("");
	$('#addStreamFileModal').on("shown.bs.modal", function() {
		$('#addStreamFileName').focus();
	});
	$('#addStreamFileModal').modal('show');
}

function addStreamFileClose() {
	$('#addStreamFileModal').modal('hide');
}

function doAddStreamFile() {
	var ok = true;
	$('#addStreamFileNameErrorMsg').hide();
	$('#addStreamFileURIErrorMsg').hide();

	var fname = $("#addStreamFileName").val().trim();
	if (fname.lastIndexOf(".stream", fname.length - 7) != -1) {
		fname = fname.substr(0, fname.length - 7);
	}

	if (fname == "") {
		$('#addStreamFileNameErrorMsg').html("${blankNameError}");
		$('#addStreamFileNameErrorMsg').show();
		ok = false;
	}
	for (tblItem in tblDataStreamFiles) {
		if (tblDataStreamFiles[tblItem].name == fname + ".stream") {
			$('#addStreamFileNameErrorMsg').html(
					"${dupStreamFileNameError}");
			$('#addStreamFileNameErrorMsg').show();
			ok = false;
		}
	}
	if (ok && !isValidFileName(fname)) {
		$('#addStreamFileNameErrorMsg').html(
				"Stream File: ${invalidNameError}");
		$('#addStreamFileNameErrorMsg').show();
		ok = false;
	}
	if (ok && !isValidFileNameLength(fname)) {
		$('#addStreamFileNameErrorMsg').html(
				"Stream File: ${invalidNameLengthError}");
		$('#addStreamFileNameErrorMsg').show();
		ok = false;
	}
	uri = $("#addStreamFileURI").val().trim();
	if (uri == "") {
		$('#addStreamFileURIErrorMsg').html("${blankuriError}");
		$('#addStreamFileURIErrorMsg').show();
		ok = false;
	} else {
		//same validation code as in StreamFileModel.java
		//keep them syncd
		if (!(uri.substring(0, 4) == "udp:"
				|| uri.substring(0, 5) == "rtsp:"
				|| uri.substring(0, 5) == "rtmp:"
				|| uri.substring(0, 6) == "rtmps:"
				|| uri.substring(0, 5) == "wowz:"
				|| uri.substring(0, 6) == "wowzs:"
				|| uri.substring(0, 5) == "http:"
				|| uri.substring(0, 6) == "https:"
				|| uri.substring(0, 4) == "srt:"
				)) {
			$('#addStreamFileURIErrorMsg').html("${invalidUriPrefixError}");
			$('#addStreamFileURIErrorMsg').show();
			ok = false;
		}
	}

	if (ok) {
		createStreamFile(fname, uri);
	}

}

function createStreamFile(streamName, uri) {
	streamName = encodeURIComponent(streamName);
	uri = encodeURIComponent(uri);
	$('#addStreamFileModal').on('hidden.bs.modal',function() {
		postAJAXForm('server/vhost/streamfile/new.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&streamName=' + streamName + '&uri=' + uri);
	});
	addStreamFileClose();
}
</script>