<h4>Configuring SMIL File Stream Attributes</h4>
<p>Stream attributes and parameters provide information about each stream to players. Players use this information to determine which stream is best suited for playback under current conditions and to play the stream.</p>

<h5>Video Stream Attributes</h5>
<p>For a video stream that also has audio, specify the following attributes and parameters for the &lt;video&gt; tag:</p>
<ul>
	<li><strong>Source (src)</strong>. If the source is a live stream, enter the published stream name (for example, <strong>myStream</strong>). If the source is an on demand file, enter the path to the file (for example, <strong>mp4:sample.mp4</strong>). The source value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters. For on-demand sources, you must prepend the proper prefix to the file name. See <a href="https://www.wowza.com/docs/understanding-streaming-protocols-and-output-file-formats#supportedMedia" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Supported media file formats</a>.

	<li><strong>System Language</strong>. Enter the 3-letter ISO-639 language code that indicates the language of the encoded video (for example, <strong>eng</strong>). Players with a preferred system language evaluate the &lt;video&gt; tags and select a video stream in its preferred language (if available). If a match can't be found, players select a stream that doesn't have this attribute specified (the default video stream).

	<li><strong>Video Bitrate</strong>. Enter the encoded video bitrate of the stream in bits per second (bps). Only values between <strong>10000</strong> and <strong>100000000</strong> bps are supported.

	<li><strong>Video Width</strong> and <strong>Video Height</strong>. Enter the encoded output dimensions (width and height) of the video in pixels. These values must be greater than <strong>15</strong> pixels.

	<li><strong>Audio Bitrate</strong>. Enter the encoded audio bitrate of the stream in bits per second (bps). Only values between <strong>3000</strong> and <strong>1000000</strong> bps are supported.
</ul>

<h5>Audio Stream Attributes</h5>
<p>For an audio-only stream, specify the following attributes and parameters for the &lt;audio&gt; tag:</p>
<ul>
	<li><strong>Source (src)</strong>. If the source is a live stream, enter the published stream name (for example, <strong>myStream</strong>). If the source is an on demand file, enter the path to the file (for example, <strong>mp3:mycoolsong.mp3</strong>). The source value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters. For on-demand sources, you must prepend the proper prefix to the file name. See <a href="https://www.wowza.com/docs/understanding-streaming-protocols-and-output-file-formats#supportedMedia" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Supported media file formats</a>.

	<li><strong>System Language</strong>. Enter the 3-letter ISO-639 language code that indicates the language of the encoded audio (for example, <strong>eng</strong>). Players with a preferred system language evaluate the &lt;audio&gt; tags and select an audio stream in its preferred language (if available). If a match can't be found, players select a stream that doesn't have this attribute specified (the default audio stream).

	<li><strong>Audio Bitrate</strong>. Enter the encoded audio bitrate of the stream in bits per second (bps). Only values between <strong>3000</strong> and <strong>1000000</strong> bps are supported.
</ul>

<h5>Textstream Attributes</h5>
<p>For a stream that has captions, specify the following attributes and parameters for the &lt;textstream&gt; tag:</p>
<ul>
	<li><strong>Source (src)</strong>. If the source is a live stream with captions, enter the published stream name (for example, <strong>myStream</strong>). If the source is an on demand file with embedded captions or an external caption file, enter the path to the file (for example, <strong>captions.ttml</strong>). The source value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters.

	<li><strong>System Language</strong>. Enter the 3-letter ISO-639 language code that indicates the caption language in the <strong>Source</strong> (for example, <strong>eng</strong>). If multiple caption languages are available, enter the language codes for each as a comma-separated list. If no value is specified, the Wowza Streaming Engine locale is used.

	<li><strong>Source has captions</strong>. Select this option to specify that the VOD or live <strong>Source</strong> has captions to be ingested and then select a <strong>Caption Ingest Type</strong>:<br />
	<p>Select <strong>VOD captions</strong> to specify that the caption information is either embedded in an on demand file or is in an external caption file.</p>

	<p>Select <strong>onTextData events in live streams</strong> to specify that the captions are found in Action Message Format (AMF) <strong>onTextData</strong> events in a live stream.</p>

	<p>Select <strong>onCaptionInfo in live streams</strong> to specify that the captions are found in AMF <strong>onTextDataInfo</strong> events in a live stream.
</ul>