<%@ include file="/WEB-INF/jsp/taglibs.jsp"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<wmsform:setpagetitle page="vhostStats" />
<link href="css/wowza-charts.css" rel="stylesheet">

<div class="row">
	<div class="col-md-12">
		<happ><wmsform:getlocalestring page="servervhostmonitoring" obj="header"/></happ>
		<br> <small class="text-muted">${wmsutil:escapeHtml(vhostName)}<br /><wmsform:getlocalestring page="common" obj="LocalBrowserTime"></wmsform:getlocalestring></small>
	</div>
</div>
<div style="margin-top:-10px">
	<hr>
</div>
<c:choose>
<c:when test="${statsEnabled==false || vhost==null}">
	<div class="row">
		<div class="alert alert-warning">
			<h4><wmsform:getlocalestring page="common" obj="MonitoringDisabled"/></h4>
			<wmsform:getlocalestring page="common" obj="MonitoringDisabledExtended"></wmsform:getlocalestring>
		</div>	
	</div>
</c:when>
<c:when test="${ error != null }">
	<div class="row">
		<div class="alert alert-warning">
			<h4><wmsform:getlocalestring page="common" obj="MonitoringDisabled"/></h4>
			${error}
		</div>	
	</div>
</c:when>
<c:otherwise>
<div id="tabContent">
	<div>
		<c:if test="${vhost!=null}">
			<div class="row">
				<div class="col-md-6">
					<h4><wmsform:getlocalestring page="servervhostmonitoring" obj="connections" /> <small><wmsform:getlocalestring page="servervhostmonitoring" obj="connections.sub" /></small></h4>
					<div class="row">
						<div class="col-md-6">
							<table class="table table-condensed table-hover">
								<tr>
									<td><strong><wmsform:getlocalestring page="common" obj="total" /></strong></td>
									<td><strong><span class="vhost-connection-count pull-right" id="vhost-total-connections">${vhost.totalConnections}</span></strong></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="adobeHDS" /></td>
									<td><span class="vhost-connection-count pull-right" id="vhost-sanjose-connections">${vhost.connectionCount.SANJOSE}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="adobeRTMP" /></td>
									<td><span class="vhost-connection-count pull-right" id="vhost-rtmp-connections">${vhost.connectionCount.RTMP}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="appleHLS" /></td>
									<td><span class="vhost-connection-count pull-right" id="vhost-cupertino-connections">${vhost.connectionCount.CUPERTINO}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="microsoftSmooth" /></td>
									<td><span class="vhost-connection-count" id="vhost-smooth-connections">${vhost.connectionCount.SMOOTH}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="mpegDash" /></td>
									<td><span class="vhost-connection-count" id="vhost-dash-connections">${vhost.connectionCount.MPEGDASH}</span></td>
								</tr>
								<tr>
									 <td><wmsform:getlocalestring page="common" obj="rtspRtp" /></td>
									 <td><span class="vhost-connection-count" id="vhost-rtp-connections">${vhost.connectionCount.RTP}</span></td>
								 </tr>
							 </table>
						</div>
						<div class="col-md-6">
							<div id="piecharts" style="height: 180px;margin-top:40px;" class="wowza-pie-charts row"></div>	
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<h4>${serverName}&nbsp;Uptime</h4>
					<p><strong>${vhostName}</strong> up since <span id="uptime-time"></span></p>
					<p><strong>${vhostName}</strong> up for about <span id="uptime-pretty"></span></p>
				</div>
			</div>
		</c:if>
		<c:if test="${vhost==null}">
			<h3>No data available.</h3>
			<c:if test="${error!=null}">
			<!--  ${error} -->
			</c:if>
		</c:if>
		<div id="noData" class="alert alert-warning" style="display: none;">
			<h3><wmsform:getlocalestring page="vhostStats" obj="noData"/></h3>
		</div>
		<hr />
		<div id="vhost-series-charts" class="wowza-series-chart row" style="margin-left:-15px"></div>
	</div>
</div>
<c:if test="${vhost!=null}">

<script language="javascript">
$(document).ready(function() {

	if(isNaN(${vhost.uptime})) {
		$("uptime").html("Unknown");
	} else {
		WOWZA.Util.setUptime(${vhost.uptime}*1000, "#uptime-pretty", "#uptime-time");
	}
 	var pies = {
		connections:{label: "", 
			data: [
				{label:"HDS", data: ${vhost.connectionCount.SANJOSE}, color: WOWZA.Util.ProtocolColorMap['HDS']},
				{label:"RTMP", data: ${vhost.connectionCount.RTMP}, color: WOWZA.Util.ProtocolColorMap['RTMP']},
				{label:"HLS", data: ${vhost.connectionCount.CUPERTINO}, color: WOWZA.Util.ProtocolColorMap['HLS']},
				{label:"DASH", data: ${vhost.connectionCount.MPEGDASH}, color: WOWZA.Util.ProtocolColorMap['DASH']},
				{label:"Smooth", data: ${vhost.connectionCount.SMOOTH}, color: WOWZA.Util.ProtocolColorMap['Smooth']},
				{label:"RTSP/RTP", data: ${vhost.connectionCount.RTP}, color: WOWZA.Util.ProtocolColorMap['RTSP/RTP']}
			 ]
		}
	};
	var pies = WOWZA.Charts.Pie("piecharts", pies,{legend: {
		show: false
	},
	colors: WOWZA.Util.FlotColors, classes:"col-md-12"});
	var updateFn = function() {
		this.charts = pies;
		this.id = updateIntervalId;
		updateCharts(charts);
	}
	var updateIntervalId = setInterval(updateFn, 15000);
	pies.id = updateIntervalId;
	$(document).on("preContentNavigation", function(e) {
		clearInterval(updateIntervalId);
	}); 
	showPastStatistics();	
});

var vhostAlreadyCreatedForm = false;
function showPastStatistics() {
	if(vhostAlreadyCreatedForm) {
		return;
	}
	vhostAlreadyCreatedForm = true;
	window.setTimeout(function() {
		var seriesData = ${series};
		var charts = WOWZA.Charts.Series("vhost-series-charts", seriesData, {
			baseUrl: "server/vhost/historical.jsdata",
			vhost: "${vhostName}",
			resize: true,
			legend:{
				show: true
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderWidth: 1,
				backgroundColor: '#f5f5f5'
			},
			xaxis: {
				mode: "time",
				timezone: "browser",
				twelveHourClock:true
			},
			series: {
				points: {
					radius: 3,
					show: false
				}
			},
			colors: WOWZA.Util.FlotColors
		});
		if(seriesData.data["connections"]) {
			charts.series.controls["connections"].defaultTimePicker.selector.trigger('change');
			charts.series.controls["network"].defaultTimePicker.selector.trigger('change');
		} else {
			$("#noData").fadeIn(1000);
		}
	},100);
	
};

function updateCharts(context) {
	 	$.ajax({
			url: 'server/vhost/vhost.jsdata?vhost=${vhostName}',
			cache: false
		}).fail(function(jqXHR, textStatus) {
			alert("Request failed: "+textStatus);
			clearInterval(context.id);
		}).done( function(newData) {
			if (!(newData instanceof Object) && newData.substring(0, 6) == "Error:") {
				$('#mainContent').html(newData);
				return;
			} else if (!(newData instanceof Object) && newData.substring(0, redirectLoginString.length) == redirectLoginString) {
				document.location = "login.htm" + location.hash;
				return;
			}
			var vhost = newData.vhost;
			if(isNaN(vhost.uptime)||vhost.uptime==0) {
				$("#uptime-pretty").html("not running");
				$("#uptime-time").html("not running");
				$("#uptime-time-up-label").hide();
				$("#uptime-pretty-up-label").hide();
				$("#uptime-time-down-label").show();
				$("#uptime-pretty-down-label").show();
			} else {
				$("#uptime-time-down-label").hide();
				$("#uptime-pretty-down-label").hide();
				$("#uptime-time-up-label").show();
				$("#uptime-pretty-up-label").show();
				WOWZA.Util.setUptimeSeconds(vhost.uptime*1000, "#uptime-pretty", "#uptime-time",false);
			}
			$("#bytes-in").html(vhost.bytesIn);
			$("#bytes-in-rate").html(vhost.bytesInRate);
			$("#bytes-out").html(vhost.bytesOut);
			$("#bytes-out-rate").html(vhost.bytesOutRate);
			
			$("#vhost-total-connections").html(vhost.totalConnections);
			$("#vhost-sanjose-connections").html(vhost.connectionCount.SANJOSE);
			$("#vhost-rtmp-connections").html(vhost.connectionCount.RTMP);
			$("#vhost-cupertino-connections").html(vhost.connectionCount.CUPERTINO);
			$("#vhost-dash-connections").html(vhost.connectionCount.MPEGDASH);
			$("#vhost-smooth-connections").html(vhost.connectionCount.SMOOTH);
			$("#vhost-rtp-connections").html(vhost.connectionCount.RTP);
			
			context.plots.connections.setData([
				 {label:"HDS", data: vhost.connectionCount.SANJOSE, color: WOWZA.Util.ProtocolColorMap['HDS']},
				 {label:"RTMP", data: vhost.connectionCount.RTMP, color: WOWZA.Util.ProtocolColorMap['RTMP']},
				 {label:"HLS", data: vhost.connectionCount.CUPERTINO, color: WOWZA.Util.ProtocolColorMap['HLS']},
				 {label:"DASH", data: vhost.connectionCount.MPEGDASH, color: WOWZA.Util.ProtocolColorMap['DASH']},
				 {label:"Smooth", data: vhost.connectionCount.SMOOTH, color: WOWZA.Util.ProtocolColorMap['Smooth']},
				 {label:"RTSP/RTP", data: vhost.connectionCount.RTP, color: WOWZA.Util.ProtocolColorMap['RTSP/RTP']}
			 ]);
			context.plots.connections.draw();
		});
};
</script>
</c:if>
</c:otherwise>
</c:choose>
