<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<wmsform:setpagetitle page="vhostPerformance.ports"/>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-12">
			<happ><wmsform:getlocalestring page="serverPerformance.virtualHostPorts" obj="header"/></happ>
			<br><small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
		</div>
	</div>
	<sec:authorize access="hasAnyRole('advUser')">
		<div class="row">
			<div class="col-md-12">
				<p></p>
				<ul class="nav nav-tabs" >
					<li id="VhostBasic" class="active">
						<a href="javascript:showBasicTab()">Basic</a>
					</li>
					<li id="VhostAdvanced" >
						<a href="javascript:showAdvTab()">Properties</a>
					</li>
				</ul>
			</div>
		</div>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	
	<div class="row">
		<div class="col-md-12">
			<div id="ViewMode" class="row">
				<div  id="TabBasic">
					<jsp:include page="ViewBasic.jsp" flush="true" />
				</div>
				<div id="TabAdv" style="display:none">
					<jsp:include page="ViewAdv.jsp" flush="true" />
			 	</div>
			</div>
			<div id="EditMode" class="row">
				<div  id="TabEditBasic">
					<div class="col-md-8 main-content">
						<form:form method="post" commandName="formData" id="defaultForm"> 
							<wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                         <wmsform:rightrailhideshow/>
							<form:hidden path="ignoreWarnings" />
								<jsp:include page="EditBasic.jsp" flush="true" />
						</form:form>
					</div>
					<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
						<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
					</div>
				</div>
				<div id="TabEditAdv" style="display:none">
					<div class="col-md-12">
						<form:form method="post" commandName="formDataAdv" id="defaultFormAdv"> 
							<wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                            <jsp:include page="EditAdv.jsp" flush="true" />
							<form:hidden path="ignoreWarnings" />	
						</form:form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<wmsform:setwarnings/>	
   	<wmsdialog:restartvhost page="vhostsetup" returnPage="vhostPerformance.ports" vhost="${vhost}"/>
</div>

<script>
$(document).ready(function() {
	
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#EditMode').show();
	}
	else 
	{
		$('#ViewMode').show();		
		$('#EditMode').hide();		
	}
	if(lastTab=="Advanced")
	{
		showAdvTab();
	}
	else 
	{
		showBasicTab();
	}
});

function showBasicTab() {
	if("${mode}"=="edit" && lastTab!='Basic')
	{
		lastTab='Basic';
		loadVHostPerformancePorts();
		return;
	}
	lastTab='Basic';
	createCookie("lastTab",lastTab);
	$('#TabBasic').show();
	$('#TabEditBasic').show();
	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#VhostBasic').addClass('active');
	$('#VhostAdvanced').removeClass();
	$('#VhostStatus').removeClass();
}

function showAdvTab() {
	if("${mode}"=="edit" && lastTab!='Advanced')
	{
		lastTab='Advanced';
		loadVHostPerformancePorts();
		return;
	}
	lastTab='Advanced';
	createCookie("lastTab",lastTab);
	$('#TabBasic').hide();
	$('#TabEditBasic').hide();
	$('#TabAdv').show();
	$('#TabEditAdv').show();
	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#VhostBasic').removeClass();
	$('#VhostAdvanced').addClass('active');	
	$('#VhostStatus').removeClass();
}

</script>
</script>













