<h4>About Stream Name Groups</h4>
<p>The Wowza&#8482; Transcoder templating system groups streams together in logical groups (called <em>stream name groups</em>) for live playback. These groups are available using the <strong>ngrp:</strong> stream name prefix. The encoding presets in the stream name group have aligned key frames for adaptive streaming delivery.</p>

<p>To view stream name group settings, click the stream name group name in the list.</p>

<p>To create a new stream name group, click <strong>Add Stream Name Group</strong>.</p>

<p>To change stream name group settings, click the <strong>Edit</strong> icon for the stream name group.</p>

<p>To delete a stream name group, click the <strong>Delete</strong> icon for the stream name group.</p>

<h5>Stream Name Group Settings</h5>
<p><strong>Name</strong>. The name of the stream name group in the template. It must be unique and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters.</p>

<p><strong>Stream Name</strong>. The transcoded stream name that's used for playback. It must be unique and can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<p>It's best to use the source stream name as part of the transcoded stream name. You can include the &#36;&#123;SourceStreamName&#125; variable, which is replaced with the source stream name. If you have multiple stream name groups in a template, you must ensure that the transcoded stream name is unique for each one by appending additional characters to the variable (for example, <strong>_all</strong>).</p>

<blockquote><strong>Note:</strong> Be sure that the outgoing stream name for this stream name group doesn't conflict with any outgoing stream names for presets that you configure on the <strong>Encoding Presets</strong> tab. All transcoded stream names must be unique for a given application.</blockquote>

<p><strong>Included Presets</strong>. The encoding presets that are available to include in the stream name group are displayed in the box on the left while the presets that are included in the stream name group are displayed in the box on the right. Use the buttons to manage the presets that are included in the stream name group. A stream name group must have at least one preset.
<ul>
	<li>To add a preset to the stream name group, select the preset in the box on the left, and then click <strong>Add</strong>.
	<li>To add only the video stream from a preset to the stream name group, select the preset in the box on the left, and then click <strong>Video Only</strong>.
	<li>To add only the audio stream from a preset to the stream name group, select the preset in the box on the left, and then click <strong>Audio Only</strong>.
	<li>To remove a preset from the stream name group, select the preset in the box on the right, and then click <strong>Remove</strong>.
	<li>To rearrange the list of presets that are included in the stream name group, select a preset in the box on the left, and then click the <strong>Move Up</strong> and <strong>Move Down</strong> buttons to change its position in the list.
</ul></p>

