<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<div id="streamNameGroupModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="streamNameGroupModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" onClick="javascript:streamNameGroupClose()">x</button>
				<h4 id="streamNameGroupModalLabel" class="modal-title"><wmsform:getlocalestring page="transcoder.template.streamNameGroup" obj="header" /></h4>
				<h4 id="addstreamNameGroupEditModalLabel" class="modal-title"><wmsform:getlocalestring page="transcoder.template.streamNameGroup" obj="addHeader"/></h4>
				<h4 id="editstreamNameGroupEditModalLabel" class="modal-title"><wmsform:getlocalestring page="transcoder.template.streamNameGroup" obj="editHeader"/></h4>
			</div>
			<div class="modal-body">
				<div id="ViewModeDialog">
					<jsp:include page="ViewBasic.jsp" flush="true" />
				</div>
				<div id="EditModeDialog">
					<div id="EditDialogContent">
						<jsp:include page="EditBasic.jsp" flush="true" />
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-8">
						<div id="streamNameGroupDialog.error" class="alert alert-danger" style="display: none"></div>
					</div>
					<div class="col-md-4">
						<wmsform:buttoncancel onClick="streamNameGroupClose()" />
						<wmsform:buttonadd onClick="javascript:streamNameGroupSave()" />
						<wmsform:buttonprimary page="transcoder.template.streamNameGroup" obj="save" onClick="javascript:streamNameGroupSave()" icon="fa fa-hdd-o"/>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>

$(document).ready(function() {
	if("${mode}"=="edit")
	{
		$('#ViewModeDialog').hide();
		$('#EditModeDialog').show();
		$('#streamNameGroupModalLabel').hide();
		if("${action}"=="new")
		{
			$('#save').hide();
			$('#addbtn').show();
			$('#editstreamNameGroupEditModalLabel').hide();
			$('#addstreamNameGroupEditModalLabel').show();
		}
		else
		{
			$('#save').show();
			$('#addbtn').hide();
			$('#editstreamNameGroupEditModalLabel').show();
			$('#addstreamNameGroupEditModalLabel').hide();
		}
	}
	else
	{
		$('#ViewModeDialog').show();
		$('#EditModeDialog').hide();
		$('#streamNameGroupModalLabel').show();
		$('#editstreamNameGroupEditModalLabel').hide();
		$('#addstreamNameGroupEditModalLabel').hide();
		$('#save').hide();
		$('#addbtn').hide();
	}

	$('#streamNameGroupModal').on('shown.bs.modal', function() {
	});
	$('#streamNameGroupModal').modal('show');
});

function streamNameGroupClose() {
	$('#streamNameGroupModal').modal('hide');
}

function streamNameGroupCloseWithRefresh()
{
	$('#streamNameGroupModal').on('hidden.bs.modal', function() {
		showTemplate("${templateName}");
	});
	streamNameGroupClose();
}

function streamNameGroupSave()
{
	var sngDiv = $("#streamNameGroupDiv");

	// need to select all of the members in the list to get them to be serialized in the post.
	$('#members option').each(function() { this.selected = true});

	postAJAXFormDstFormName('server/transcodertemplate/edit_streamnamegroup.htm','appType=${appType}','EditDialogContent','defaultDialogForm');
}

function addEncode()
{
 	$("#memberOptions option:selected").each(function(i){
 		var optionText = $(this).text();
		var exists = false;
		$('#members  option').each(function(){
			if (this.text == optionText) {
		    	exists = true;
			}
		});

 		if(!exists)
 		{
 			$('#members').append($('<option>', {
		        value: optionText,
		        text : optionText
		    }));
 		}
    });
}

function addAudioOnlyEncode()
{
	$("#memberOptions option:selected").each(function(i){
		var optionText = $(this).text() +" (audio only)";
		var exists = false;
		$('#members  option').each(function(){
			if (this.text == optionText) {
		    	exists = true;
			}
		});
 		if(!exists)
 		{
			$('#members').append($('<option>', {
		        value: optionText,
		        text : optionText
		    }));
 		}
	});
}

function addVideoOnlyEncode()
{
	$("#memberOptions option:selected").each(function(i){
		var optionText = $(this).text() +" (video only)";
		var exists = false;
		$('#members  option').each(function(){
			if (this.text == optionText) {
		    	exists = true;
			}
		});
 		if(!exists)
 		{
			$('#members').append($('<option>', {
		        value: optionText,
		        text : optionText
		    }));
 		}
	});
}

function removeEncode()
{
	$('#members :selected').remove();
}

function upEncode()
{
	$('#members option:selected').each(function(){
  		$(this).insertBefore($(this).prev());
		$('#members').scrollTop($('#members').scrollTop()-20);
	});
}

function downEncode()
{
	if($('#members option:selected').length == 1)
	{
		$('#members option:selected').each(function(){
			$(this).insertAfter($(this).next());
			$('#members').scrollTop($('#members').scrollTop()+20);
		});
	}

}

function sortMembers()
{
	 var my_options = $("#members option");

	 my_options.sort(function(a,b) {
	     if (a.text < b.text) return 1;
	     else if (a.text > b.text) return -1;
	     else return 0
	 })

	 $("#members").empty().append( my_options );
}

</script>
