<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<form:form method="post" commandName="formData" id="defaultDialogForm">
	<wmsform:errors path="errorMessage" cssClass="alert alert-danger" />

<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="action"/>
	<form:hidden path="vhost"/>
	<form:hidden path="appName"/>
	<form:hidden path="appType"/>
	<form:hidden path="templateName"/>
	<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>
	<c:choose>
		<c:when test="${action=='new'}">
			<wmsform:editproperty page="transcoder.template.streamNameGroup" obj="groupName" required="yes"/>
		</c:when>
		<c:otherwise>
			<form:hidden path="groupName"/>
			<wmsform:viewproperty page="transcoder.template.streamNameGroup" obj="groupName" />
		</c:otherwise>
	</c:choose>
	<wmsform:editproperty page="transcoder.template.streamNameGroup" obj="streamName" cssClassTitle="control-label" required="yes"/>
	<h5><wmsform:getlocalestring page="transcoder.template.streamNameGroup" obj="encodesView"/></h5>
	<div class="row">
		<div class="col-md-4">
			<form:select path="encodes" items="${requestScope.formData['encodes']}" hidden="true"/>
			<select size="7" class="form-control" id="memberOptions" multiple>
				<c:forEach items="${requestScope.formData['encodes']}" var="item" varStatus="varStatus">
					<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
					<option value="${item}">${item}</option>
				</c:forEach>
			</select>
		</div>
		<div class="col-md-3" style="padding-top:10px">
			<a class="btn btn-primary btn-block" onClick="javascript:addEncode()" title="Add Encode">Add <i class="fa fa-arrow-right"></i></a>
			<a class="btn btn-default btn-block" onClick="javascript:addVideoOnlyEncode()" title="Add Encode with Video Only"><i class="fa fa-video-camera"></i> Video Only <i class="fa fa-arrow-right"></i></a>
			<a class="btn btn-default btn-block" onClick="javascript:addAudioOnlyEncode()" title="Add Encode with Audio Only"><i class="fa fa-volume-up"></i> Audio Only <i class="fa fa-arrow-right"></i></a>
			<a class="btn btn-primary btn-block" onClick="javascript:removeEncode()" title="Remove Encode"><i class="fa fa-arrow-left"></i> Remove</a>
		</div>
		<div class="col-md-4">
			<form:select path="members" items="${requestScope.formData['members']}"  size="7" class="form-control"/>

			<select size="7" id="membersView" class="form-control" multiple style="display:none">
				<c:forEach items="${requestScope.formData['members']}" var="item" varStatus="varStatus">
					<option value="${item}">${item}</option>
				</c:forEach>
			</select>
			<form:errors path="members">
				<c:forEach items="${messages}" var="message">
					<div class="help-block-has-error">${message}</div>
				</c:forEach>
			</form:errors>
		</div>
		<div class="col-md-1" style="padding-top:40px;margin-left:-15px;">
			<button type="button" onClick="javascript:upEncode()" title="Move Up"><i class="fa fa-chevron-up"></i></button><br>
			<button type="button" onClick="javascript:downEncode()" title="Move Down"><i class="fa fa-chevron-down"></i></button>
		</div>
	</div>
</fieldset>

	<form:hidden path="ignoreWarnings" />
</form:form>

<script>
$('#members').find("option").attr("selected", false);
if("${closeDialog}")
{
	streamNameGroupCloseWithRefresh();
}
</script>
