<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<div>
	<div class="row">
		<wmsform:pageerror />
		<wmsform:pagewarning />
		<wmsform:pageinformation />
	</div>
	<div class="row">
		<div class="col-md-9">
			<happ><wmsform:getlocalestring page="serversetup" obj="header"/></happ>
			<br><br />
		</div>
		<div class="col-md-3 appbuttons" id="ServerButtons">
			<wmsform:buttonrestart onClick="javascript:restartServerShow()" />
			<!--        <wmsform:buttonstop onClick="javascript:stopServerShow()" /> -->
		</div>
	</div>

	<sec:authorize access="hasAnyRole('advUser')">
		<div class="row">
			<div class="col-md-12">
				<ul class="nav nav-tabs">
					<li id="ServerBasic" class="active"><a href="javascript:showBasicTab()">Basic</a></li>
					<li id="ServerAdvanced"><a href="javascript:showAdvTab()">Properties</a>
					</li>
					<li id="ServerListeners"><a href="javascript:showListenersTab()">Server Listeners</a></li>
				</ul>
			</div>
		</div>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	<div class="row" id="tabContent">
		<div class="col-md-12">
			<div class="row">
				<div id="ViewMode">
					<div id="TabBasic">
						<jsp:include page="ViewBasic.jsp" flush="true" />
					</div>
					<div id="TabAdv" style="display: none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
					</div>
					<div id="TabListener" style="display: none">
						<jsp:include page="ViewListener.jsp" flush="true" />
					</div>
				</div>
				<div id="EditMode">
					<div id="TabEditBasic">
						<div id="BasicEditColumn" class="col-md-8 main-content">
							<form:form method="post" commandName="formData" id="defaultForm">
								<wmsform:errors path="errorMessage" cssClass="alert alert-danger" />
								<wmsform:rightrailhideshow/>
								<jsp:include page="EditBasic.jsp" flush="true" />
								<form:hidden path="ignoreWarnings" />
							</form:form>
						</div>
						<div id="HelpBasicEdit" class="col-md-4 well-help pull-right right-rail">
							<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
						</div>
					</div>
					<div id="TabEditAdv" style="display: none">
						<div class="col-md-12">
							<form:form method="post" commandName="formDataAdv" id="defaultFormAdv">
								<wmsform:errors path="errorMessage" cssClass="alert alert-danger" />
								<jsp:include page="EditAdv.jsp" flush="true" />
								<form:hidden path="ignoreWarnings" />
							</form:form>
						</div>
					</div>
					<div id="TabEditListener" style="display: none">
						<div class="col-md-12">
							<form:form method="post" commandName="formDataListeners" id="defaultFormListenerns">
								<wmsform:errors path="errorMessage" cssClass="alert alert-danger" />
								<c:import url="EditListener.jsp" />
								<form:hidden path="ignoreWarnings" />
							</form:form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<wmsdialog:restartserver page="serversetup" returnPage="serversetup" />
	<wmsdialog:stopserver page="serversetup" />
	<wmsform:setwarnings />
</div>

<script>
	$(document).ready(function() {
		if (typeof (lastTab) === 'undefined') {
			lastTab = "Basic";
		}

		if ("${mode}" == "edit") {
			$('#ViewMode').hide();
			$('#EditMode').show();
			$('#ServerButtons').hide();
		} else {
			$('#ViewMode').show();
			$('#EditMode').hide();
			$('#ServerButtons').show();
		}
		if (lastTab == "Basic") {
			showBasicTab();
		} else if (lastTab == "Advanced") {
			showAdvTab();
		} else if (lastTab == "Listeners") {
			showListenersTab();
		}
	});

	function showBasicTab() {
		if ("${mode}" == "edit" && lastTab != 'Basic') {
			lastTab = 'Basic';
			loadServerSetup();
			return;
		}
		lastTab = 'Basic';
		createCookie("lastTab", lastTab);
		$('#TabBasic').show();
		$('#TabEditBasic').show();
		$('#TabAdv').hide();
		$('#TabEditAdv').hide();
		$('#TabListener').hide();
		$('#TabEditListener').hide();
		$('#ServerBasic').addClass('active');
		$('#ServerAdvanced').removeClass();
		$('#ServerListeners').removeClass();
	}

	function showAdvTab() {
		if ("${mode}" == "edit" && lastTab != 'Advanced') {
			lastTab = 'Advanced';
			loadServerSetup();
			return;
		}
		lastTab = 'Advanced';
		createCookie("lastTab", lastTab);
		$('#TabBasic').hide();
		$('#TabEditBasic').hide();
		$('#TabAdv').show();
		$('#TabEditAdv').show();
		$('#TabListener').hide();
		$('#TabEditListener').hide();
		$('#ServerBasic').removeClass();
		$('#ServerAdvanced').addClass('active');
		$('#ServerListeners').removeClass();
	}

	function showListenersTab() {
		if ("${mode}" == "edit" && lastTab != 'Listeners') {
			lastTab = 'Listeners';
			loadServerSetup();
			return;
		}
		lastTab = 'Listeners';
		createCookie("lastTab", lastTab);
		$('#TabBasic').hide();
		$('#TabEditBasic').hide();
		$('#TabAdv').hide();
		$('#TabEditAdv').hide();
		$('#TabListener').show();
		$('#TabEditListener').show();
		$('#ServerBasic').removeClass();
		$('#ServerAdvanced').removeClass();
		$('#ServerListeners').addClass('active');
	}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });


</script>







