<%@ include file="/WEB-INF/jsp/taglibs.jsp"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<wmsform:setpagetitle page="serverAbout" />
<link href="css/wowza-charts.css" rel="stylesheet">
<wmsform:setpagetitle page="serverStats" />

<div class="row">
	<div class="col-md-12">
		<happ> <wmsform:getlocalestring page="servermonitoring"
			obj="header" /></happ>
		<br> <small class="text-muted"><wmsform:getlocalestring
				page="common" obj="LocalBrowserTime"></wmsform:getlocalestring></small>
	</div>
</div>
<div style="margin-top:-10px">
	<hr>
</div>
<c:choose>
	<c:when test="${statsEnabled==false}">
		<div class="row">
			<div class="alert alert-warning">
				<h4>
					<wmsform:getlocalestring page="common" obj="MonitoringDisabled" />
				</h4>
				<wmsform:getlocalestring page="common"
					obj="MonitoringDisabledExtended"></wmsform:getlocalestring>
			</div>
		</div>
	</c:when>
	<c:otherwise>
		<c:if test="${machine!=null}">
			<div class="row">
				<div class="col-md-4">
					<h4>
						<wmsform:getlocalestring page="servermonitoring" obj="connections" /> <small><wmsform:getlocalestring page="servermonitoring" obj="connections.sub" /></small>
					</h4>
					<p>
						<strong><wmsform:getlocalestring page="servermonitoring" obj="connections.total" /> <span id="machine-connection-count">${machine.connectionCount}</strong></span>
					</p>
				</div>
				<div class="col-md-7 col-md-offset-1">
					<h4>${serverName} <wmsform:getlocalestring page="servermonitoring" obj="upTime" /></h4>
					<p>
						<strong>${serverName}</strong> <wmsform:getlocalestring page="servermonitoring" obj="upSince" /> <span id="uptime"></span>
					</p>
					<p>
						<strong>${serverName}</strong> <wmsform:getlocalestring page="servermonitoring" obj="upAbout" /> <span id="uptime-pretty"></span>
					</p>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					<hr />
					<h4><wmsform:getlocalestring page="servermonitoring" obj="currentUsage" /></h4>
					<div id="barcharts" style="height: 220px;" class="row-fluid"></div>
					<hr />
				</div>
			</div>
		</c:if>
		<c:if test="${machine==null}">
			<h3>
				<wmsform:getlocalestring page="server" obj="noData" />
			</h3>
		</c:if>
		<div id="series-charts" class="row wowza-series-chart"
			style="margin-left: -15px"></div>
		<c:if test="${machine!=null}">
			<script language="javascript">
$(document).ready(function() {

	if(isNaN(${machine.serverUptime})) {
		$("uptime").html("Unknown");
	} else {
		WOWZA.Util.setUptimeSeconds(${machine.serverUptime}*1000, "#uptime-pretty", "#uptime",false);
	}
	var barchartData = {
		cpu:{label: "Wowza CPU", formatter: function(val)
			{
			return val+"%";
		},
			data: [
			 {label:"Free", data: ${machine.cpuIdle}},
			 {label:"Used", data: ${machine.cpuUser}},
			 ]
		},
		heap:{label: "Wowza Heap", formatter: function(val)
			{
			return WOWZA.Util.HumanReadableBytes(val, 'B');
		},
			data: [{label:"Free", data: ${machine.heapFree}},
			 {label:"Used", data: ${machine.heapUsed}}
			 ]
		},
		memory:{label: "Total Memory", formatter: function(val)
			{
			return WOWZA.Util.HumanReadableBytes(val, 'B');
		},
			data: [{label:"Free", data: ${machine.memoryFree}},
			 {label:"Used", data: ${machine.memoryUsed}}
			 ]
		},
		disk:{label: "Total Disk", formatter: function(val)
			{
			return WOWZA.Util.HumanReadableBytes(val, 'B');
		},
			data: [{label:"Free", data: ${machine.diskFree}},
			 {label:"Used", data: ${machine.diskUsed}}
			 ]
		}
	};
	var barcharts = WOWZA.Charts.HorizontalBar("barcharts", barchartData,{xaxis: {tickFormatter: percent}});
	var updateFn = function() {
		this.barcharts = barcharts;
		updateCharts(barcharts);
	}
	var updateRate = 5000;
	var updateIntervalId = setInterval(updateFn, updateRate);
	barcharts.id = updateIntervalId;
	$(document).on("preContentNavigation", function(e) {
		clearInterval(updateIntervalId);
		$(document).off("preContentNavigation", arguments.callee);
	});

	showPastServerStatistics();
});
var serverAlreadyCreatedForm = false;
function percent(val, axis)
{
	return val+"%";
};
function showPastServerStatistics() {
	if(serverAlreadyCreatedForm) {
		return;
	}
	serverAlreadyCreatedForm = true;
	window.setTimeout(function() {
		var seriesData = ${series};
		var charts = WOWZA.Charts.Series("series-charts", seriesData, {
			baseUrl: "server/monitoring/historical.jsdata",
			resize: true,
			legend:{
				show: true
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderWidth: 1,
				backgroundColor: '#ffffff'
			},
			xaxis: {
				mode: "time",
				timezone: "browser",
				twelveHourClock:true
			},
			series: {
				points: {
					radius: 3,
					show: false
				},
				shadowSize: 0
			},
			colors: WOWZA.Util.FlotColors
		});
	},100);
};

function updateCharts(context) {
	$.ajax({
		url: 'server/monitoring/server.jsdata',
		headers: {
			Accept : "application/json"
		},
		cache: false
	}).fail(function(jqXHR, textStatus) {
		alert("Request failed: "+textStatus);
		clearInterval(context.id);
	}).done( function(newData) {
		if (!(newData instanceof Object) && newData.substring(0, redirectLoginString.length) == redirectLoginString) {
			document.location = "login.htm" + location.hash;
			return;
		}
		$("#machine-connection-count").html(newData.machineMetrics.connectionCount);
		WOWZA.Util.setUptimeSeconds(newData.machineMetrics.serverUptime*1000, "#uptime-pretty", "#uptime", false);
		var barData = {
			cpu:{label: "Wowza CPU",
				data: [
				 {label:"Free", data: newData.machineMetrics.cpuIdle},
				 {label:"Used", data: newData.machineMetrics.cpuUser},
				 ]
			},
			heap:{label: "Wowza Heap",
				data: [{label:"Free", data: newData.machineMetrics.heapFree},
				 {label:"Used", data: newData.machineMetrics.heapUsed}
				 ]
			},
			memory:{label: "Total Memory",
				data: [{label:"Free", data: newData.machineMetrics.memoryFree},
				 {label:"Used", data: newData.machineMetrics.memoryUsed}
				 ]
			},
			disk:{label: "Total Disk",
				data: [{label:"Free", data: newData.machineMetrics.diskFree},
				 {label:"Used", data: newData.machineMetrics.diskUsed}
				 ]
			}
		};
		WOWZA.Charts.HorizontalBar("barcharts", barData,{xaxis: {tickFormatter: percent}});
	});
};
			</script>
		</c:if>
	</c:otherwise>
</c:choose>
