<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>


<c:set var="errorLoadingFile">
	<wmsform:getlocalestring page="serverLogs" obj="errorLoadingFile"/>
</c:set>
<c:set var="noDataInFile">
	<wmsform:getlocalestring page="serverLogs" obj="noDataInFile"/>
</c:set>
<c:set var="fileNotFound">
	<wmsform:getlocalestring page="serverLogs" obj="fileNotFound"/>
</c:set>


<wmsform:setpagetitle page="serverLogs"/>

<form:form method="post" commandName="formData" id="serverLogsForm"><fieldset>
<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-12">
			<happ><wmsform:getlocalestring page="serverlogs" obj="header"/></happ>
			<br>
			<small class="text-muted"><wmsform:getlocalestring page="serverLogs" obj="adminPrivilegesRequired"/><a href="javascript:lastServerMC='serverusers';loadAjaxSideBar('SB_Server.html','')">Users</a><br></br></small>
		</div>
	</div>
	<sec:authorize access="hasAnyRole('admin')">
		<form:hidden path="logSource"/>
		<div class="row">
			<div class="col-md-12">
				<ul class="nav nav-tabs">
					<li id="serverEngineTab" class="active"><a href="javascript:loadLogFileList('engine')">Wowza Streaming Engine Server Logs</a></li>
					<li id="serverManagerTab"><a href="javascript:loadLogFileList('manager')">Wowza Streaming Engine Manager Logs</a></li>
				</ul>
			</div>
		</div>
	
		<div id="logType" style="float:left;width:170px;"><wmsform:editpropertyhorizontalradiolist page="serverLogs" obj="logType"/></div>
		<div id="logMode" style="float:left;width:210px;"><wmsform:editpropertyhorizontalradiolist page="serverLogs" obj="logMode"/></div>
		<div id="reverseDisplayId" style="float:left;width:280px;margin:26px 0 0 0;"><wmsform:editpropertycheckbox page="serverLogs" obj="reverseDisplay"/></div>
		<div style="clear:both;"></div>

		<div id="filterOptions" class="row" style="margin:10px 0;max-width:980px;color:#000;border-radius:5px;padding:10px;background:#efefef;">
			<div style="float:left;width:190px;margin:0 0 0 0;">
				<div style="margin:0 0 0 5px;color:#000;font-weight: bold;"><wmsform:getlocalestring page="serverLogs" obj="startDate"/></div>
				<div style="margin:5px 0 0 0;"><wmsform:editpropertydropdown page="serverLogs" obj="startDate" showTitle="false"/></div>
			</div>
			<div style="float:left;width:190px;margin:0 0 0 5px;">
				<div style="margin:0 0 0 5px;color:#000;font-weight: bold;"><wmsform:getlocalestring page="serverLogs" obj="endDate"/></div>
				<div style="margin:5px 0 0 0;"><wmsform:editpropertydropdown page="serverLogs" obj="endDate" showTitle="false" bind="false"/></div>
			</div>
			<div style="float:left;width:275px;margin:0 0 0 10px;">
				<div style="margin:0;color:#000;font-weight: bold;"><wmsform:getlocalestring page="serverLogs" obj="logLevelFilter"/></div>
				<div style="float:left;padding:0;margin:11px 0 0 0;">
					<div style="float:left;margin:0 0 0 0;"><wmsform:editpropertycheckbox page="serverLogs" obj="showInfo"/></div>
					<div style="float:left;margin:0 0 0 12px;"><wmsform:editpropertycheckbox page="serverLogs" obj="showWarning"/></div>
					<div style="float:left;margin:0 0 0 12px;"><wmsform:editpropertycheckbox page="serverLogs" obj="showError"/></div>
					<div style="float:left;margin:0 0 0 12px;"><wmsform:editpropertycheckbox page="serverLogs" obj="showDebug"/></div>
				</div>
			</div>
			<div style="float:left;width:174px;margin:0 0 0 10px;">
				<div style="margin:0;color:#000;font-weight: bold;"><wmsform:getlocalestring page="serverLogs" obj="keyword"/></div>
				<div style="float:left;padding:0;margin:5px 0 0 0;">
					<div style="float:left;margin:0"><wmsform:editproperty page="serverLogs" obj="keyword" showTitle="false"/></div>
				</div>
			</div>
			
			<div id="viewLogFileId" class="row" style="margin:10px 0;max-width:860px;">
				<div style="float:left;width:196px;margin:0 10 0 0;">
					<a class="btn btn-primary md" onclick="javascript:loadLogFile('load')" style="width:186px;"><i class="fa fa-file-text-o"></i> <fmt:message key="serverLogs.viewLogs"/></a>
				</div>
				<div class="text-muted" style="float:left;width:380px;margin:0 0 0 0;">
					<wmsform:getlocalestring page="serverLogs" obj="logFileImportant"/>
				</div>
			</div>
			<div id="serverLogsDownloadId" class="row" style="margin:10px 0;max-width:860px;">
				<div style="float:left;width:196px;margin:0 10 0 0;">
					<a class="btn btn-default btn-xs" onclick="javascript:downloadLogFile()" style="width:186px;"><i class="fa fa-download"></i> <fmt:message key="serverLogs.download"/></a>
		 		</div>
				<div class="text-muted" style="float:left;width:380px;margin:0 0 0 0;">
					<wmsform:getlocalestring page="serverLogs" obj="downloadingLargeFiles"/>
		 		</div>
			</div>
		</div>			
		
		<div id="logFileImportantRealTimeId" class="row" style="margin:10px 0;max-width:980px;color:#000;border-radius:5px;padding:10px;background:#efefef;">
			<div class="row" style="margin:10px 0;max-width:860px;">
				<div style="float:left;width:196px;margin:0 10 0 0;">
					<input type="button" class="btn btn-primary md" style="width:186px;" value="<fmt:message key="serverLogs.refreshNow"/>" onClick="javascript:refreshData()" >
				</div>
				<div class="text-muted" style="float:left;width:380px;margin:0 0 0 0;">
					<wmsform:getlocalestring page="serverLogs" obj="logFileImportantRealTime"/>
				</div>
			</div>
		</div>
		<hr/>
		
		<div id="logVersion"></div>
		<div id="logStartDate"></div>
		<div id="logSoftware"></div>
		<div id="logDate"></div>
		<br/>
		
		<div id="logLines">
			<c:if test="${fn:length(requestScope.formData[logLines])<=0}">
				<div id="errorText"><wmsform:getlocalestring page="serverLogs" obj="noLogFileLoaded"/></div>
			</c:if>
			<br>
		</div>
	</sec:authorize>
	
</div>
</fieldset></form:form>
<script type="text/javascript">
// call same function as View Logs button on key down of return 
$("#serverLogsForm").bind("keypress", function(e) {
	if (e.keyCode == 13) {
		loadLogFile('load');
	}
});

var start = 0;
var end = 0;
var length = 0;
var count = 500;
var contentLoadTriggered = false;
var reverseDisplay = false;
var engineColWidths = ["8px","28px","23px","60px","50px"];
var managerColWidths = ["8px","28px","23px","40px","60px"];
var refreshIntervalId = null;
var refreshRate = 5000;
var position = 0;
var noMoreData = false;
var dateToFile = {};

$(document).ready(function() {
	// build file date to file name map
	<c:forEach var="date" items="${formData.startDateOptions}" varStatus="index">
		dateToFile['${date}'] = {id:'${formData.logFiles[index.index].id}',ms:'${formData.logFiles[index.index].startDateMS}'} ;
	</c:forEach>
	
	$(document).on("preContentNavigation", function(e) {
		stopAutoRefresh();
		$(document).off("preContentNavigation", arguments.callee);
	});

	$(window).scroll(function(e) {
		var scroll = $(window).scrollTop();
	    if(scroll > position && !noMoreData) {
		    if (loadMoreData()) {
		   		loadLogFile("next");
		    }
	    } else {
	         // scrolling upwards
	    }
	    position = scroll;
	});
	
	if (isAdmin) {
		// populate the endDate options with options from startDate and set endDate selection
		$('#endDate option')[0].remove();
		$('#startDate option').clone().appendTo('#endDate');
		$('#endDate').val($('#startDate').val());
		$("#startDate")[0].onchange = startDateChanged;
		$("#endDate")[0].onchange = endDateChanged;
		
		$("[name='logMode']")[0].onclick = enableDisableControls;
		$("[name='logMode']")[1].onclick = enableDisableControls;
	
		$("[name='logType']")[0].onclick = logTypeChanged;
		$("[name='logType']")[1].onclick = logTypeChanged;
	
		$('#reverseDisplay1')[0].onclick = clearTableData;
		
		showLogsTab($('#logSource').val());
	}
});

function showLogsTab(tab) {
//	createCookie("serverLogsSelectedTab", tabSelected);
	if (tab=='engine')
	{
		$('#serverManagerTab').removeClass('active');
		$('#serverEngineTab').addClass('active');
	}
	else // manager
	{
		$('#serverEngineTab').removeClass('active');
		$('#serverManagerTab').addClass('active');
	}
	enableDisableControls(); 
}

function downloadLogFile() {
	// load loglines for selected log file
	var startDate = $("#startDate option:selected").val();
	var logType = $('input[name="logType"]:checked').val();
	var logSource = $('#logSource').val();
	// get filename from startDate
	var logName = getFileNameFromDate(startDate);
	
	if (logName != null) {
		window.open("server/logs/download?"+"logType="+logType+"&logName="+logName+"&logSource="+logSource, "_blank");
	}
}

function loadLogFile(action) {
	var logMode = $('input[name="logMode"]:checked').val();
	var reverseDisplay = $('#reverseDisplay1').is(':checked');
	
	if (action == "load") {
		noMoreData = false;
	    // remove old table
	    clearTableData();
	    if (logMode == "realTime") {
	    	reverseDisplay = true;
			action = "last";
	    } else {
			action = "first";
	    }
	}

	if (logMode == "realTime") {
		if (action == "next") {
			reverseDisplay = false;
		}
	} else if (logMode == "historical" && reverseDisplay) {
		if (action == "first")
			action = "last";
		else if (action == "last")
			action = "first";
		else if (action == "next")
			action = "prev";
		else if (action == "prev")
			action = "next";
	}
	
	if (logMode == "historical" && ((action == "prev" && start <= 0) || (action == "next" && end >= length) || (logMode == "realTime" && action != "last"))) {
		return;
	} else {
		loadLogData(action, logMode, start, end, count, reverseDisplay);
	}
}

function loadLogData(action, logMode, reqStart, reqEnd, reqCount, reqReverseDisplay) {
	var logType = $('input[name="logType"]:checked').val();
	var logSource = $('#logSource').val();
	var searchString = $('#keyword').val();
	var startDate = $("#startDate option:selected").val();
	var endDate = $("#endDate option:selected").val();
	var logName = getFileNameFromDate(startDate);
	var startDateMS = 0;
	var endDateMS = 0;
	var filter = "noHeader";
	
	if (logName == null)
		return;
	
	console.log("loading: "+logName);

	if (startDate != endDate) {
		startDateMS = dateToFile[startDate].ms;	
		endDateMS = dateToFile[endDate].ms;	
	}
	
	if (!$('input[name="showInfo"]').is(':checked')) {
		filter = filter + "|noInfo";
	}
	if (!$('input[name="showWarning"]').is(':checked')) {
		filter = filter + "|noWarn";
	}
	if (!$('input[name="showError"]').is(':checked')) {
		filter = filter + "|noError";
	}
	if (!$('input[name="showDebug"]').is(':checked')) {
		filter = filter + "|noDebug";
	}

	contentLoadTriggered = true;
	
	// make data request
	$.ajax({
	  url: "server/logs/getlog.jsdata?"+"action="+action+"&logType="+logType+"&logMode="+logMode+"&logSource="+logSource+"&logName="+encodeURI(logName)+"&start="+reqStart+"&end="+reqEnd+
			  "&count="+reqCount+"&filter="+encodeURI(filter)+"&reverseDisplay="+reqReverseDisplay+
			  "&keyword="+encodeURI(searchString)+"&startDate="+startDateMS+"&endDate="+endDateMS,
	  context: document.body
	}).fail(function(jqXHR, textStatus) {
		updateErrorText("${errorLoadingFile}");
		contentLoadTriggered = false;
	}).done(function(data, textStatus, jqXHR) {
		if (!(data instanceof Object)
				&& data.substring(0, redirectLoginString.length) == redirectLoginString) {
			document.location = "login.htm" + location.hash;
			return;
		}
		contentLoadTriggered = false;
		var logLines = data.logLines;
	    var div = document.getElementById('logLines');

		console.log("req  start:"+start+" end:"+end+" count:"+count+" length:"+length);
		
		// if there is no more data, stop requestsing data on page down
		if (logMode == "historical" && start ==  data.startOffset && end == data.endOffset && length == data.fileLength && data.count == 0) {
			noMoreData = true;
		}
		
		// update the global vars
		start = data.startOffset;
		end = data.endOffset;
		length = data.fileLength;
		console.log("resp start:"+start+" end:"+end+" count:"+data.count+" length:"+length);
		
		if (logLines != null && logLines.length > 0) {
			// get the logLines div 
		    var div = document.getElementById("logLines");
		    // remove the no log file loaded text
		    var errorText = document.getElementById("errorText");
		    if (errorText) {
		    	errorText.parentNode.removeChild(errorText);
		    }
		    // update version, start-date, software and date if not populated
		    if (document.getElementById("logVersion").innerHTML == "") {
		    	document.getElementById("logVersion").innerHTML = "Version: "+data.logVersion+"<br>";
			    document.getElementById("logStartDate").innerHTML = "Start-Date: "+data.logStartDate+"<br>";
			    document.getElementById("logSoftware").innerHTML = "Software: "+data.logSoftware+"<br>";
			    document.getElementById("logDate").innerHTML = "Date: "+data.logDate+"<br>";
		    }

		    var tbl = document.getElementById("logLinesTable");
		    // create table if missing
			var tableHeadings = data.tableHeadings;
		    if (tbl == null) {
		        tbl = document.createElement('table');
		        tbl.id = "logLinesTable";
		        tbl.className = "table table-striped table-fixed";
		    	createTableHeader(tbl, tableHeadings);
				div.appendChild(tbl);
		    }
		    var tbody = document.getElementById("logData");
		    // create table body if missing
		    if (tbody == null) {
				tbody = document.createElement("tbody");
				tbody.id = "logData";
		    	tbl.appendChild(tbody);
		    }
		    
		    if (logMode == "realTime" && action == "next") {
		    	addTableData(tbody, tableHeadings, logLines, true);
		    	// trim table data by loglines.length to maintain count lines
		    	var rows = document.getElementById('logData').rows;
	    		for (var i = rows.length-1; i > count-1; i--) {
	    			tbody.deleteRow(i);
	    		}
		    } else {
		    	addTableData(tbody, tableHeadings, logLines, false);
		    }
		} else if (logMode == "historical" && document.getElementById("logData") == null) { 
			if (logLines != null ) {
				updateErrorText("${noDataInFile}");
			} else {
				updateErrorText("${fileNotFound}");
			}
		}
	});
}

function loadMoreData() {
	var logMode = $('input[name="logMode"]:checked').val();
    var retVal = false;

	if (logMode == "historical") {
	    var docViewTop = $(window).scrollTop();
	    var docViewBottom = docViewTop + $(window).height();
	    var last = $( "tr:last");

	    if (last.offset() != null) {
		    var elemTop = last.offset().top;
		    var elemBottom = elemTop + last.height();
		 
		    if ((elemBottom <= docViewBottom) && (elemTop >= docViewTop) && !contentLoadTriggered) {
		    	retVal = true;
		    }
	    }
	}    
    return retVal;
}

function formatInfoText(text, label) {
	var ret = "";
    if (text !== null && text !== "-")
    	ret += "<b>"+label+"</b>"+text+",";
    return ret;
}

function clearTableData() {
    // remove old table
    var tbl = document.getElementById("logLinesTable");
    if (tbl != null)
    	tbl.parentNode.removeChild(tbl);
    // clear version, software, startdate, etc
    document.getElementById("logVersion").innerHTML = "";
    document.getElementById("logStartDate").innerHTML = "";
    document.getElementById("logSoftware").innerHTML = "";
    document.getElementById("logDate").innerHTML = "";
}

function updateErrorText(text) {
    var div = document.getElementById('logLines');
    // remove the no log file loaded text
    var errorText = document.getElementById("errorText");
    // create error text div if necessary
    if (errorText == null) {
    	errorText = document.createElement('div');
    	errorText.id = "errorText";
    	div.appendChild(errorText);
    }
    errorText.innerHTML = text;
}

function enableDisableControls() { 
	var logMode = $('input[name="logMode"]:checked').val();
	if (logMode == "historical") {
		stopAutoRefresh();
		$('#reverseDisplayId').show();
		$('#filterOptions, #viewLogFileId, #serverLogsDownloadId').show();
		$('#buttonRefresh, #logFileImportantRealTimeId').hide();
	} else {
		$('#filterOptions, #viewLogFileId #serverLogsDownloadId, #reverseDisplayId').hide();
		$('#buttonRefresh, #logFileImportantRealTimeId').show();
		loadLogFile("load");
		startAutoRefresh(refreshRate);
	}
	clearTableData();
}

// set end date to match start date 
function startDateChanged() {
 	var startDateSelected = $("#startDate option:selected").val();
	var selectedIndex = $("#startDate")[0].selectedIndex;
	var endDateOptions = $("#endDate option");
	var startDateOptions = $("#startDate option");
	
 	if (selectedIndex > endDateOptions.length-1) {
 		// add options in endDate upto the selected date
 		var endDate = $("#endDate")[0];
		for (i=endDateOptions.length; i <= selectedIndex; i++) {
			endDate.add($(startDateOptions[i]).clone()[0]);
		}
 	} else {
		// remove options in endDate after selected date
		for (i=endDateOptions.length-1; i > selectedIndex; i--) {
			endDateOptions[i].remove();
		}
 	}
	
	$("#endDate").val(startDateSelected);
	endDateChanged();
}

//clear/set download button 
function endDateChanged() {
 	var startDateSelected = $("#startDate option:selected").val();
 	var endDateSelected = $("#endDate option:selected").val();

 	if (startDateSelected == endDateSelected) {
 		$('#serverLogsDownloadId').show();	
 	} else {
 		$('#serverLogsDownloadId').hide();	
 	}
 	
 	
}

function logTypeChanged() {
	loadLogFileList($('#logSource').val());
}

function loadLogFileList(tabSelected) {
	var logType = $('input[name="logType"]:checked').val();
	var logMode = $('input[name="logMode"]:checked').val();

	loadAjaxMainContent('server/logs/view.htm','logType='+logType+'&logMode='+logMode+'&logSource='+tabSelected);
}

function createTableHeader(tbl, tableHeadings) {
    var theader = document.getElementById("logLinesHeader");
    // add the table headers if necessary
	if (theader == null && tableHeadings.length > 0) {
		// create new theader
	    var thead = tbl.createTHead();
		thead.id = "logLinesHeader";
	    tbl.appendChild(thead);
	    // create new row for headers
		var tr = thead.insertRow();
	    thead.appendChild(tr);
	    // for each tableHeading, add a <TH> cell
    	for(var i = 0; i < tableHeadings.length; i++) {
		    // set column widths based on the tableHeading width
    		var col = document.createElement("COL");
		    if (logSource == "engine") {
		    	col.width = engineColWidths[i];
		    } else {
		    	col.width = managerColWidths[i];
		    }
    		tbl.appendChild(col);
    		// add column heading to the row
    		var th = document.createElement("TH");
          	th.innerHTML = tableHeadings[i].text;
          	tr.appendChild(th);
    	}
	}
}

function addTableData(tbody, tableHeadings, logLines, prepend) {
    // for each entry in the logLines list add a row to the table body
    for(var i = 0; i < logLines.length; i++) {
        var data = logLines[i].data;
        var tr ;
        if (prepend) {
        	tr = tbody.insertRow(0);
        } else {
        	tr = tbody.insertRow();
        }
        
        // for each table column, get the cell text from logline data
    	for (var j = 0; j < tableHeadings.length; j++) {
    		var text = data[j];
        	var td = tr.insertCell(j);
        	var cellDiv = document.createElement("div");
        	td.appendChild(cellDiv);
    		cellDiv.style.wordWrap = 'break-word';
			if (text == "ERROR")
				text = "<div style='font-size: 23px'><I class='fa fa-times-circle' style='color:#b94a48'></i></div>";
			else if (text == "WARN")
				text = "<div style='font-size: 23px'><I class='fa fa-exclamation-triangle' style='color:#fbab00'></i></div>";
			else if (text == "DEBUG")
				text = "<div style='font-size: 23px'><I class='fa fa-bug' style='color:#3CA91F'></i></div>";
			else if (text == "INFO")
				text = "<div style='font-size: 23px'><I class='fa fa-exclamation-circle' style='color:#3d73a5'></i></div>";
				
    		cellDiv.innerHTML = text;
    	}
    }
}

function refreshData() {
	loadLogFile('next');
}

function startAutoRefresh(rate) {
	refreshIntervalId = setInterval(refreshData, rate);
}

function stopAutoRefresh() {
	if (refreshIntervalId != null) {
		clearInterval(refreshIntervalId);
		refreshIntervalId = null;
	}
}

function getFileNameFromDate(date)
{
	if (dateToFile != null && date != null) {
		return dateToFile[date].id;
	} else {
		return null;
	}
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>






