<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<script type="text/javascript" src="applications/test/Silverlight.js"></script>
<c:set var="appTypeForPlayer" value="${appType}" />
<c:if test="${appType=='vodedge'}">
	<c:set var="appTypeForPlayer" value="vod" />
</c:if>
<c:if test="${appType=='vodhttporigin'}">
	<c:set var="appTypeForPlayer" value="vod" />
</c:if>
<c:if test="${appType=='liveedge'}">
	<c:set var="appTypeForPlayer" value="live" />
</c:if>
<c:if test="${appType=='livehttporigin'}">
	<c:set var="appTypeForPlayer" value="live" />
</c:if>

<script type="text/javascript">
	// For version detection, set to min. required Flash Player version, or 0 (or 0.0.0), for no version detection.
	var swfVersionStr = "10.3.0";
	// To use express install, set to playerProductInstall.swf, otherwise the empty string.
	var xiSwfUrlStr = "playerProductInstall.swf";
	var flashVars =
	{
		editStreamBar : false
	};
	disconnectHTML5 = 0;
	var params = {};
	params.quality = "high";
	params.bgcolor = "#000000";
	params.allowscriptaccess = "sameDomain";
	params.allowfullscreen = "true";
	params.FlashVars = "showStreamBar=false";
	params.wmode = "opaque";
	var attributes = {};
	attributes.id = "${appTypeForPlayer}HTTPPlayer";
	attributes.name = "${appTypeForPlayer}HTTPPlayer";
	attributes.align = "middle";
	ndvrEnabled = "${ndvrEnabled}" == "true";

	$.getScript("applications/test/swfobject.js", function()
	{
	});

	AC_FL_RunContent = 0;
</script>

<script src="applications/test/AC_RunActiveContent.js"
	language="javascript"></script>
<script>
	//we need to overwrite this function because it does a document.write.  Need to set innerHtml instead.
	function AC_Generateobj(objAttrs, params, embedAttrs)
	{
		if(GetSwfVer()===-1) {
			if ($("#${appTypeForPlayer}RTMPPlayerContainer").length > 0)
				document.getElementById("${appTypeForPlayer}RTMPPlayerContainer").innerHTML="<h2>To view this page ensure that Adobe Flash Player version 11.1.0 or greater is installed.</h2>";
			return;
		}
		var str = '';
		if (isIE && isWin && !isOpera)
		{
			str += '<object ';
			for ( var i in objAttrs)
			{
				str += i + '="' + objAttrs[i] + '" ';
			}
			str += '>';
			for ( var i in params)
			{
				str += '<param name="' + i + '" value="' + params[i] + '" /> ';
			}
			str += '</object>';
		} else
		{
			str += '<embed id="${appTypeForPlayer}RTMPPlayer" ';
			for ( var i in embedAttrs)
			{
				str += i + '="' + embedAttrs[i] + '" ';
			}
			str += '></embed>';
		}
		if ($("#${appTypeForPlayer}RTMPPlayerContainer").length > 0)
			document.getElementById("${appTypeForPlayer}RTMPPlayerContainer").innerHTML = str;


	}

	function supports_hls_video()
	{
		if (videoObj.canPlayType)
		{
			if (videoObj.canPlayType('application/x-mpegURL'))
			{
				if (videoObj.canPlayType('video/mp4; codecs="avc1.42E01E, mp4a.40.2"'))
				{
					return true;
				}
			}
		}
		return false;
	}
	function supports_media_source()
	{
		"use strict";
		var hasWebKit = (window.WebKitMediaSource !== null && window.WebKitMediaSource !== undefined), hasMediaSource = (window.MediaSource !== null && window.MediaSource !== undefined);
		return (hasWebKit || hasMediaSource);
	}
</script>
<!--
	For new players, please ensure the top tab button has an id formed like test<Protocol> and
	that the tab div has an id formed like Tab<Protocol> and then simply add the Protocol to the
	array created in showTab

 -->
 <div id="mobileSelector" class="visible-xs visible-sm"></div>
<div id="testApplicationModal" class="modal fade" tabindex="-1" style="position:fixed;margin: 0px;overflow:auto;"
	role="dialog" aria-labelledby="testApplicationModalLabel"
	aria-hidden="true">
	<div class="modal-dialog test-application-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" onClick="javascript:testApplicationClose()">x</button>
				<h4 class="modal-title">
					<wmsform:getlocalestring page="testplayer" obj="title"/>
					<i id="infoPopup" class="fa fa-question-circle" data-html="true" data-content="<wmsform:getlocalestring page="testplayer" obj="infoPopupMessage"/>" data-toggle="popover" data-animation="true" data-delay="150" data-original-title="<wmsform:getlocalestring page="testplayer" obj="infoPopupTitle"/>" ></i>
					<script>
						WOWZA.Util.DialogPopover("#infoPopup");
					</script>
				</h4>
				<c:choose>
					<c:when test="${drmEnabled}">
						<div class="alert alert-warning">
							<wmsform:getlocalestring page="testplayer" obj="drmPlaybackWarning"/>
						</div>
					</c:when>
				</c:choose>
			</div>
			<div id="testAppBody" class="modal-body"
				style="min-height:600px;max-height:675px;height:auto;overflow-y: hidden; overflow-x: hidden;">
				<div class="form-group">
					<div class="controls">
						<div class="row">
							<div class="col-md-5">
								<div class="input-group">
									<span class="input-group-addon">
										<wmsform:getlocalestring page="testplayer" obj="server"/>
									</span>
									<input id="server" class="form-control" type="text" placeholder="" value="" />
								</div>
								<div class="visible-xs visible-sm" style="line-height:10px"><br></div>
							</div>
							<div class="col-md-7">
								<div class="input-group">
									<span class="input-group-addon">
										<wmsform:getlocalestring page="testplayer" obj="applicationInstance"/>
									</span>
									<input id="applicationInstance" type="text" placeholder="" value="" class="form-control" />
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="controls">
						<div class="row">
							<div class="col-md-12">
								<div class="input-group">
									<c:choose>
										<c:when test='${appTypeForPlayer=="live"}'>
											<span class="input-group-addon">
												<wmsform:getlocalestring page="testplayer" obj="stream"/>
											</span>
										</c:when>
										<c:otherwise>
											<span class="input-group-addon">
												<wmsform:getlocalestring page="testplayer" obj="mediaFileName"/>
											</span>
										</c:otherwise>
									</c:choose>
									<input id="stream" type="text" placeholder="" value="" class="form-control" />
								</div>
							</div>
						</div>
					</div>
				</div>
				<!--<ul class="nav nav-tabs visible-xs">
					<li id="testMobile"><a href="javascript:showTab('Mobile')">Mobile
					</a></li>
				</ul-->
				<!--ul class="nav nav-tabs visible-sm">
					<li id="testDash"><a href="javascript:showTab('Dash')">MPEG
							DASH</a></li>
					<li id="testHLS"><a href="javascript:showTab('HLS')">Apple
							HLS</a></li>
					<li id="testMobile"><a href="javascript:showTab('Mobile')">Mobile
					</a></li>
				</ul-->
				<div class="visible-md visible-lg">
					<ul class="nav nav-tabs">
						<li id="testDash"><a href="javascript:showTab('Dash')">MPEG
								DASH</a></li>
						<li id="testHLS"><a href="javascript:showTab('HLS')">Apple
								HLS</a></li>
						<li id="testRTMP"><!-- class="hidden-xs hidden-sm"--><a href="javascript:showTab('RTMP')">Adobe
								RTMP</a></li>
						<li id="testHDS"><!--class="hidden-xs hidden-sm"--><a
							href="javascript:showTab('HDS')">Adobe HDS</a></li>
						<li id="testSmooth"><!-- class="hidden-xs hidden-sm"--><a href="javascript:showTab('Smooth')">MS
								Smooth</a></li>
						<li id="testMobile"><a href="javascript:showTab('Mobile')">Mobile
						</a></li>
					</ul>
				</div>
				<div class="visible-xs visible-sm">
					<select class="form-control" onchange="showMobileTestPlayer(value);">
						<option id="testMobile2" value="Mobile">Mobile</option>
						<option id="testDash2" value="Dash">MPEG-DASH</option>
						<option id="testHLS2" value="HLS">Apple HLS</option>
						<option id="testRTMP2" value="RTMP">Adobe RTMP</option>
						<option id="testHDS2" value="HDS">Adobe HDS</option>
						<option id="testSmooth2" value="Smooth">MS Smooth</option>
					</select>
					<hr>
				</div>

				<div id="tabTestContent">
					<div id="TabHDS"
						style="position: absolute; width: 93%; background-color: #fff; overflow-x: none;">

						<c:choose>
							<c:when test="${config.adobeHDS}">
								<div class=" row" id="ndvrControls" style="display: none;">
									<div class="col-md-2" style="margin-top: 5px">
										<span class="inline pull-right"><strong>Stream
												URL</strong></span>
									</div>
									<div class="col-md-8">
										<input type="text" id="hdsUrl" class="form-control"
											placeholder="" value="">
									</div>
									<div class="col-md-2">
										<button id="connectHds" type="button" class="btn btn-default pull-right"
											onclick="javascript:ndvrConnect(true)" style="width: 100px;">Start</button>
									</div>
								</div>
								<div id="hdsWrapper" style="background-color: #fff;">
									<div>
										<p>To view this page ensure that Adobe Flash Player version
											11.1.0 or greater is installed.</p>
									</div>
								</div>
							</c:when>
							<c:otherwise>
								<center>
									<h2>Adobe HDS streaming is not enabled for this application.</h2>
								</center>
							</c:otherwise>
						</c:choose>
					</div>
					<div id="TabRTMP"
						style="position: absolute; width: 95%; height: 475px; background-color: #fff; overflow-x: none;">
						<c:choose>
							<c:when test="${config.adobeRTMP}">
								<div id="${appTypeForPlayer}RTMPPlayerContainer">
									<div><h2>To view this page ensure that Adobe Flash Player version 11.1.0 or greater is installed.</h2></div>
								</div>
							</c:when>
							<c:otherwise>
								<center>
									<h2>Adobe RTMP streaming is not enabled for this
										application.</h2>
								</center>
							</c:otherwise>
						</c:choose>
					</div>
					<div id="TabHLS"
						style="position: absolute; width: 95%; background-color: #fff; height: 475px;overflow-x: none;">
						<c:choose>
							<c:when test="${config.appleHLS}">
								<div id="notsupported">
									<br /> <br /> <br />
									<center>
										<h2>
											<b>HTML5 or HLS is not supported in this browser</b>
										</h2>
									</center>
									<br /> <br /> <br />
								</div>
								<div id="supported"
									style="background-color: #fff;  display: none;">
									<div class="row">
										<!--div class="col-md-2" style="margin-top: 5px">
											<span class="inline"><strong>Stream
													URL</strong></span>
										</div-->
										<div class="col-md-12">
											<div class="input-group" style="max-width:655px">
												<input type="text" id="html5connectStr"
													class="form-control" placeholder="" value="">
												<span class="input-group-btn">
													<button id="connectObj" type="button" class="btn btn-default"
														onclick="javascript:connect()">Start</button>
												</span>
											</div>
										</div>
										<!--div class="col-md-2">
											<button id="connectObj" type="button" class="btn btn-default"
												onclick="javascript:connect()" style="width: 82px">Start</button>
										</div-->
									</div>

									<div class="row">
										<div class="col-md-12">
											<style>
												video {
													background-color: #000000;
												}
											</style>
											<video id="videoObj" x-webkit-airplay="allow" controls
												alt="Example File" width="650" height="365"
												onerror="failed(event)" oncanplay="canPlay()" />
										</div>
									</div>
									<div class="row">
										<div class="input-group indent1">
											<label class="control-label">Status:</label> <span
												class="uneditable-input" id="statusStr"
												style="width: 605px;">This is a test</span>
										</div>
									</div>
									<script>
										if (supports_hls_video())
										{
											$("#notsupported").hide();
											$("#supported").show();
										} else
										{
											$("#supported").hide();
										}
										function connect()
										{
											if (connectObj.textContent == "Stop")
											{
												disconnectHTML5();
											} else
											{
												connectObj.textContent = "Stop";
												statusStr.textContent = "";
												videoObj.src = html5connectStr.value;
												videoObj.load();
											}
										}
										function disconnectHTML5()
										{
											if (!isIE && supports_hls_video())
											{
												connectObj.textContent = "Start";
												videoObj.pause();
												videoObj.src = null;
												videoObj.load();
												statusStr.textContent = "";
											}
										}
										function canPlay()
										{
											playControl();
										}
										function playControl()
										{
											if (videoObj.paused == false)
											{
												videoObj.pause();
											} else
											{
												videoObj.play();
												statusStr.textContent = "Playing";
											}
										}
										function failed(e)
										{
											// video playback failed - show a message saying why
											switch (e.target.error.code)
											{
											case e.target.error.MEDIA_ERR_ABORTED:
												statusStr.textContent = 'You aborted the video playback.';
												break;
											case e.target.error.MEDIA_ERR_NETWORK:
												statusStr.textContent = 'A network error caused the video download to fail part-way.';
												break;
											case e.target.error.MEDIA_ERR_DECODE:
												statusStr.textContent = 'The video playback was aborted due to a corruption problem or because the video used features your browser did not support.';
												break;
											case e.target.error.MEDIA_ERR_SRC_NOT_SUPPORTED:
												statusStr.textContent = 'The video could not be loaded, either because the server or network failed or because the format is not supported.';
												break;
											default:
												statusStr.textContent = 'An unknown error occurred.';
												break;
											}
										}
									</script>
								</div>
							</c:when>
							<c:otherwise>
						Apple HLS streaming is not enabled for this application.
						</c:otherwise>
						</c:choose>
					</div>
					<div id="TabSmooth"
						style="position: absolute; width: 95%; height: 475px; background-color: #fff;">
						<c:choose>
							<c:when test="${config.msSmooth}">
								<div class="row" style="display: none;" id="smoothControls">
									<!--div class="col-md-2" style="margin-top: 5px">
										<span class="inline pull-right"><strong>Stream
												URL</strong></span>
									</div-->
									<div class="col-md-12">
										<div class="input-group" style="max-width:655px">
											<input type="text" id="smoothUrl" class="form-control"
												placeholder="" value="">
											<span class="input-group-btn">
												<button id="connectSmooth" type="button" class="btn btn-default pull-right"
													onclick="javascript:connectSmooth()">Start</button>
											</span>
										</div>
									</div>
									<!--div class="col-md-2">
										<button id="connectSmooth" type="button" class="btn btn-default pull-right"
											onclick="javascript:connectSmooth()" style="width: 100px">Start</button>
									</div-->
								</div>
								<div class="row" style="height:440px;">
									<div class="col-md-12">
										<div id="silverlightControlHost" style="height:440px;">
											<object data="data:application/x-silverlight-2,"
												type="application/x-silverlight-2" width="100%" height="100%"
												id="smoothVideoPlayer">
												<c:choose>
													<c:when test='${appTypeForPlayer=="live"}'>
														<param name="source"
															value="applications/test/${appTypeForPlayer}/ndvr/SilverlightPlayer/LiveDvrSmoothStreaming.xap" />
													</c:when>
													<c:otherwise>
														<param name="source"
															value="applications/test/${appTypeForPlayer}/SilverlightPlayer/SimpleSmoothStreaming.xap" />
													</c:otherwise>
												</c:choose>
												<param name="background" value="transparent">
												<param name="scale" value="showall">
												<param name="windowless" value="true">
												<param name="onerror" value="onSilverlightError" />
												<param name="background" value="white" />
												<param name="minRuntimeVersion" value="4.0.50401.0" />
												<param name="autoUpgrade" value="true" />
												<param name="InitParams"
													value="autoplay=false;deliverymethod=adaptivestreaming;" />
												<a
													href="http://go.microsoft.com/fwlink/?LinkID=149156&v=4.0.50401.0"
													style="text-decoration: none;"> <img
													src="http://go.microsoft.com/fwlink/?LinkID=161376"
													alt="Get Microsoft Silverlight" style="border-style: none" />
												</a>
											</object>
											<iframe id='_sl_historyFrame'
												style='visibility: hidden; height: 0; width: 0; border: 0px'></iframe>
										</div>
									</div>
								</div>
							</c:when>
							<c:otherwise>
								<center>
									<h2>Microsoft Smooth streaming is not enabled for this
										application.</h2>
								</center>
							</c:otherwise>
						</c:choose>
						<script>
						$(document).ready(function(){
							setTimeout(function() {
								if(/(iPhone|iPod|iPad)/i.test(navigator.userAgent)) {
									$("#TabSmooth").html('<center><h2>Silverlight is unavailable on iOS platforms</h2></center>');
								}
							},0);
						});
						</script>
					</div>
					<div id="TabDash"
						style="position:absolute;background-color: #fff; height: 475px;">
						<c:choose>
							<c:when test="${config.mpegDash}">
								<div id="dashnotsupported">
									<br /> <br /> <br />
									<h2>
										<b>Media Source Extensions not supported in this browser,
											DASH playback unavailable.</b>
									</h2>
								</div>
								<div id="dashsupported"
									style="background-color: #fff; display: none;">
									<div class="row">
										<!--div class="col-md-2" style="margin-top: 5px">
											<span class="inline"><strong>Stream
													URL</strong></span>
										</div-->
										<div class="col-md-12">
											<div class="input-group" style="max-width:655px">
												<input type="text" id="dashConnectStr"
													class="form-control" placeholder="" value="">
												<span class="input-group-btn">
													<button id="dashConnectObj" type="button"
														class="btn btn-default" onclick="JavaScript:dashConnect()">Start</button>
												</span>
											</div>
										</div>
										<!--div class="col-md-2">
											<button id="dashConnectObj" type="button"
												class="btn btn-default" onclick="JavaScript:dashConnect()"
												style="width: 82px">Start</button>
										</div-->
									</div>
									<div>
										<style>
											video {
												background-color: #000000;
											}
										</style>
										<video id="dashVideoObj" x-webkit-airplay="allow" controls
											alt="Example File" width="97%" autoplay
											"></video>
									</div>
									<div class="row">
										<div class="form-group indent1">
											<label class="control-label">Status:</label> <span
												class=" uneditable-input"
												id="dashStatusStr" >Disconnected</span>
										</div>
									</div>
									<p class="text-warning">
										<wmsform:getlocalestring page="testplayer" obj="dashPlayerWarning"/>
									</p>
								</div>
								<script>
									if (supports_media_source())
									{
										$("#dashnotsupported").hide();
										$("#dashsupported").show();
									} else
									{
										$("#dashsupported").hide();
									}
								</script>
							</c:when>
							<c:otherwise>
								<center>
									<h2>MPEG DASH streaming is not enabled for this application.</h2>
								</center>
							</c:otherwise>
						</c:choose>
					</div>
					<div id="TabMobile"
						style="background-color: #fff; background-color: #fff; height: 475px;">
						<div class="row">
							<div class="col-md-12">
								<h5>Mobile Streaming URLS</h5>
								<p>To test your application on a mobile device, enter the URLs
									below in your device's default browser.</p>
								<div class="well well-sm">
									<h5>iOS</h5>
									<p class="breakall"><span id="IOSHREF"></span></p>
								</div>
								<div class="well well-sm">
									<h5>Android/Other</h5>
									<p class="breakall"><span id="AndroidHREF"></span></p>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12 form-inline">
								<h5>Send These Links To Me</h5>
								<div class="input-group">
									<input class="form-control" name="emailAddress" id="emailAddress"
										type="text" placeholder="Email Address">
									<span class="input-group-btn">
										<button class="btn btn-default" name="emailLink" id="emailLink" onClick="javascript:sendEmail()">
											<i class="fa fa-envelope"></i>
											<fmt:message key='common.email' />
										</button>
									</span>
								</div>
								<div class="help-block">
									<strong>Note:</strong> An email application is required.
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<c:set var="emailSubject">
	<wmsform:getlocalestring page="testplayer" obj="email.subject"/>
</c:set>

<c:set var="emailMessage">
	<wmsform:getlocalestring page="testplayer" obj="email.message"/>
</c:set>

<script type="text/javascript">
	defStream = "myStream";
	defContent = "sample.mp4";
	var IOSUrl = "";
	var AndroidUrl = "";

	initUrls();

	function initUrls()
	{
		$("#server").val(currentVhostConnectionIPAddress+":"+currentVhostConnectionPort);
		if ("${appTypeForPlayer}" == "live")
		{
			$("#stream").val("${streamName}");
			$("#smoothControls").show();
		} else
		{
			$("#stream").val("mp4:sample.mp4");
		}
		if("${instanceName}"=="")
		{
			$("#applicationInstance").val("${appName}");
		}
		else
		{
			$("#applicationInstance").val("${appName}/${instanceName}");
			setApplicationInstance();
		}
		$("#smoothUrl").val(getSmoothStream());
		IOSURL=getHLSStream();
		$("#IOSHREF").html(getMobileHLSStream());
		AndroidURL=getAndroidStream();
		$("#AndroidHREF").html(getMobileAndroidStream());
		$("#html5connectStr").val(getHLSStream());
	}


	function updateStream()
	{
		setTimeout(function()
		{
			setApplicationInstance();
			updateServer();

			if (document.getElementById("${appTypeForPlayer}HTTPPlayer") != null && document.getElementById("${appTypeForPlayer}HTTPPlayer").setStream !=null)
			{
				document.getElementById("${appTypeForPlayer}HTTPPlayer").setStream(getVODHTTPStream());
			}
			if (document.getElementById("${appTypeForPlayer}RTMPPlayer") != null && document.getElementById("${appTypeForPlayer}RTMPPlayer").setStream!=null)
			{
				document.getElementById("${appTypeForPlayer}RTMPPlayer").setStream($("#stream").val());
			}
			if (document.getElementById("smoothVideoPlayer") != null && document.getElementById("smoothVideoPlayer").Content != null)
			{
				document.getElementById("smoothVideoPlayer").Content.wowza.setStream(getSmoothStream());
			}
			if (document.getElementById("dashVideoObj") != null)
			{
				$("#dashConnectStr").val(getDASHStream());
			}
			if (document.getElementById("videoObj") != null)
			{
				$("#connectStr").val(getHLSStream());
			}
			$("#hdsUrl").val(getLiveHTTPStream());
			$("#smoothUrl").val(getSmoothStream());
			IOSURL=getHLSStream();
			$("#IOSHREF").html(getMobileHLSStream());
			AndroidURL=getAndroidStream();
			$("#AndroidHREF").html(getMobileAndroidStream());
			$("#html5connectStr").val(getHLSStream());
		}, 20);
	}

	function updateApplicationInstance()
	{
		setTimeout(function()
		{
			//setApplicationInstance();
			updateServer();
		},20);
	}

	function setApplicationInstance()
	{
		var inst="";
		var appName = $("#applicationInstance").val();
		fSlash = appName.indexOf("/");
		if(fSlash>0)
		{
			inst = appName.substr(fSlash+1);
			appName = appName.substr(0,fSlash);
		}
		if(inst=="_definst_")
		{
			inst="";
		}
		if(inst=="")
		{
			if($("#stream").val().indexOf("/") >0)
			{
				inst="_definst_";
			}
		}
		if(inst=="")
		{
			$("#applicationInstance").val(appName);
		}
		else
		{
			$("#applicationInstance").val(appName + "/"+inst);
		}
	}

	function updateServer()
	{
		setTimeout(function()
		{
			rtmpPrefix="rtmp";
			if(currentVhostConnectionSSLEnable)
			{
				rtmpPrefix="rtmps";
			}
			if (document.getElementById("${appTypeForPlayer}HTTPPlayer") != null && document.getElementById("${appTypeForPlayer}HTTPPlayer").setStream != null)
			{
				document.getElementById("${appTypeForPlayer}HTTPPlayer").setStream(getHDSStream());
			}
			if (document.getElementById("${appTypeForPlayer}RTMPPlayer") != null && document.getElementById("${appTypeForPlayer}RTMPPlayer").setServer != null)
			{
				document.getElementById("${appTypeForPlayer}RTMPPlayer").setServer(
						rtmpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() );
			}
			if (document.getElementById("smoothVideoPlayer") != null && document.getElementById("smoothVideoPlayer").Content != null)
			{
				document.getElementById("smoothVideoPlayer").Content.wowza.setStream(getSmoothStream());
			}
			if (document.getElementById("dashVideoObj") != null)
			{
				$("#dashConnectStr").val(getDASHStream());
			}
			if (document.getElementById("videoObj") != null)
			{
				$("#connectStr").val(getHLSStream());
			}
			$("#hdsUrl").val(getLiveHTTPStream());
			$("#smoothUrl").val(getSmoothStream());
			IOSURL=getHLSStream();
			$("#IOSHREF").html(getMobileHLSStream());
			AndroidURL=getAndroidStream();
			$("#AndroidHREF").html(getMobileAndroidStream());
			$("#html5connectStr").val(getHLSStream());
		}, 10);
	}

	function sendEmail()
	{
		var emailBody = "${emailMessage}iOS: " + IOSURL
			+ "\r\nAndroid: " + AndroidURL + "\r\n\r\n";
		location.href = "mailto:" + $("#emailAddress").val() + "?subject=" + encodeURIComponent("${emailSubject}") + "&body="
			+ encodeURIComponent(emailBody);
	}
	function getHDSStream()
	{
		if ("${appTypeForPlayer}" == "live")
		{
			return getLiveHTTPStream();
		} else
		{
			return getVODHTTPStream();
		}
	}
	/* some of these functions are called from the players themselves */
	function getVODHTTPStream()
	{
		httpPrefix="http";
		if(currentVhostConnectionSSLEnable)
		{
			httpPrefix="https";
		}
		return httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/manifest.f4m";
	}
	function getLiveHTTPStream()
	{
		httpPrefix="http";
		if(currentVhostConnectionSSLEnable)
		{
			httpPrefix="https";
		}
		return httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/manifest.f4m" + ((ndvrEnabled) ? "?DVR" : "");
	}
	function getDASHStream()
	{
		httpPrefix="http";
		if(currentVhostConnectionSSLEnable)
		{
			httpPrefix="https";
		}
		return httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/manifest.mpd" + ((ndvrEnabled)?"?DVR":"");
	}

	function getVODRTMPServer()
	{
		rtmpPrefix="rtmp";
		if(currentVhostConnectionSSLEnable)
		{
			rtmpPrefix="rtmps";
		}
		return rtmpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val();
	}
	function getVODRTMPStream()
	{
		return $("#stream").val();
	}
	function getSmoothStream()
	{
		httpPrefix="http";
		if(currentVhostConnectionSSLEnable)
		{
			httpPrefix="https";
		}
		return httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/Manifest" + ((ndvrEnabled) ? "?DVR" : "");
	}
	function getVODSmoothStream()
	{
		return getSmoothStream();
	}
	function getLiveSmoothStream()
	{
		return getSmoothStream();
	}

	function getLiveRTMPServer()
	{
		rtmpPrefix="rtmp";
		if(currentVhostConnectionSSLEnable)
		{
			rtmpPrefix="rtmps";
		}
		return rtmpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val();
	}
	function getLiveRTMPStream()
	{
		return $("#stream").val();
	}

	function getHLSStream()
	{
		httpPrefix="http";
		if(currentVhostConnectionSSLEnable)
		{
			httpPrefix="https";
		}
		return httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/playlist.m3u8" + ((ndvrEnabled) ? "?DVR" : "");
	}
	function getMobileHLSStream()
	{
		httpPrefix="http";
		if(currentVhostConnectionSSLEnable)
		{
			httpPrefix="https";
		}
		return "<a href=" + httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/playlist.m3u8" + ((ndvrEnabled) ? "?DVR" : "" ) + ">"
			+ httpPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val() + "/playlist.m3u8" + ((ndvrEnabled) ? "?DVR" : "") + "</a>";
	}
	function getAndroidStream()
	{
		rtspPrefix="rtsp";
		if(currentVhostConnectionSSLEnable)
		{
			rtspPrefix="rtsps";
		}
		return rtspPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val().replace("mp4:", "");
	}
	function getMobileAndroidStream()
	{
		rtspPrefix="rtsp";
		if(currentVhostConnectionSSLEnable)
		{
			rtspPrefix="rtsps";
		}
		return "<a href=" + rtspPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val().replace("mp4:", "") + ">"
			+ rtspPrefix + "://" + $("#server").val() + "/" + $("#applicationInstance").val() + "/"
			+ $("#stream").val().replace("mp4:", "") + "</a>";
	}
	function getHostNoPort()
	{
		var host = document.location.hostname;
		if ($("#server").val().length > 0)
		{
			host = $("#server").val();
		}
		return host;
	}

	function showTab(tab)
	{
		var tabs = [
			'HDS', 'RTMP', 'HLS', 'Smooth', 'Mobile', 'Dash'
		];
		stopAllPlayers();
		for ( var tabIdx = 0; tabIdx < tabs.length; tabIdx++)
		{
			var div = '#Tab' + tabs[tabIdx];
			var tabId = '#test' + tabs[tabIdx];
			if (tabs[tabIdx] == tab)
			{
				$(div).css('zIndex', 1000);
				$(div).css('visibility', 'visible');
				$(tabId).addClass('active');
				continue;
			}
			$(div).css('visibility', 'hidden');
			$(div).css('zIndex', -1);
			$(tabId).removeClass('active');
		}
	}

	function stopAllPlayers()
	{
		if (disconnectHTML5)
			disconnectHTML5(); //stop html5
		if (ndvrEnabled && $("#flashContent").length > 0)
		{
			ndvrConnect(false);
		}
		if (document.getElementById("${appTypeForPlayer}RTMPPlayer") != null
			&& document.getElementById("${appTypeForPlayer}RTMPPlayer").playerStop)
		{
			document.getElementById("${appTypeForPlayer}RTMPPlayer").playerStop();
		}
		if (document.getElementById("${appTypeForPlayer}HTTPPlayer") != null
			&& document.getElementById("${appTypeForPlayer}HTTPPlayer").playerStop)
		{
			document.getElementById("${appTypeForPlayer}HTTPPlayer").playerStop();
		}
		try
		{
			// IE10 doesn't seem to load the silverlight plugin until it's viewed the first
			// time, so while .Content will exist it will be an empty object and will
			// throw an exception when we do anything to look for the wowza bindings
			if (document.getElementById("smoothVideoPlayer") != null
				&& document.getElementById("smoothVideoPlayer").Content != null
				&& document.getElementById("smoothVideoPlayer").Content.wowza != null)
			{
				document.getElementById("smoothVideoPlayer").Content.wowza.playerStop();
			}
		} catch (e)
		{
		}
		if (document.getElementById("dashVideoObj") != null)
		{
			dashStop();
		}
	}
	function testApplicationClose()
	{
		stopAllPlayers();
		$('#testApplicationModal').modal('hide');
	}

	if (ndvrEnabled)
	{
		$("#connectStr").val(getLiveHTTPStream());
		$("#ndvrControls").show();
		$("#hdsUrl").val(getLiveHTTPStream());
	}

	function ndvrConnect(autoPlay)
	{
		var playerSource = "applications/test/${appTypeForPlayer}/FlashHTTPPlayer/${appTypeForPlayer}.swf";
		var params =
		{
			src : escape($("#hdsUrl").val()),
			allowscriptaccess : "sameDomain",
			autoPlay : autoPlay ? autoPlay : false,
			verbose : false,
			allowFullScreen : true,
			flashVars : "editStreamBar=true,src=" + escape($("#hdsUrl").val()) + ",autoPlay=true",
			controlBarAutoHide : "false",
			controlBarPosition : "bottom",
			scale : "showall",
			wmode : "opaque"
		};
		$("#hdsWrapper").empty();

		$("<div id='flashContent'></div>").appendTo($("#hdsWrapper"));
		$("#flashContent").html("<div id='noflashContent'><h2>To view this page ensure that Adobe Flash Player version 11.1.0 or greater is installed.</h2></div>");
		if (ndvrEnabled)
		{
			playerSource = "applications/test/${appTypeForPlayer}/ndvr/FlashHTTPPlayer/${appTypeForPlayer}.swf";
			swfobject.embedSWF(playerSource, "flashContent", "655", "450", swfVersionStr, xiSwfUrlStr, params,
			{
				allowFullScreen : "true",
				wmode : "opaque"
			},
			{
				name : "flashContent"
			});
		} else
		{
			swfobject.embedSWF(playerSource, "flashContent", "655", "450", swfVersionStr, xiSwfUrlStr, flashVars,
				params, attributes);
			swfobject.createCSS("#flashContent", "display:block;text-align:left;");
		}
		/*
		var params = {
			src: "http://localhost:1935/dvr/myStream/manifest.f4m?DVR",
			autoPlay: true,
			verbose: true,
			controlBarAutoHide: "false",
			controlBarPosition: "bottom",
			flashvars:{showStreamBar:false}
		};
		$("#hdsWrapper").empty();
		$("<div id='flashContent'></div>").appendTo($("#hdsWrapper"));
		playerSource = "applications/test/${appTypeForPlayer}/ndvr/FlashHTTPPlayer/${appTypeForPlayer}.swf";
		params.src = escape($("#connectStr").val());
		params.verbose=true;
		swfobject.embedSWF(playerSource, "flashContent", 640, 480, "10.3.0", "expressInstall.swf", params, {allowFullScreen: "true",wmode: "direct"}, {name: "flashContent"}); */
	}

	function connectSmooth()
	{
		if ($("#smoothVideoPlayer") == null)
		{
			return;
		}
		var ctl = $("#smoothVideoPlayer")[0].Content.wowza;
		ctl.setStream($("#smoothUrl").val());
		ctl.playerStart();
	}

	setTimeout(function()
	{
		// onkeydown="javascript:generateUrls()"
		$("#server").on('keydown', updateServer);
		$("#applicationInstance").on('keydown', updateApplicationInstance);
		$("#stream").on('keydown', updateStream);
		if ($('#mobileSelector').is(':hidden'))
		{
			showTab('RTMP');
		}
		else
		{ 
			//show Mobile Tab on mobile 
			showTab('Mobile');
		}
		if (AC_FL_RunContent == 0)
		{
			alert("This page requires AC_RunActiveContent.js.");
		} else
		{
			AC_FL_RunContent('codebase',
				'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0', 'width', '636',
				'height', '440', 'src', 'applications/test/${appTypeForPlayer}/FlashRTMPPlayer/${appTypeForPlayer}',
				'quality', 'high', 'pluginspage', 'http://www.macromedia.com/go/getflashplayer',
				'play', 'true', 'loop', 'true', 'scale', 'showall', 'wmode', 'opaque', 'devicefont', 'false',
				'id', '${appTypeForPlayer}RTMPPlayer', 'bgcolor', '#000000', 'name', '${appTypeForPlayer}RTMPPlayer',
				'menu', 'true', 'allowFullScreen', 'true', 'allowScriptAccess', 'sameDomain', 'movie',
				'applications/test/${appTypeForPlayer}/FlashRTMPPlayer/${appTypeForPlayer}', "id", '${appTypeForPlayer}RTMPPlayer'); //end AC code
		}

		$("#smoothConnectStr").val(getSmoothStream());
		$("#dashConnectStr").val(getDASHStream());

		$("#testApplicationModal").modal({backdrop: 'static',
			  keyboard: false});
		$.getScript("applications/test/swfobject.js", function()
		{
			ndvrConnect(false);
		});

	}, 500);
</script>
<script src="applications/test/dash/js/dash-shaka.js"></script>
<script>
var video;
var player;
var source; 
var estimator;

	function dashConnect()
	{
	if (dashConnectObj.textContent == "Stop")
		{
		dashStop();
		} else
		{
		dashConnectObj.textContent = "Stop";
		dashStatusStr.textContent = "Playing";
		if ( video == null )
			{video = document.querySelector("#dashVideoObj");}
		if ( player == null )
			{player = new shaka.player.Player(video);}
		// Attach the player to the window so that it can be easily debugged.
		window.player = player;
		// Listen for errors from the Player.
		player.addEventListener('error', dashFailed );
		if ( estimator != null )
			{estimator=null;}
		estimator = new shaka.util.EWMABandwidthEstimator();
		if ( source != null )
			{source = null;}
		source = new shaka.player.DashVideoSource(dashConnectStr.value, null, estimator);
		// Load the source into the Player.
		player.load(source);
		}
	}
	 
	function dashFailed(e)
	{
	var done = false;
	if ( e.detail == 'Error: Network failure.' )
		{
		statusStr.textContent = 'Network Connection Failed.';
		done = true;
		}
	if ( e.detail.status!=200 && done == false )
		{
		switch ( e.detail.status )
			{
			case 404:
				statusStr.textContent = e.detail.url+' not found.';
				break;
			default:
				statusStr.textContent = 'Error '+e.detail.status+' for '+e.detail.url;
				break;
			}
		}
	}
	
	function showMobileTestPlayer(player)
	{
		showTab(player);
	}
	
	function dashStop()
	{
		if(player!=null)
		{
		console.log('Player is '+player);
		player.unload();
		}
	dashConnectObj.textContent = "Start";
	dashStatusStr.textContent = "Disconnected";
	}

</script>