<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}
</c:set>

<c:set var="streamTargetsEnabled" value="${requestScope.formData['streamTargetsEnabled']}"/>
<c:set var="streamTargetsList" value="${requestScope.formData['targetList']}"/>
<c:set var="banner" value="${param.banner}"/>
<c:set var="serverId1" value="${requestScope.formData['serverId1']}"/>
<c:set var="serverId2" value="${requestScope.formData['serverId2']}"/>
<c:set var="serverTS" value="${requestScope.formData['serverTS']}"/>
<c:set var="endpointId1" value="${requestScope.formData['endpointId1']}"/>
<c:set var="endpointId2" value="${requestScope.formData['endpointId2']}"/>

<script src="js/wowza-RestProxy.js"></script>
<script type="text/javascript" src="js/forge.min.js"></script>
<script>
var refreshT;
var skipRefresh = 0;
startRefresh();

$(document).ready(function() {

	$(document).on("preContentNavigation", function(e) {
		stopRefresh();
		$(document).off("preContentNavigation", arguments.callee);
	});

	var autoRefresh = readCookie("enableStreamTargetRefresh","true");
	$('#enableStreamTargetRefresh').attr("checked",autoRefresh=="true");
	if ( autoRefresh == "false")
	{
	  stopRefresh();
	}

	WOWZA.RestProxy.push("${serverId1}");
	WOWZA.RestProxy.push("${serverId2}");
});

function refreshPage()
{
	var autoRefresh = readCookie("enableStreamTargetRefresh","true");
	if ( autoRefresh == "true")
	{
		var status = new String("${streamTargetsEnabled}");
		var timer = new Number("${param.timeScape}");
		var count = new Number("${fn:length(streamTargetsList)}");
		var banner = new String("${param.banner}");
		var urlBase = "view.htm";
		if ( banner == 'enable' ) { urlBase = "enableStreamTargetsBtn.htm"; }
		if ( banner == 'disable' ){ urlBase = "disableStreamTargetsBtn.htm"; }
		if ( timer == 5000 ) { timer = 10000; }
		if ( timer <5000 ) { timer = 5000 };

		if ( status.valueOf()=="true" && count > 0 && count < 100 )
		{
			loadAjaxMainContent('applications/${appType}/streamtargets/'+urlBase,'vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&timeScape='+timer+'&banner='+banner);
		}
		else
		{
			stopRefresh();
		}
	}
}

function startRefresh()
{
	var timer = new Number("${param.timeScape}");
	if ( timer < 5000 )
	{
		timer = 5000;
	}

	if ( skipRefresh == 1 )
	{
		timer = 5000;
		skipRefresh = 0;
	}
	if (refreshT != null)
	{
		stopRefresh();
	}
	refreshT = setTimeout("refreshPage();", timer);
}

function stopRefresh()
{
	clearInterval(refreshT);
	refreshT = null;
}

function restartRefresh()
{
	var autoRefresh = readCookie("enableStreamTargetRefresh","true");
	if ( autoRefresh == "true")
	{
		startRefresh();
	}
}

</script>


<c:set var="pagename">
	<wmsform:getlocalestring page="appconfig.streamTargets" obj="head"/>
</c:set>

<sec:authorize access="hasAnyRole('admin')">
	<c:set var="auth" value="yes"/>
</sec:authorize>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-5">
			<happ>${wmsutil:escapeHtml(appName)} ${pagename}</happ><br>
			<small class="text-muted"><wmsform:objvalue page="appConfig" obj="uiAppType"/></small>
		</div>
		<wmsdialog:applicationrestart page="streamtargets" />

		<!--
		<wmsform:applicationbuttons page="streamtargets"/>
		-->
		<!-- editstreamtarget -->
		<wmsdialog:copystreamtarget page="streamtargets"/>
		<wmsdialog:enablestreamtarget page="streamtargets"/>
		<wmsdialog:disablestreamtarget page="streamtargets"/>
		<wmsdialog:restartstreamtarget page="streamtargets"/>
		<wmsdialog:deletestreamtarget page="streamtargets"/>
		<wmsdialog:disablestreamtargeting page="streamtargets"/>
		<wmsdialog:enablestreamtargeting page="streamtargets"/>
	</div>
	<div class="row col-md-12">
		<p id="pageText"></p>
	</div>
	<div class="notabs">
		<hr/>
	</div>
	<div class="row">
		<div class="col-md-8 main-content">
			<wmsform:rightrailhideshow/>
			<c:choose>
				<c:when test="${not streamTargetsEnabled}">
					<script>
						appStreamTargetsID="appName=" + getGoodJqueryID("${appName}") + ":streamtargets:enabled";
				    	$('[id="'+appStreamTargetsID+'"]').hide();
				    </script>
					<p><wmsform:getlocalestring page="appconfig.streamTargets" obj="enabledMessageText"/></p>
					<c:choose>
						<c:when test="${auth=='yes'}">
							<p><label class="control-label"><wmsform:getlocalestring page="common" obj="disabledMessage"/></label></p>
							<wmsform:buttonprimary page= "streamTargets" obj="addStreamTarget" onClick="javascript:loadAjaxMainContent('applications/${appType}/streamtarget/wizard.htm', 'vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}');" icon="fa fa-plus"/>
			            	<wmsform:button page="appconfig.streamTargets" obj="enableStreamTargetsBtn" onClick="javascript:enableStreamTargetingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')" cssClass="btn btn-default"/>
						</c:when>
						<c:otherwise>
							<label class="control-label"><wmsform:getlocalestring page="common" obj="disabledMessage"/></label>
						</c:otherwise>
					</c:choose>
				</c:when>
				<c:otherwise>
					<script>
				    	appStreamTargetsID="appName=" + getGoodJqueryID("${appName}") + ":streamtargets:enabled";
				    	$('[id="'+appStreamTargetsID+'"]').show();
				    </script>
					<p><wmsform:getlocalestring page="appconfig.streamTargets" obj="disabledMessageText"/></p>
					<c:choose>
						<c:when test="${auth=='yes'}">
							<p><label class="control-label"><wmsform:getlocalestring page="common" obj="enabledMessage"/></label></p>
							<wmsform:buttonprimary page= "streamTargets" obj="addStreamTarget" onClick="javascript:stopRefresh();loadAjaxMainContent('applications/${appType}/streamtarget/wizard.htm', 'vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}');" icon="fa fa-plus"/>
			            	<wmsform:button page="appconfig.streamTargets" obj="disableStreamTargetsBtn" onClick="javascript:stopRefresh();disableStreamTargetingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')" cssClass="btn btn-default"/>
						</c:when>
						<c:otherwise>
							<label class="control-label"><wmsform:getlocalestring page="common" obj="enabledMessage"/></label>
						</c:otherwise>
					</c:choose>
					<c:choose>
						<c:when test="${banner=='disable'}">
							<wmsform:button page="common" cssClass="btn btn-default" onClick="javascript:stopRefresh();loadAjaxMainContent('applications/${appType}/streamtargets/disableStreamTargetsBtn.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&timeScape=5000&banner=disable')" obj="refresh" icon="fa fa-repeat"/>
						</c:when>
						<c:when test="${banner=='enable'}">
							<wmsform:button page="common" cssClass="btn btn-default" onClick="javascript:stopRefresh();loadAjaxMainContent('applications/${appType}/streamtargets/enableStreamTargetsBtn.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&timeScape=5000&banner=enable')" obj="refresh" icon="fa fa-repeat"/>
						</c:when>
						<c:otherwise>
							<wmsform:button page="common" cssClass="btn btn-default" onClick="javascript:stopRefresh();loadAjaxMainContent('applications/${appType}/streamtargets/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&timeScape=5000')" obj="refresh" icon="fa fa-repeat"/>
						</c:otherwise>
					</c:choose>
					<input type="checkbox" id="enableStreamTargetRefresh" name="enableStreamTargetRefresh" onclick="changeRefresh();" checked /><wmsform:getlocalestring page="appconfig.streamTargets" obj="enableStreamTargetRefresh" /></p>
			</c:otherwise>
			</c:choose>
			<br/>
			<br/>
			<table id="streamTable" class="table table-striped table-fixed">
				<tbody>
					<tr>
						<th><wmsform:getlocalestring page="appconfig.streamTargets" obj="streamTargetColumn"/></th>
						<th><wmsform:getlocalestring page="appconfig.streamTargets" obj="statusColumn"/></th>
						<th><wmsform:getlocalestring page="appconfig.streamTargets" obj="actionsColumn"/></th>
					</tr>
					<c:forEach var="streamTarget" items="${requestScope.formData['targetList']}">
						<c:set var="streamTargetName" value="${streamTarget['streamTargetName']}"/>
						<tr class="indent1">
							<td>
								<div class="target-logo-div" title="${streamTarget['destinationName']}">
								<c:choose>
									<c:when test="${streamTarget['destinationName']=='facebook'}">
										<img src="img/icon-facebook.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='akamai'}">
										<img src="img/icon-akamai.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='alibaba'}">
										<img src="img/icon-alibaba.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='limelight'}">
										<img src="img/icon-limelight.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='tata'}">
										<img src="img/icon-tata.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='mirrorimage'}">
										<img src="img/icon-mirrorimage.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='youtube'}">
										<img src="img/icon-youtube.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='rtp'}">
										<img src="img/icon-rtp.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='mpegts'}">
										<img src="img/icon-mpegts.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='wowzastreamingengine'}">
										<img src="img/icon-wse.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='wowzastreamingcloud'}">
										<img src="img/icon-wsc.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='wowzacdn'}">
										<img src="img/icon-wsc-cdn.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='shoutcast'}">
										<img src="img/icon-shoutcast1.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='icecast2'}">
										<img src="img/icon-icecast2.png">
									</c:when>
									<c:when test="${streamTarget['destinationName']=='srt'}">
										<img src="img/icon-srt.png">
									</c:when>


									<c:otherwise>
										<img src="img/icon-rtmp.png">
									</c:otherwise>
								</c:choose>
								</div>
								<div class="target-info-div">
									<c:set var="protocolLabel">
										<c:if test="${streamTarget['destinationName']!='wowzastreamingcloud' && streamTarget['destinationName']!='wowzacdn'}">
											(${streamTarget['protocol']})
										</c:if>
									</c:set>
									<a onclick="javascript:loadAjaxMainContent('applications/${appType}/streamtarget/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamTargetName=${wmsutil:urlEncode(streamTarget['streamTargetName'])}')">${wmsutil:escapeHtml(streamTarget['streamTargetName'])} ${protocolLabel}</a>
								</div>
							</td>
							<td class="breakword td-vert-middle">
								<c:choose>
									<c:when test="${not streamTargetsEnabled}">
										<div style='color:#a1a1a1'>
											<c:choose>
												<c:when test="${streamTarget['status']=='Disabled'}">
													<span><I class="fa fa-circle"></i></span>
												</c:when>
												<c:when test="${streamTarget['status']=='Active'}">
													<span><I class="text-success fa fa-circle"></i></span>
												</c:when>
												<c:when test="${streamTarget['status']=='Error'}">
													<span><I class="fa fa-exclamation-circle"></i></span>
												</c:when>
												<c:otherwise>
													<span><I class="fa fa-circle"></i></span>
												</c:otherwise>
											</c:choose>
											${streamTarget['status']}
										</div>
									</c:when>
									<c:otherwise>
										<c:choose>
											<c:when test="${streamTarget['status']=='Disabled'}">
												<span><I style='color:#a1a1a1' class="fa fa-circle"></i></span>
											</c:when>
											<c:when test="${streamTarget['status']=='Active'}">
												<span><I style="color:#39b54a" class="text-success fa fa-circle"></i></span>
											</c:when>
											<c:when test="${streamTarget['status']=='Error'}">
												<span><I class="text-danger fa fa-exclamation-circle"></i></span>
											</c:when>
											<c:otherwise>
												<span><I style='color:#fbab00' class="fa fa-circle"></i></span>
											</c:otherwise>
										</c:choose>
										${streamTarget['status']}
									</c:otherwise>
								</c:choose>
							</td>
							<td class="td-vert-middle">
								<sec:authorize access="hasAnyRole('admin')">
									<a onclick="javascript:showEditStreamTarget('${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')"><i class="fa fa-pencil fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="edit"/>"></i></a>&nbsp;
									<a onclick="javascript:stopRefresh();copyStreamTargetShow('${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')" class="fa fa-files-o fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="copy"/>"></a>&nbsp;
									<c:choose>
										<c:when test="${streamTarget['status']=='Disabled'}">
											<a onclick="javascript:stopRefresh();enableStreamTargetShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')"><i class="fa fa-power-off fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="enable"/>"></i></a>&nbsp;
										</c:when>
										<c:otherwise>
											<a onclick="javascript:stopRefresh();disableStreamTargetShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')" class="fa fa-power-off fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="disable"/>"></a>&nbsp;
										</c:otherwise>
									</c:choose>
									<c:if test="${streamTarget['status']=='Active' or streamTarget['status']=='Error'}">
										<a onclick="javascript:stopRefresh();javascript:restartStreamTargetShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')" class="fa fa-refresh fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="restart"/>"></a>&nbsp;
									</c:if>
									<c:choose>
										<c:when test="${streamTarget['destinationName']=='wowzacdn'}">
											<c:set var="targetId" value="${wmsutil:escapeHtml(streamTarget['wowzaCdnCloudTargetId'])}"/>
											<c:set var="apiKey" value="${wmsutil:escapeHtml(streamTarget['wowzaCdnCloudAccountApiKey'])}"/>
											<c:set var="accessKey" value="${wmsutil:escapeHtml(streamTarget['wowzaCdnCloudAccountAccessKey'])}"/>
											<a id="deleteStreamTargetIcon" onclick="javascript:askToDeleteWowzaCdnTarget('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}', '${targetId}', '${apiKey}', '${accessKey}')" class="fa fa-trash-o fa-2x icon-standalone-link"  title="" data-placement="right" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="delete"/>"></a>&nbsp;
										</c:when>
										<c:otherwise>
											<a id="deleteStreamTargetIcon" onclick="javascript:askToDeleteTarget('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(streamTarget['streamTargetName'])}')" class="fa fa-trash-o fa-2x icon-standalone-link"  title="" data-placement="right" data-toggle="tooltip" data-delay="250" data-original-title="<wmsform:getlocalestring page="appconfig.streamTargets.action" obj="delete"/>"></a>&nbsp;
										</c:otherwise>
									</c:choose>
								</sec:authorize>
							</td>
						</tr>
					</c:forEach>
				</tbody>
			</table>
			<div class="indent1">
				<c:if test="${fn:length(requestScope.formData['targetList'])<=0}">
					<c:choose>
						<c:when test="${auth=='yes'}">
							<wmsform:getlocalestring page="appconfig.streamTargets" obj="noTargetsMsg"/>  <wmsform:getlocalestring page="appconfig.streamTargets" obj="addTargetMsg"/>
						</c:when>
						<c:otherwise>
							<wmsform:getlocalestring page="appconfig.streamTargets" obj="noTargetsMsg"/>
						</c:otherwise>
					</c:choose>
				</c:if>
			</div>
		</div>

		<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
			<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</div>

</div>

<script>

function changeRefresh()
{
	if(document.getElementById('enableStreamTargetRefresh').checked)
	{
		createCookie("enableStreamTargetRefresh","true",730);
		skipRefresh = 1;
		startRefresh();
	}
	else
	{
		createCookie("enableStreamTargetRefresh","false",730);
		stopRefresh();
	}
}

function showEditStreamTarget(name)
{
	lastTab='Basic';
	name=encodeURIComponent(name);
	loadAjaxMainContent("applications/${appType}/streamtarget/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamTargetName="+name);
}

function okToDelete(targetName)
{
	return true;
}

function askToDeleteTarget(appName, targetName)
{
	stopRefresh();
	deleteStreamTargetShow(appName, targetName, okToDelete);
}

var WowzaCdnTargetTargetId = null;
var WowzaCdnTargetApiKey = null;
var WowzaCdnTargetAccessKey = null;

function askToDeleteWowzaCdnTarget(appName, targetName, targetId, apiKey, accessKey)
{
	stopRefresh();
	WowzaCdnTargetTargetId = targetId;
	WowzaCdnTargetApiKey = apiKey;
	WowzaCdnTargetAccessKey = accessKey;
	deleteStreamTargetShow(appName, targetName, okToDeleteWowzaCdn);
}

function okToDeleteWowzaCdn(targetName, responseCb)
{
	// try to delete the target on cloud
	return deleteWowzaCDNtarget(WowzaCdnTargetTargetId, WowzaCdnTargetApiKey, WowzaCdnTargetAccessKey, responseCb);
}

function deleteWowzaCDNtarget (targetId, apiKey, accessKey, responseCb)
{
	//var split;
	//split = apiKey.split(":::");
	//apiKey = WOWZA.RestProxy.show(split[2], WOWZA.RestProxy.pull(), split[1]);
	//split = accessKey.split(":::");
	//accessKey = WOWZA.RestProxy.show(split[2], WOWZA.RestProxy.pull(), split[1]);

	var request={};
	request.cmd = "delete-target";
	request.targetId = targetId;
	request.api_key = apiKey;
	request.access_key = accessKey;
	var dataPost =  JSON.stringify(request);
	WOWZA.RestProxy.push("${endpointId1}");
	WOWZA.RestProxy.push("${endpointId2}");

	WOWZA.RestProxy.request("$(appType)", "${wmsutil:urlEncode(vhost)}", "${wmsutil:urlEncode(appName)}", dataPost, function(state, responseData) {
		// if successful call to streamTargetsController
		if (state)
		{
			var dataJSON = JSON.parse(responseData);

			var responseJSON = null;
			var response = null;
			// if 204, success and it got deleted
			// if 404, can't be found so assume it was deleted and purged from db
			// if 410, target is still in database and listed as "deleted", so user must have manually deleted on cloud
			if ((dataJSON.success && (dataJSON.code =="204")) || !dataJSON.success && (dataJSON.code =="404" || dataJSON.code =="410"))
			{
				//console.log("deleteWowzaCDNtarget: target with id " + targetId + "deleted");
				responseCb(true);
			}
			else
			{
				console.log("deleteWowzaCDNtarget: delete steam target request sent to cloud but an error was returned.");
				console.log(dataJSON.code + ", " + dataJSON.message);
				responseCb(false);
			}
		}
		else
		{
			console.log("deleteWowzaCDNtarget: problem in controller call" );
			responseCb(false);
		}
	});
	return null;
}

</script>
<script>
$(function () {
    $("[data-toggle='tooltip']").tooltip();
});
</script>
