<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}
</c:set>

<c:set var="pagename">
	<wmsform:getlocalestring page="appconfig.streamTargets" obj="head"/>
</c:set>

<c:set var="configureTarget"><wmsform:getlocalestring page="appconfig.streamTargets" obj="wizard.configureTarget"/></c:set>
<c:set var="pathNameWSE"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.wse" obj="nameSmall"/></c:set>
<c:set var="pathNameWSC"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.wsc" obj="nameSmall"/></c:set>
<c:set var="pathNameWowzaCDN"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.wowzacdn" obj="nameSmall"/></c:set>
<c:set var="pathNameFacebook"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.facebook" obj="nameSmall"/></c:set>
<c:set var="pathNameAkamai"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.akamai" obj="name"/></c:set>
<c:set var="pathNameAlibaba"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.alibaba" obj="name"/></c:set>
<c:set var="pathNameTata"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.tata" obj="nameSmall"/></c:set>
<c:set var="pathNameLimelight"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.limelight" obj="name"/></c:set>
<c:set var="pathNameMirrorImage"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.mirrorImage" obj="nameSmall"/></c:set>
<c:set var="pathNameIcecast2"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.icecast2" obj="nameSmall"/></c:set>
<c:set var="pathNameShoutcast"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.shoutcast" obj="nameSmall"/></c:set>
<c:set var="pathNameYouTube"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.youTube" obj="name"/></c:set>
<c:set var="pathNameRTP"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.rtp" obj="nameSmall"/></c:set>
<c:set var="pathNameMPEGTS"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.mpegts" obj="nameSmall"/></c:set>
<c:set var="pathNameRTMP"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.rtmp" obj="nameSmall"/></c:set>
<c:set var="pathNameSRT"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destinations.srt" obj="nameSmall"/></c:set>


<c:set var="destStreamNameRTMPLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="destStreamNameRTMP"/></c:set>
<c:set var="destApplicationLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="destApplication"/></c:set>
<c:set var="destAppInstanceLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="destAppInstance"/></c:set>
<c:set var="usernameLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="username"/></c:set>
<c:set var="passwordLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="password"/></c:set>

<c:set var="pageErrors"><wmsform:getlocalestring page="common" obj="formError"/></c:set>
<c:set var="facebookFailLogin"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookFailLogin"/></c:set>
<c:set var="facebookFailAPI"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookFailAPI"/></c:set>
<c:set var="facebookFailPermissions"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookFailPermissions"/></c:set>
<c:set var="invalidConnectionCode"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.connectionCode" obj="invalid"/></c:set>

<c:set var="serverId1" value="${requestScope.formData['serverId1']}"/>
<c:set var="serverId2" value="${requestScope.formData['serverId2']}"/>
<c:set var="serverTS" value="${requestScope.formData['serverTS']}"/>
<c:set var="endpointId1" value="${requestScope.formData['endpointId1']}"/>
<c:set var="endpointId2" value="${requestScope.formData['endpointId2']}"/>

<style>
table.center {
    margin-left:auto;
    margin-right:auto;
    padding-right: 30px;
    width:80%;
}
td.icon,
td.icon-active {
	text-align: center;
	font-weight: bold;
    vertical-align:bottom;
    width:33%;
}
td.icon-active {
	color:#428bca;
}
td.title,
td.title-active {
    padding-top: 10px;
	text-align: center;
	font-weight: bold;
    vertical-align:bottom;
    width:33%;
}
td.title {
    padding-bottom: 10px;
}
td.title-active {
    padding-bottom: 9px;
    border-bottom:3px solid #428bca;
}
</style>

<script type="text/javascript" src="js/wowza-facebook.js"></script>
<script type="text/javascript" src="js/wowza-RestProxy.js"></script>
<script type="text/javascript" src="js/forge.min.js"></script>
<%@ include file="/WEB-INF/jsp/applications/common/streamtarget/streamTargetsCommon.jsp" %>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-5">
		    <happ><label id="pageTitleText">${wmsutil:escapeHtml(appName)} ${pagename}</label></happ><br>
			<small class="text-muted">${uiAppType}</small>
		</div>
		<wmsform:applicationbuttons page="streamtargetwizard"/>
	</div>
	<p style="margin-top:2px;margin-bottom:27px;"><a href="javascript:returnToStreamTargets()"><i class="fa fa-arrow-left"></i> <wmsform:getlocalestring page="appconfig.streamTargets" obj="return"/></a></p>
	<div class="notabs">
		<hr/>
	</div>
	<div class="row">
		<div class="col-md-8 main-content">
			<form:form method="post" commandName="formData" id="defaultForm">
				<form:hidden path="enabled"/>
				<form:hidden path="protocol"/>
				<form:hidden path="destinationName"/>
				<form:hidden path="destApplicationRequired"/>
				<form:hidden path="destAppInstanceRequired"/>
				<form:hidden path="usernameRequired"/>
				<form:hidden path="passwordRequired"/>
				<form:hidden path="wowzaCloudDestinationType"/>
				<form:hidden path="facebookUserName"/>
				<form:hidden path="facebookAccessToken"/>
				<form:hidden path="facebookDestName"/>
				<form:hidden path="facebookDestId"/>
				<form:hidden path="wowzaDotComFacebookUrl"/>
				<form:hidden path="wowzaFacebookAppId"/>
				<form:hidden path="wowzaCloudAdaptiveStreaming"/>
				<form:hidden path="wowzaCdnCloudAccountApiKey"/>
				<form:hidden path="wowzaCdnCloudAccountAccessKey"/>
				<form:hidden path="wowzaCdnCloudAccountName"/>
				<form:hidden path="wowzaCdnCloudAccountId"/>
				<form:hidden path="wowzaCdnCloudTargetId"/>
				<form:hidden path="wowzaCdnCloudPlaybackUrl"/>

				<div id="select-destination">
					<div class="col-md-12 row">
						<p><wmsform:getlocalestring page="appconfig.streamTargets.wizard.select.destination" obj="header"/></p>
					</div>
					<br>

					<!-- This is a list of Stream Target Destinations -->
					<div class="row container">
						<!-- Wowza destinations -->
						<div class="col-md-12 row">
							<label class="control-label"><wmsform:getlocalestring page="appconfig.streamtargets.wizard.destinations" obj="wowza"/></label>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="wowzastreamingengine" src="img/logo-wse.png" page="appconfig.streamTargets.wizard.destinations.wse" obj="name" pathName="${pathNameWSE}" href="https://www.wowza.com/docs/how-to-stream-to-another-wowza-streaming-engine-instance"> </wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="wowzastreamingcloud" src="img/logo-wsc.png" page="appconfig.streamTargets.wizard.destinations.wsc" obj="name" pathName="${pathNameWSC}" href="https://www.wowza.com/docs/using-wowza-cdn-with-wowza-streaming-engine"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="wowzacdn" src="img/logo-wsc-cdn.png" page="appconfig.streamTargets.wizard.destinations.wowzacdn" obj="name" pathName="${pathNameWowzaCDN}" href="https://www.wowza.com/docs/using-wowza-cdn-with-wowza-streaming-engine"></wmsform:buttondestinations>
						</div>
					</div>

					<!-- Third party destinations -->
					<div class="row container">
						<div class="col-md-12 row">
							<label class="control-label"><wmsform:getlocalestring page="appconfig.streamtargets.wizard.destinations" obj="thirdparty"/></label>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="akamai" src="img/logo-akamai.png" page="appconfig.streamTargets.wizard.destinations.akamai" obj="name" pathName="${pathNameAkamai}" href="https://www.wowza.com/docs/how-to-stream-to-akamai"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="alibaba" src="img/logo-alibaba.png" page="appconfig.streamTargets.wizard.destinations.alibaba" obj="name" pathName="${pathNameAlibaba}" href="https://www.wowza.com/docs/how-to-stream-to-alibaba-cloud"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="facebook" src="img/logo-facebook.png" page="appconfig.streamTargets.wizard.destinations.facebook" obj="name" pathName="${pathNameFacebook}" href="https://www.wowza.com/docs/how-to-stream-to-facebook-live-using-wowza-streaming-engine"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="limelight" src="img/logo-limelight.png" page="appconfig.streamTargets.wizard.destinations.limelight" obj="name" pathName="${pathNameLimelight}" href="https://www.wowza.com/docs/how-to-stream-to-limelight"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="mirrorimage" src="img/logo-mirrorimage.png" page="appconfig.streamTargets.wizard.destinations.mirrorImage" obj="name" pathName="${pathNameMirrorImage}" href="https://www.wowza.com/docs/how-to-stream-to-mirror-image"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="tata" src="img/logo-tata.png" page="appconfig.streamTargets.wizard.destinations.tata" obj="name" pathName="${pathNameTata}" href="https://www.wowza.com/docs/how-to-stream-to-bitgravity"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="youtube" src="img/logo-youtube.png" page="appconfig.streamTargets.wizard.destinations.youTube" obj="name" pathName="${pathNameYouTube}" href="https://www.wowza.com/docs/how-to-stream-to-youtube"></wmsform:buttondestinations>
						</div>
					</div>

					<!-- Generic Target Destinations -->
					<div class="row container">
						<div class="col-md-12 row">
							<label class="control-label"><wmsform:getlocalestring page="appconfig.streamtargets.wizard.destinations" obj="generic"/></label>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="icecast2" src="img/logo-icecast2.png" page="appconfig.streamTargets.wizard.destinations.icecast2" obj="name" pathName="${pathNameIcecast2}" href="https://www.wowza.com/docs/how-to-stream-to-shoutcast-and-icecast"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="mpegts" src="img/logo-mpegts.png" page="appconfig.streamTargets.wizard.destinations.mpegts" obj="name" pathName="${pathNameMPEGTS}" href="https://www.wowza.com/docs/how-to-use-mpeg-ts-to-distribute-live-streams"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="rtmp" src="img/logo-rtmp.png" page="appconfig.streamTargets.wizard.destinations.rtmp" obj="name" pathName="${pathNameRTMP}" href="https://www.wowza.com/docs/how-to-use-rtmp-to-distribute-live-streams"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="rtp" src="img/logo-rtp.png" page="appconfig.streamTargets.wizard.destinations.rtp" obj="name" pathName="${pathNameRTP}" href="https://www.wowza.com/docs/how-to-use-rtp-to-distribute-live-streams"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="shoutcast" src="img/logo-shoutcast1.png" page="appconfig.streamTargets.wizard.destinations.shoutcast" obj="name" pathName="${pathNameShoutcast}" href="https://www.wowza.com/docs/how-to-stream-to-shoutcast-and-icecast"></wmsform:buttondestinations>
						</div>
						<div class="col-md-3 dest-div row">
							<wmsform:buttondestinations buttonNumber="srt" src="img/logo-srt.png" page="appconfig.streamTargets.wizard.destinations.srt" obj="name" pathName="${pathNameSRT}" href="https://www.wowza.com/docs/how-to-use-srt-to-distribute-live-streams"></wmsform:buttondestinations>
						</div>
					</div>
				</div>

				<div id="configure-target" style="display:none">
					<div id="pageErrorMessage" class="col-md-12" style="display:none">
						<div class="alert alert-danger">
							<strong>${pageErrors}</strong>
						</div>
					</div>
					<wmsform:rightrailhideshow/>

					<div basicWizardOnlyEdit class="col-md-12" style="display:inline-block">
						<re:mark>Some use name, some use nameSmall. </re:mark>
						<re:mark>The difference some targets have names with spaces in them</re:mark>
						<re:mark>name will have a line break in them</re:mark>
						<re:mark>namesmall doesn't, but not all targets need a name small</re:mark>
						<re:mark>We dont' want the line breaks on this page</re:mark>
						<div id=wizardOnlyakamai style="display:none">
							<wmsform:destinationimgandname destName="akamai" src="img/logo-akamai.png" page="appconfig.streamTargets.wizard.destinations.akamai" obj="name"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyalibaba style="display:none">
							<wmsform:destinationimgandname destName="alibaba" src="img/icon-alibaba.png" page="appconfig.streamTargets.wizard.destinations.alibaba" obj="name"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyfacebook style="display:none">
							<wmsform:destinationimgandname destName="facebook" src="img/icon-facebook.png" page="appconfig.streamTargets.wizard.destinations.facebook" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyicecast2 style="display:none">
							<wmsform:destinationimgandname destName="icescast2" src="img/icon-icecast2.png" page="appconfig.streamTargets.wizard.destinations.icecast2" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlylimelight style="display:none">
							<wmsform:destinationimgandname destName="limelight" src="img/icon-limelight.png" page="appconfig.streamTargets.wizard.destinations.limelight" obj="name"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlymirrorimage style="display:none">
							<wmsform:destinationimgandname destName="mirrorimage" src="img/icon-mirrorimage.png" page="appconfig.streamTargets.wizard.destinations.mirrorImage" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlympegts style="display:none">
							<wmsform:destinationimgandname destName="mpegts" src="img/icon-mpegts.png" page="appconfig.streamTargets.wizard.destinations.mpegts" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyrtmp style="display:none">
							<wmsform:destinationimgandname destName="rtmp" src="img/icon-rtmp.png" page="appconfig.streamTargets.wizard.destinations.rtmp" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyrtp style="display:none">
							<wmsform:destinationimgandname destName="rtp" src="img/icon-rtp.png" page="appconfig.streamTargets.wizard.destinations.rtp" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyshoutcast style="display:none">
							<wmsform:destinationimgandname destName="shoutcast" src="img/icon-shoutcast1.png" page="appconfig.streamTargets.wizard.destinations.shoutcast" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlysrt style="display:none">
							<wmsform:destinationimgandname destName="srt" src="img/icon-srt.png" page="appconfig.streamTargets.wizard.destinations.srt" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlytata style="display:none">
							<wmsform:destinationimgandname destName="tata" src="img/icon-tata.png" page="appconfig.streamTargets.wizard.destinations.tata" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlyyoutube style="display:none">
							<wmsform:destinationimgandname destName="youtube" src="img/icon-youtube.png" page="appconfig.streamTargets.wizard.destinations.youTube" obj="name"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlywowzastreamingcloud style="display:none">
							<wmsform:destinationimgandname destName="wowzastreamingcloud" src="img/icon-wsc.png" page="appconfig.streamTargets.wizard.destinations.wsc" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlywowzastreamingengine style="display:none">
							<wmsform:destinationimgandname destName="wowzastreamingengine" src="img/icon-wse.png" page="appconfig.streamTargets.wizard.destinations.wse" obj="nameSmall"></wmsform:destinationimgandname>
						</div>
						<div id=wizardOnlywowzacdn style="display:none">
							<wmsform:destinationimgandname destName="wowzacdn" src="img/icon-wsc-cdn.png" page="appconfig.streamTargets.wizard.destinations.wowzacdn" obj="nameSmall"></wmsform:destinationimgandname>
						</div>

					</div>

					<div class="row">
						<div class="col-md-12">
							<p>* = Required Field</p>
						</div>
					</div>

					<div id="configure-target-configs">
						<re:mark>Include the edit widgets for the basic stream target configuration properties</re:mark>

						<%@ include file="EditBasicConfigs.jsp" %>

						<re:mark>
							We go ahead and define the edit widgets for the advanced stream target configuration properties too, even though they will not be displayed.
							We do this to ensures that:
								1) all of the default model values (originally from PushPublishStreamAppConfig) will be preserved across the AJAX post in addTarget() (except for those basic that the user has modified), and
								2) the REST PushPublishStreamAppConfig POST processing on the WSE will recognize that those properties are still set to the default values and will therefore not write them to the map file.
						</re:mark>
						<%@ include file="EditAdvConfigs.jsp" %>
					</div>
					<br>
					<div id="targetButtons" class="row">
						<wmsform:buttoncancel onClick="javascript:returnToStreamTargets()" />
						<div style="float:right;margin-right:21px;">
							<wmsform:buttonaddtarget onClick="javascript:addTarget()"/>
						</div>
					</div>
				</div>
			</form:form>
		</div>

		<div id="HelpWizard" class="col-md-4 right-rail well-help pull-right">
			<jsp:include page="HelpWizard_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</div>
</div>
<wmsform:setpagetitle page=""/>
<wmsdialog:eula page="${page}"/>

<script>
var inWizard = true;
var selectedDestinationName = "";
var selectedDestinationPathName = "";
var selectedProtocol = "";

//Show the Eula popup if the cloud API says the user needs to accept or check the global variable we can set on the page
// before calling Sign In to force the pop-up. see wowza-RestProxy
var forceEulaPopup = false;
var cloudAccounts=null;

$(document).ready(function() {

	var scope = ["publish_video", "manage_pages", "publish_pages", "publish_to_groups", "pages_show_list", "business_management"];
	var wowzaURL = $("#wowzaDotComFacebookUrl").val();
	var wowzaAppId = $("#wowzaFacebookAppId").val();
	WOWZA.Facebook.init(scope, wowzaURL, wowzaAppId);
	WOWZA.RestProxy.push("${serverId1}");
	WOWZA.RestProxy.push("${serverId2}");

	$('#destinationsBtnwowzastreamingengine').hover(function() {
		$('#targetDestBtnwowzastreamingengine').addClass("btn-targetdest-active");
		$('#targetDestBtnTextwowzastreamingengine').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "wowzastreamingengine")
			{
				$('#targetDestBtnwowzastreamingengine').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextwowzastreamingengine').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnwowzastreamingcloud').hover(function() {
		$('#targetDestBtnwowzastreamingcloud').addClass("btn-targetdest-active");
		$('#targetDestBtnTextwowzastreamingcloud').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "wowzastreamingcloud")
			{
				$('#targetDestBtnwowzastreamingcloud').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextwowzastreamingcloud').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnwowzacdn').hover(function() {
		$('#targetDestBtnwowzacdn').addClass("btn-targetdest-active");
		$('#targetDestBtnTextwowzacdn').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "wowzacdn")
			{
				$('#targetDestBtnwowzacdn').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextwowzacdn').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnfacebook').hover(function() {
		$('#targetDestBtnfacebook').addClass("btn-targetdest-active");
		$('#targetDestBtnTextfacebook').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "facebook")
			{
				$('#targetDestBtnfacebook').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextfacebook').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnakamai').hover(function() {
		$('#targetDestBtnakamai').addClass("btn-targetdest-active");
		$('#targetDestBtnTextakamai').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "akamai")
			{
				$('#targetDestBtnakamai').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextakamai').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnalibaba').hover(function() {
		$('#targetDestBtnalibaba').addClass("btn-targetdest-active");
		$('#targetDestBtnTextakalibaba').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "alibaba")
			{
				$('#targetDestBtnalibaba').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextalibaba').attr('style', 'color:black');
			}
	});
	$('#destinationsBtntata').hover(function() {
		$('#targetDestBtntata').addClass("btn-targetdest-active");
		$('#targetDestBtnTexttata').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "tata")
			{
				$('#targetDestBtntata').removeClass('btn-targetdest-active');
				$('#targetDestBtnTexttata').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnlimelight').hover(function() {
		$('#targetDestBtnlimelight').addClass("btn-targetdest-active");
		$('#targetDestBtnTextlimelight').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "limelight")
			{
				$('#targetDestBtnlimelight').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextlimelight').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnmirrorimage').hover(function() {
		$('#targetDestBtnmirrorimage').addClass("btn-targetdest-active");
		$('#targetDestBtnTextmirrorimage').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "mirrorimage")
			{
				$('#targetDestBtnmirrorimage').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextmirrorimage').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnicecast2').hover(function() {
		$('#targetDestBtnicecast2').addClass("btn-targetdest-active");
		$('#targetDestBtnTexticecast2').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "icecast2")
			{
				$('#targetDestBtnicecast2').removeClass('btn-targetdest-active');
				$('#targetDestBtnTexticecast2').attr('style', 'color:black');
			}
	});

	$('#destinationsBtnshoutcast').hover(function() {
		$('#targetDestBtnshoutcast').addClass("btn-targetdest-active");
		$('#targetDestBtnTextshoutcast').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "shoutcast")
			{
				$('#targetDestBtnshoutcast').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextshoutcast').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnyoutube').hover(function() {
		$('#targetDestBtnyoutube').addClass("btn-targetdest-active");
		$('#targetDestBtnTextyoutube').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "youtube")
			{
				$('#targetDestBtnyoutube').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextyoutube').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnmpegts').hover(function() {
		$('#targetDestBtnmpegts').addClass("btn-targetdest-active");
		$('#targetDestBtnTextmpegts').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "mpegts")
			{
				$('#targetDestBtnmpegts').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextmpegts').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnrtp').hover(function() {
		$('#targetDestBtnrtp').addClass("btn-targetdest-active");
		$('#targetDestBtnTextrtp').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "rtp")
			{
				$('#targetDestBtnrtp').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextrtp').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnrtmp').hover(function() {
		$('#targetDestBtnrtmp').addClass("btn-targetdest-active");
		$('#targetDestBtnTextrtmp').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "rtmp")
			{
				$('#targetDestBtnrtmp').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextrtmp').attr('style', 'color:black');
			}
	});
	$('#destinationsBtnsrt').hover(function() {
		$('#targetDestBtnsrt').addClass("btn-targetdest-active");
		$('#targetDestBtnTextsrt').attr('style', 'color:white');
		}, function() {
			if (selectedDestinationName != "srt")
			{
				$('#targetDestBtnsrt').removeClass('btn-targetdest-active');
				$('#targetDestBtnTextsrt').attr('style', 'color:black');
			}
	});

	$("#addtargetbtn").hide();
});

function gotoStreamTargets()
{
	loadAjaxMainContent("applications/${appType}/streamtargets/view.htm","vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}");
}

function gotoDestinationConfiguration ()
{
	// put the selected destination in the path at the top of the screen
	$("[selDestPathName]").html(selectedDestinationPathName);

	hideAllWizardPages();
}

function hideAllWizardPages ()
{
	$("#select-destination").children().hide();
	$("#select-destination-help").hide();

	$("#destination-options").children().hide();
	$("#destination-options-help-dest-protocol").hide();
	$("#destination-options-help-shoutcast").hide();
	$("#destination-options-help-facebook").hide();

	$("#configure-target").hide();
	$("#configure-target-help").hide();
}

function hideAllProtocolGroups ()
{
	$("#protocolRTMPGroup").hide();
	$("#protocolWSCGroup").hide();
	$("#protocolAkamaiGroup").hide();
	$("#protocolAlibabaGroup").hide();
	$("#protocolRTPGroup").hide();
	$("#protocolMPEGTSGroup").hide();
	$("#protocolShoutcastGroup").hide();
	$("#protocolFacebookGroup").hide();
	$("#protocolSRTGroup").hide();
}

function targetDestClick (targetDestVal)
{
	// set the destination name in the model
	$("#destinationName").val(targetDestVal);

	selectedDestinationName = targetDestVal;
	selectedDestinationPathName = $("#targetDestBtn"+targetDestVal).attr("pathName");

	hideAllWizardPages();

	// show the destination-options page
	$("#destination-options").children().show();

	// hide all the protocol group divs, then selectively show the one's appropriate for the selected destination
	hideAllProtocolGroups();

	// this switch is to manage the title at the top of the page only, the next switch enables/disables the appropriate target
	// fields
	var destName;
	switch(selectedDestinationName)
	{
		case "wowzastreamingengine":
			destName = "<c:out value='${pathNameWSE}'/>";
			selectedProtocol = "RTMP";
			break;
		case "wowzastreamingcloud":
			destName = "<c:out value='${pathNameWSC}'/>";
			selectedProtocol = "CloudConfig";
			break;
		case "wowzacdn":
			destName = "<c:out value='${pathNameWowzaCDN}'/>";
			selectedProtocol = "CloudConfig";
			WOWZA.RestProxy.push("${endpointId1}");
			WOWZA.RestProxy.push("${endpointId2}");
			break;
		case "akamai":
			destName = "<c:out value='${pathNameAkamai}'/>";
			selectedProtocol = $('input[name=protocolAkamai]:checked').val();
			break;
		case "alibaba":
			destName = "<c:out value='${pathNameAlibaba}'/>";
			selectedProtocol = "RTMP";
			break;
		case "facebook":
			destName = "<c:out value='${pathNameFacebook}'/>";
			selectedProtocol = "RTMP";
			break;
		case "limelight":
			destName = "<c:out value='${pathNameLimelight}'/>";
			selectedProtocol = "RTMP";
			break;
		case "mirrorimage":
			destName = "<c:out value='${pathNameMirrorImage}'/>";
			selectedProtocol = "RTMP";
			break;
		case "tata":
			destName = "<c:out value='${pathNameTata}'/>";
			selectedProtocol = "RTMP";
			break;
		case "youtube":
			destName = "<c:out value='${pathNameYouTube}'/>";
			selectedProtocol = "RTMP";
			break;

		case "icecast2":
			destName = "<c:out value='${pathNameIcecast2}'/>";
			selectedProtocol = "Icecast2";
			break;
		case "mpegts":
			destName = "<c:out value='${pathNameMPEGTS}'/>";
			selectedProtocol = "MPEG-TS";
			break;
		case "rtmp":
			destName = "<c:out value='${pathNameRTMP}'/>";
			selectedProtocol = "RTMP";
			break;
		case "rtp":
			destName = "<c:out value='${pathNameRTP}'/>";
			selectedProtocol = "RTP";
			break;
		case "shoutcast":
			destName = "<c:out value='${pathNameShoutcast}'/>";
			selectedProtocol = $('input[name=protocolShoutcast]:checked').val();
			break;
		case "srt":
			destName = "<c:out value='${pathNameSRT}'/>";
			selectedProtocol = "SRT"
			break;
		default:
			break;
	}

	// enable the <target img> <target name> Configuration at the top of each configuration screen
	$("#wizardOnly"+selectedDestinationName).show();

	// Set the selectd application/destination at the top of the screen
	var s = document.getElementById('pageTitleText');
	s.innerHTML = "<c:out value='${appName}'/>" + " > " + destName;

	// set the hidden protocol field
	$("#protocol").val(selectedProtocol);

	// hide all the individual configs, errors, & help within the configure-target page
	$("[id*='ErrorMsg']").hide();
	$("#configure-target-configs").children().hide();
	$("#configure-target-help").children().hide();

	// Show the WizardOnlyConfig which is now separate from the WizardOnly in wizard.jsp
	$("[basicWizardOnlyEdit]").show();
	//$("#basicWizardOnlyEdit").show();
	$("[basicWizardOnlyConfigEdit]").show();
	//$("#basicWizardOnlyConfigEdit").show();

	// show the configure-target page children
	$("#configure-target").show();
	$("#configure-target-help").show();

	showConfigs("basic", "Edit");

	// now twiddle a few bits that shouldn't be show or need to be show based on the target
	// after the common showConfigs does it's thing
	switch(selectedDestinationName)
	{
	case "facebook":
		$("#addtargetbtn").addClass("disabled");
		$("#facebookLoginTextWizard").show();
		$("#facebookLoginTextEditTab").hide();
		$("#facebookCurrentConfig").hide();
		$("#facebookCurrentConfigHelp").hide();
		$("#facebookPrivacyOption").hide();
		$("#facebookPrivacyConfigHelp").hide();
		break;

	case "icecast2":
		$("#shoutcastPort").val("8000");
		$("#shoutcastUsername").val("source");
		break;

	case "shoutcast":
		$("#shoutcastPort").val("8000");
		$("#destination-options-help-shoutcast").show();
		updateShoutCastSettings();
		break;

	case "wowzastreamingcloud":
		$("[basicWowzaStreamingCloudEdit]").show();

		// hide the -already used- help text since it's only used for
		// editing/not creating
		$("#WowzaStreamingCloudConnectionCodeAlreadyUsedHelp").hide();
		break;

	case "wowzacdn":
		//set up on page entry.
		$("#addtargetbtn").addClass("disabled");
		$("[basicWowzaCdnLoginEdit]").show();
		$("[basicWowzaCdnCloudSignInTextEdit]").show();
		$("[basicWowzaCdnLoginMessageEdit]").hide();
		$("#addtargetbtn").attr("onclick","createWowzaCDNtarget()");

		if (!inWizard)
		{
			$("[basicWowzaCdnViewAccountInfoEdit]").show();
		}
		break;

	default:
		break;
	}

	$("#addtargetbtn").show();
}

function createWowzaCDNtarget ()
{
	if (validateBasicConfigOptions())
	{
 		var apiKey = null;
 		var accessKey = null;
 		var accountId = null;

 		for (var account in cloudAccounts) {
			if ($('#wowzaCdnAccountSelection').val() == cloudAccounts[account].name)
			{
		 		$('#wowzaCdnCloudAccountName').val(cloudAccounts[account].name);
		 		apiKey = cloudAccounts[account].api_key;
		 		accessKey = cloudAccounts[account].access_key;
		 		accountId = cloudAccounts[account].id;
		 		$('#wowzaCdnCloudAccountApiKey').val("${serverTS}:::" + WOWZA.RestProxy.hide(apiKey, WOWZA.RestProxy.pull()));
				$('#wowzaCdnCloudAccountAccessKey').val("${serverTS}:::" + WOWZA.RestProxy.hide(accessKey, WOWZA.RestProxy.pull()));
				$('#wowzaCdnCloudAccountId').val("${serverTS}:::" + WOWZA.RestProxy.hide(accountId, WOWZA.RestProxy.pull()));
				break;
			}
		}
		
		var request={};
		request.cmd = "create-target";
		request.api_key = apiKey;
		request.access_key = accessKey;
		request.name = $('#streamTargetName').val().trim();
		var dataPost =  JSON.stringify(request);

		WOWZA.RestProxy.request("${appType}", "${wmsutil:urlEncode(vhost)}", "${wmsutil:urlEncode(appName)}", dataPost, function(state, responseData) {
			if (state)
			{
				var dataJSON = JSON.parse(responseData);

				var responseJSON = null;
				var decodedResponse = null;
				if (dataJSON.success && (dataJSON.code =="201"))
				{
					// The entire WSC apiResponse string is URI-encoded, so decode it first
					decodedResponse = decodeURIComponent(dataJSON.data);
					// now parse the JSON
					responseJSON = JSON.parse(decodedResponse);

					//console.log(responseJSON.stream_target.id);
					$('#wowzaCdnCloudTargetId').val(responseJSON.stream_target.id);
					$('#wowzaCdnCloudPlaybackUrl').val(responseJSON.stream_target.hls_playback_url);

					addTarget();
				}
				else
				{
					console.log("create steam target request sent to cloud but an error was returned.");
					console.log(dataJSON.code + ", " + dataJSON.message);
				}
			}
			else
			{
				console.log("problem in controller call" );
			}
		});
	}
}

function addTarget ()
{
	if (validateBasicConfigOptions())
	{
		// For all targets, call the controller to Add This Target
		var serializedForm = $("form#defaultForm").serialize() + "&vhost=${vhost}&appName=${appName}";
		$.ajax( {
			type : "POST",
			url : "applications/${appType}/streamtarget/validateNewStreamTarget.json",
			data : serializedForm,
			datatype : "application/json",
			contentType : "application/x-www-form-urlencoded;charset=UTF-8",
			success: function(data) {
				if (data.substring(0, redirectLoginString.length) == redirectLoginString) {
					document.location = "login.htm" + location.hash;
				} else {
					var obJSON = JSON && JSON.parse(data) || $.parseJSON(data)
					if (obJSON.valid)
					{
						lastTab='Basic';
						postAJAXForm('applications/${appType}/streamtarget/add.htm', 'vhost=${vhost}&appName=${appName}');
					}
					else
					{
						$("#streamTargetNameErrorMsg").html(obJSON.message);
						$("#streamTargetNameErrorMsg").show();
					}
				}
			},
		});
	}
}
</script>
