<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Sony SRG PTZ Cameras</h4>
<p>Sony SRG-300SE PTZ (pan/tilt/zoom) cameras can publish IP video and audio to Wowza Streaming Engine servers. You can manage the camera settings via a web browser and operate the camera using a remote controller. Use this page to create connection settings in a stream file that enables this application to re-stream the camera's video output to players. For detailed instructions, see <a href="https://www.wowza.com/docs/how-to-connect-the-sony-srg-300se-to-wowza-streaming-engine" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Connect the Sony SRG-300SE to Wowza Streaming Engine</a>.</p>

<blockquote><strong>Note:</strong> Sony is a <a href="https://www.wowza.com/partners" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Works with Wowza&#8482;</a> partner.</blockquote>

<h4>Application Connection Settings</h4>
<p><strong>Stream Name</strong><br />
Enter a name for your stream. The stream name can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (' and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<p>The stream name is used to create a stream file that replaces (aliases) the Sony camera's complex stream URI so that players can use the stream file name in playback URLs in place of the camera's complex stream name. Stream files are stored in an application's streaming file directory and have a <strong>.stream</strong> file name extension. You must enter a stream name value that creates a unique stream file name.</p>

<p><strong>Camera IP Address</strong><br />
Enter the IP address (or mapped domain) of the camera. The camera's IP address is the network address that you set up using the Sony Network Camera (SNC) toolbox. If your camera requires RTSP streaming authentication, add credentials in the following format: [rtsp-username]:[rtsp-password]@[camera-ip-address].

<p><strong>Camera Authentication</strong><br />
Enter your <strong>Camera User Name</strong> and <strong>Camera Password</strong>. These are the Administrator or User authentication credentials that you set up in the Sony Network Camera (SNC) toolbox and they are used to access the camera's PTZ controls from this application's <strong>Incoming Streams</strong> page. You can change the credentials by editing the stream file in this application's <strong>Stream Files</strong> page.

<p><strong>Create Connection</strong><br />
Wowza Streaming Engine creates the Sony camera stream URI in the stream file, and then connects to the camera stream URI to re-stream the camera's output to players. If the camera is offline, the Wowza Streaming Engine instance will try to connect every 3&nbsp;seconds until the camera comes online.</p>

<h4>Camera Configuration</h4>
<p>By default, the live application in the Wowza Streaming Engine instance pulls an RTSP unicast stream from the camera's <strong>Image&nbsp;1</strong> image codec. To specify unicast transmission in the camera settings, in the camera's web-based live viewer, in the <strong>Other</strong> panel, select <strong>Unicast</strong> in the <strong>Connection</strong> list. For details about how to operate your camera, refer to your Sony camera's user guide.</p>

<blockquote><strong>Note:</strong> The Sony camera has three image codec modes (<strong>Image&nbsp;1</strong>, <strong>Image&nbsp;2</strong>, and <strong>Image&nbsp;3</strong>) that     can be used to stream video. If you set up the <strong>Image&nbsp;2</strong> or <strong>Image&nbsp;3</strong> image codecs to stream video, you can edit the stream URI in the stream file to get the video from the correct image codec. For more information, see <a href="https://www.wowza.com/docs/how-to-connect-the-sony-srg-300se-to-wowza-streaming-engine" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Connect the Sony SRG-300SE to Wowza Streaming Engine</a>.</blockquote>