<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Panasonic PTZ Cameras</h4>
<p>Panasonic AW Series PTZ (pan/tilt/zoom) cameras can publish IP video and audio to Wowza Streaming Engine servers. You can manage the camera settings and operate the camera via the camera menu or a web-based application. Use this page to create connection settings in a stream file that enables this application to re-stream the camera's video output to players. For detailed instructions, see <a href="https://www.wowza.com/docs/how-to-connect-panasonic-aw-series-ptz-cameras-to-wowza-streaming-engine" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Connect Panasonic AW series PTZ cameras to Wowza Streaming Engine</a>.</p>

<blockquote><strong>Note:</strong> <br />Ensure you have the latest firmware for your camera.<br /><a href="http://www.wowza.com/docredirect.php?doc=external_camerasPanasonicFirmware" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Download Panasonic camera firmware</a><br /><br />Panasonic is a <a href="https://www.wowza.com/partners" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Works with Wowza&#8482;</a> partner.</blockquote>

<h4>Application Connection Settings</h4>
<p><strong>Stream Name</strong><br />
Enter a name for your stream. The stream name can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (' and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<p>The stream name is used to create a stream file that replaces (aliases) the Panasonic camera's complex stream URI so that players can use the stream file name in playback URLs in place of the camera's complex stream name. Stream files are stored in an application's streaming file directory and have a <strong>.stream</strong> file name extension. You must enter a stream name value that creates a unique stream file name.</p>

<p><strong>Camera IP Address</strong><br />
Enter the IP address (or mapped domain) of the camera. The camera's IP address is the network address that you established using the Easy IP Setup Software. If your camera requires RTSP streaming authentication, add credentials in the following format: [rtsp-username]:[rtsp-password]@[camera-ip-address].

<p><strong>Pan/Tilt/Zoom (PTZ)</strong><br />
Select the <strong>Enter user credentials for PTZ-capable cameras</strong> check box to enter a user name and password. These credentials may differ from the RTSP streaming credentials and are used to access the camera's PTZ controls from this application's <strong>Incoming Streams</strong> page. You can change the credentials by editing the stream file in this application's <strong>Stream Files</strong> page.

<p><strong>Create Connection</strong><br />
Wowza Streaming Engine creates the Panasonic PTZ camera stream URI in the stream file, and then connects to the camera stream URI to re-stream the camera's output to players. If the camera is offline, the Wowza Streaming Engine instance will try to connect every 3&nbsp;seconds until the camera comes online.</p>

<h4>Camera Configuration</h4>
<p>Refer to your Panasonic PTZ camera Operating Instructions manual for detailed instructions about how configure and manage your broadcast and camera settings.</p>