<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<style>
.urltext {
    color:#888;
}
.urlfieldX {
    width:153px;
    display:inline-block;
    margin: 4px 4px;
}
.urlfield {
    display:inline-block;
    margin: 4px 4px;
}

</style>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>
<c:set var="hlsDisabled">
	${requestScope.formData['hlsDisabled']}
</c:set>
<c:set var="pathNotice">
	<wmsform:getlocalestring page="appconfig.player" obj="filePathNotice" />
</c:set>

<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="vhost"/>
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType"/>
	<form:hidden path="section" />
	<form:hidden path="action" />
	<form:hidden path="selectedUrl" />
	<form:hidden path="playerIncomingStreamsOptions" />
	<form:hidden path="playerVodUrlPrefixOptions" />
	<form:hidden path="playerVodEdgeSourceOptions" />
	<form:hidden path="playerVodUrlPrefix" />
	<form:hidden path="playerVodUrlSource" />
	<form:hidden path="incomingStreamRadio" />
	<form:hidden path="streamTargetRadio" />
	<form:hidden path="manualHlsRadio" />
	<form:hidden path="vodAppInst" />
	<form:hidden path="vodPath" />
	<form:hidden path="playerDomain" />
 </fieldset>

<div class="row">
	<div class="col-md-8">
		<div class="media">
			<p class="lead">
				<img src="img/icon-player.png" />
				<wmsform:getlocalestring page="appconfig.player" obj="logoText" />
			</p>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="media-body" style="font-size:16px;">
			<p>
				<wmsform:getlocalestring page="appconfig.player" obj="header" />
			</p>
		</div>
	</div>
</div>

<div id="editSection">
	<c:choose>
		<c:when test="${requestScope.formData['appType']=='live'}">
			<re:mark>This is the player page for Live app type</re:mark>
			<div class="row">
				<div class="col-md-12">
					<div class="media-body" style="font-size:16px;">
						<p>
							<wmsform:getlocalestring page="appconfig.player" obj="description" />
						</p>
						<br/>

					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					<p>
						<b><wmsform:getlocalestring page="appconfig.player" obj="streamSource" /></b>
					</p>

					<div class="radio">
						<label><input type="radio" name="appconfig.player" id="radioIncomingStream"
							value="true"> <wmsform:getlocalestring page="appconfig.player" obj="incomingStreamRadio" /></label>
					</div>
					<div id="setUpStreamTarget" class="container">
						<wmsform:editpropertydropdown page="appconfig.player" obj="playerIncomingStreams" showTitle="no" cssSize="col-md-12" cssClass="form-control"/>
						<div id="playerIncomingStreamsWarnings" class="alert alert-danger" style="display:none;"></div>
					</div>

			<%-- 		<div class="radio">
						<label><input type="radio" name="appconfig.player" id="radioStreamTarget"
							value="streamTargetRadio"> <wmsform:getlocalestring page="appconfig.player" obj="streamTargetRadio" /></label>
					</div>
					<div id="setUpStreamTarget" class="container">
						<wmsform:editpropertydropdown page="appconfig.player" obj="playerStreamTarget" showTitle="no" cssSize="col-md-4"/>
						<div id="playerStreamTargetWarnings" class="alert alert-danger" style="display:none;"></div>
					</div>
			 --%>
					<div class="radio">
						<label><input type="radio" name="appconfig.player" id="radioManualHls"
							value="manualHlsRadio"> <wmsform:getlocalestring page="appconfig.player" obj="ManualHlsRadio" /></label>
					</div>
					<div id="setUpHLS" class="container">
						<wmsform:editproperty page="appconfig.player" obj="playerManualHls" required="true" showTitle="no"/>
						<div id="playerManualHlsWarnings" class="alert alert-danger" style="display:none;"></div>
					</div>
				</div>
			</div>
			<div id="liveFilePathValWarnings" class="alert alert-danger" style="display:none;"></div>
		</c:when>
		<c:when test="${requestScope.formData['appType']=='vodedge'}">
			<script>
			</script>
			<re:mark>This is the player page for Vod app type</re:mark>
			<div class="row">
				<div class="col-md-12">
					<div class="media-body" style="font-size:16px;">
						<p>
							<wmsform:getlocalestring page="appconfig.player" obj="voddescription" />
						</p>
						<br/>
					</div>
				</div>
			</div>
			<b><wmsform:getlocalestring page="appconfig.player" obj="vodPlaybackUrl" /></b><br/>
			<wmsform:getlocalestring page="appconfig.player" obj="vodPlaybackUrlDescription" />
			<br/>
			<div id="url-container">
				<c:set var="valueList">${requestScope.formData['playerVodUrlPrefixOptions']}</c:set>
				<c:set var="valueList" value="${fn:replace(valueList, '[', '')}" />
				<c:set var="valueList" value="${fn:replace(valueList, ']', '')}" />

				<c:set var="sourceList">${requestScope.formData['playerVodEdgeSourceOptions']}</c:set>
				<c:set var="sourceList" value="${fn:replace(sourceList, '[', '')}" />
				<c:set var="sourceList" value="${fn:replace(sourceList, ']', '')}" />
				<c:set var="sourceList" value="${fn:replace(sourceList, '/', '')}" />

				<re:mark>valueList is now a string of comma-separated URL prefixes like "https://localhost.streamlock.net, http://10.0.2.26:1935"</re:mark>
				<br>
				<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

				<div class="urltext">
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">Host *</div>
						<div>
							<select id="urlPrefixSelect" style="display:inline-block;width:245px;margin-top:5px;margin-right:4px;" class="form-control" onchange="onInput()">
								<c:forEach var="itemKey" items="${fn:split(valueList,',')}">
									<option value="${fn:trim(itemKey)}">${fn:trim(itemKey)}</option>
								</c:forEach>
							</select>
						</div>
					</div>
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">&nbsp;</div>
						<div style="text-align:center;padding-top:11px;">
							/${appName}/
						</div>
					</div>
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">Instance</div>
						<div>
							<input type="text" name="vod-appinst" id="vodAppInstVal" placeholder="_definst_" class="urlfield form-control" style="width:20px;" oninput="onInput()"/>
						</div>
					</div>
					<div style="display:inline-block;">
						<div>&nbsp;</div>
						<div style="text-align:center;padding-top:11px;">
							/
						</div>
					</div>

					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">Media Cache Prefix</div>
						<div>
							<select id="urlPrefixSourceSelect" style="display:inline-block;width:145px;margin-top:5px;margin-right:4px;" class="form-control" onchange="onInput()">
								<c:forEach var="itemKey" items="${fn:split(sourceList,',')}">
									<c:set var="displayKey" value="${fn:trim(itemKey)}" />
									<option value="${fn:trim(itemKey)}">${displayKey}</option>
								</c:forEach>
							</select>
						</div>
					</div>

					<div style="display:inline-block;">
						<div>&nbsp;</div>
						<div style="text-align:center;padding-top:11px;">
							/
						</div>
					</div>


					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">File Path *</div>
						<div>
							<input type="text" name="vod-path" id="vodPathVal" placeholder="[media-prefix]:[path]/[file-name]"class="urlfield form-control" style="width:225px;" oninput="onInput()"/>
						</div>
					</div>
					<div style="display:inline-block;width:100px;text-align:left;">
						<div style="font-weight:bold;color:#000;text-align:left;">&nbsp;</div>
						<div style="padding-top:11px;text-align:left;">
							/playlist.m3u8
						</div>
					</div>
				</div>
				<p id="completedUrl" style="margin-top:10px;" >${pathNotice}</p>

			</div>
			<div id="vodFilePathValWarnings" class="alert alert-danger" style="display:none;"></div>
		</c:when>


		<c:when test="${requestScope.formData['appType']=='vod'}">
			<script>
			</script>
			<re:mark>This is the player page for VodEdge app type</re:mark>
			<div class="row">
				<div class="col-md-12">
					<div class="media-body" style="font-size:16px;">
						<p>
							<wmsform:getlocalestring page="appconfig.player" obj="voddescription" />
						</p>
						<br/>
					</div>
				</div>
			</div>
			<b><wmsform:getlocalestring page="appconfig.player" obj="vodPlaybackUrl" /></b><br/>
			<wmsform:getlocalestring page="appconfig.player" obj="vodPlaybackUrlDescription" />
			<br/>
			<div id="url-container">
				<c:set var="valueList">${requestScope.formData['playerVodUrlPrefixOptions']}</c:set>
				<c:set var="valueList" value="${fn:replace(valueList, '[', '')}" />
				<c:set var="valueList" value="${fn:replace(valueList, ']', '')}" />
				<re:mark>valueList is now a string of comma-separated URL prefixes like "https://localhost.streamlock.net, http://10.0.2.26:1935"</re:mark>
				<br>
				<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

				<div class="urltext">
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">Host *</div>
						<div>
							<select id="urlPrefixSelect" style="display:inline-block;width:245px;margin-top:5px;margin-right:4px;" class="form-control" onchange="onInput()">
								<c:forEach var="itemKey" items="${fn:split(valueList,',')}">
									<option value="${fn:trim(itemKey)}">${fn:trim(itemKey)}</option>
								</c:forEach>
							</select>
						</div>
					</div>
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">&nbsp;</div>
						<div style="text-align:center;padding-top:11px;">
							/${appName}/
						</div>
					</div>
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">Instance</div>
						<div>
							<input type="text" name="vod-appinst" id="vodAppInstVal" placeholder="_definst_" class="urlfield form-control" style="width:20px;" oninput="onInput()"/>
						</div>
					</div>
					<div style="display:inline-block;">
						<div>&nbsp;</div>
						<div style="text-align:center;padding-top:11px;">
							/
						</div>
					</div>
					<div style="display:inline-block;">
						<div style="font-weight:bold;text-align:center;color:#000;">File Path *</div>
						<div>
							<input type="text" name="vod-path" id="vodPathVal" placeholder="[media-prefix]:[path]/[file-name]"class="urlfield form-control" style="width:225px;" oninput="onInput()"/>
						</div>
					</div>
					<div style="display:inline-block;width:100px;text-align:left;">
						<div style="font-weight:bold;color:#000;text-align:left;">&nbsp;</div>
						<div style="padding-top:11px;text-align:left;">
							/playlist.m3u8
						</div>
					</div>
				</div>
				<p id="completedUrl" style="margin-top:10px;" >${pathNotice}</p>

			</div>
			<div id="vodFilePathValWarnings" class="alert alert-danger" style="display:none;"></div>
		</c:when>
	</c:choose>
	<div class="row">
		<div class="col-md-12">
			<div class="row">
				<div class="input-group col-md-7">
					<br/>
					<wmsform:buttonprimary page="appconfig.player" obj="launchPlayerBuilder" onClick="javascript:launchPlayerPage()" icon="fa fa-external-link" /> <!-- Firefox still posts the form event. use jQuery instead of onClick="javascript:getEncoderConfigFile()" -->
	<%-- 				<span class="input-group-btn"><button class="btn btn-primary" name="launchPlayerBuilder" id="launchPlayerBuilderID"> <!-- Firefox still posts the form event. use jQuery instead of onClick="javascript:getEncoderConfigFile()" -->
							<i class="fa fa-link"></i>
							<fmt:message key='appconfig.player.launchPlayerBuilder' />
						</button></span>
	--%>
				</div>
			</div>
			<small class="text-muted"> <wmsform:getlocalestring page="appconfig.player" obj="playerBuilderInfo" /> </small>
		</div>
	</div>
</div>

<c:set var="blankFilePathError">
	<wmsform:getlocalestring page="appconfig.player" obj="noFilePath"/>
</c:set>
<c:set var="invalidPlaybackUrlError">
	<wmsform:getlocalestring page="appconfig.player" obj="playbackUrlInvalid"/>
</c:set>

 <script>
 $(document).ready(function() {

	if ( $("#selectedUrl").val() == "HLSDISABLED") {
		$("#selectedUrl").val("");
		postAJAXForm('applications/${appType}/player/showError.htm');
		return;
	}

	if ("${hlsDisabled}" == "true")
	{
		$("#editSection").hide();
	}

	if ("${appType}" == "live")
	{
		//set up radio state here.
		if ($('#incomingStreamRadio').val() == "true") {
			$('#radioManualHls').prop('value', false);
// 			$('#radioStreamTarget').prop('value', false);
			$('#radioIncomingStream').prop('value', true);

			$('#radioManualHls').prop('checked', false);
// 			$('#radioStreamTarget').prop('checked', false);
			$('#radioIncomingStream').prop('checked', true);
		}
		if ($('#manualHlsRadio').val() == "true") {
// 			$('#radioStreamTarget').prop('value', false);
			$('#radioIncomingStream').prop('value', false);
			$('#radioManualHls').prop('value', true);

// 			$('#radioStreamTarget').prop('checked', false);
			$('#radioIncomingStream').prop('checked', false);
			$('#radioManualHls').prop('checked', true);
		}
// 		if ($('#streamTargetRadio').val() == "true") {
// 			$('#radioManualHls').prop('value', false);
// 			$('#radioIncomingStream').prop('value', false);
// 			$('#radioStreamTarget').prop('value', true);

// 			$('#radioManualHls').prop('checked', false);
// 			$('#radioIncomingStream').prop('checked', false);
// 			$('#radioStreamTarget').prop('checked', true);
// 		}

		// set up state of disabled values on page entry
		if ($("#radioIncomingStream").is(':checked'))
		{
			$("#playerIncomingStreams").prop('readonly', false);
// 			$('#playerStreamTarget').prop('readonly', true);
// 			$('#playerStreamTarget').addClass('disabled');
			$('#playerManualHls').prop('readonly', true);
			$('#playerManualHls').addClass('disabled');

			$("#incomingStreamRadio").val(true);
// 			$("#streamTargetRadio").val(false);
			$("#manualHlsRadio").val(false);
		}

		if ($("#radioManualHls").is(':checked'))
		{
			$("#playerManualHls").prop('readonly', false);
			$('#playerIncomingStreams').prop('readonly', true);
			$('#playerIncomingStreams').addClass('disabled');
// 			$('#playerStreamTarget').prop('readonly', true);
// 			$('#playerStreamTarget').addClass('disabled');

			$("#incomingStreamRadio").val(false);
// 			$("#streamTargetRadio").val(false);
			$("#manualHlsRadio").val(true);
		}

// 		if ($("#radioStreamTarget").is(':checked'))
// 		{
// 			$("#playerStreamTarget").prop('readonly', false);
// 			$('#playerIncomingStreams').prop('readonly', true);
// 			$('#playerIncomingStreams').addClass('disabled');
// 			$('#playerManualHls').prop('readonly', true);
// 			$('#playerManualHls').addClass('disabled');

// 			$("#incomingStreamRadio").val(false);
// 			$("#streamTargetRadio").val(true);
// 			$("#manualHlsRadio").val(false);
// 		}
	}
 });

$("#radioIncomingStream").on("change", function () {
	$("#playerIncomingStreams").prop('readonly', false);
// 	$('#playerStreamTarget').prop('readonly', true);
// 	$('#playerStreamTarget').addClass('disabled');
	$('#playerManualHls').prop('readonly', true);
	$('#playerManualHls').addClass('disabled');

	$('#radioManualHls').prop('value', false);
// 	$('#radioStreamTarget').prop('value', false);
	$('#radioIncomingStream').prop('value', true);

	$("#incomingStreamRadio").val(true);
// 	$("#streamTargetRadio").val(false);
	$("#manualHlsRadio").val(false);
});

// $("#radioStreamTarget").on("change", function () {
// 	$("#playerStreamTarget").prop('readonly', false);
// 	$('#playerIncomingStreams').prop('readonly', true);
// 	$('#playerIncomingStreams').addClass('disabled');
// 	$('#playerManualHls').prop('readonly', true);
// 	$('#playerManualHls').addClass('disabled');
//
// 	$('#radioStreamTarget').prop('value', true);
// 	$('#radioIncomingStream').prop('value', false);
// 	$('#manualHLS').prop('value', false);
//
// 	$("#incomingStreamRadio").val(false);
// 	$("#streamTargetRadio").val(true);
// 	$("#manualHlsRadio").val(false);
// });

$("#radioManualHls").on("change", function () {
	$("#playerManualHls").prop('readonly', false);
	$('#playerIncomingStreams').prop('readonly', true);
	$('#playerIncomingStreams').addClass('disabled');
// 	$('#playerStreamTarget').prop('readonly', true);
// 	$('#playerStreamTarget').addClass('disabled');

	$('#manualHLS').prop('value', true);
	$('#radioIncomingStream').prop('value', false);
// 	$('#radioStreamTarget').prop('value', false);

	$("#incomingStreamRadio").val(false);
// 	$("#streamTargetRadio").val(false);
	$("#manualHlsRadio").val(true);
});


function launchPlayerPage() {
	var url = "BADURL";

	if (validatePlayerUrl() == true) {
		if ('${appType}' == 'live') {
			url = getLiveURL();
		}
		else if ('${appType}' == 'vodedge') {
			url = getVodEdgeURL();
		}
		else {
			url = getVodURL();
		}
		//console.log(" URL "+ url );

		var win="_blank";
		var page = "https://" + $("#playerDomain").val() + "?sourceURL=" + encodeURIComponent(url);

		window.open(page, win);
	}
}

function validatePlayerUrl() {
	var urlValid = true;

	if ('${appType}' == 'vod') {
		if (!validateVodURL()) {
			$('#vodFilePathValWarnings').html("${blankFilePathError}");
			$('#vodFilePathValWarnings').show();
			urlValid = false;
		}
		else {
			$("#vodAppInst").val($("#vodAppInstVal").val())
			$("#vodPath").val($("#vodPathVal").val())
			$('#vodFilePathValWarnings').hide();
		}
	}
	else if ('${appType}' == 'vodedge') {
		if (!validateVodURL()) {
			$('#vodFilePathValWarnings').html("${blankFilePathError}");
			$('#vodFilePathValWarnings').show();
			urlValid = false;
		}
		else {
			$("#vodAppInst").val($("#vodAppInstVal").val())
			$("#vodPath").val($("#vodPathVal").val())
			$('#vodFilePathValWarnings').hide();
		}
	}
	else { // '${appType}' == 'live'
		if (!validateLiveURL()) {
			$('#liveFilePathValWarnings').html("${invalidPlaybackUrlError}");
			$('#liveFilePathValWarnings').show();
			urlValid = false;
		}
		else {
			$('#liveFilePathValWarnings').hide();
		}
	}

	return urlValid;
}

function goToEditApplication() {
	loadApplication("${wmsutil:urlEncode(appName)}","${wmsutil:urlEncode(appType)}","main");
}

function validateVodURL() {
	var ok=true;
	var url = getVodURL();

	if(url=="") {
		ok=false;
	}
	return ok;
}

function startsWith(main, match) {
	var result = main.lastIndexOf(match, 0);
	return result;
}

function endsWith(main,match) {
	var result = main.indexOf(match);
	return result;
}

function validateLiveURL() {
	var ok=true;
	var url = getLiveURL();

	if ( ( startsWith(url,"http://") !=0 && startsWith(url,"https://")  !=0 ) || endsWith(url,".m3u8") < 0 )
	{
	ok = false;
	}

	//if ((url.startsWith("http://") == false && url.startsWith("https://") == false) || url.includes("playlist.m3u8") == false) {
	//	ok = false;
	//}
	return ok;
}

function getLiveURL() {
	var url = "";

	if ($('#incomingStreamRadio').val() == "true") {
		if ( $('#playerIncomingStreamsOptions').val() != "") {
			var list = $('#playerIncomingStreamsOptions').val().split(',');
			var myIndex = $('#playerIncomingStreams').prop('selectedIndex')
			url = list[myIndex];
		}
	}
	else if ($('#manualHlsRadio').val() == "true") {
		url = $('#playerManualHls').val();
	}
	//else if ($('#streamTargetRadio').val() == "true") {
	//	url = list[myIndex];
	//}

	return url;
}

function getVodEdgeURL() {
	var url = "";

	if ($("#vodPathVal").val() != "")
		{
		var inst = "_definst_";
		if ($("#vodAppInstVal").val() != "")
		{
			inst = $("#vodAppInstVal").val();
		}
		else
		{
			inst = "_definst_";
		}

		var selectedUrlPrefix = $("#urlPrefixSelect option:selected").val();
		$("#playerVodUrlPrefix").val(selectedUrlPrefix)

		var urlPrefixSourceSelect = $("#urlPrefixSourceSelect option:selected").val();
		$("#playerVodUrlSource").val(urlPrefixSourceSelect);

		url = selectedUrlPrefix + "/" + "${appName}" + "/" + inst + "/" + urlPrefixSourceSelect + "/" + $("#vodPathVal").val() + "/playlist.m3u8";

		$('#completedUrl').html("<b>Result:</b> " + url);
		}

	return url;
}

function getVodURL() {
	var url = "";

	if ($("#vodPathVal").val() != "") {
		var inst = "_definst_";
		if ($("#vodAppInstVal").val() != "")
			inst = $("#vodAppInstVal").val();
		var selectedUrlPrefix = $("#urlPrefixSelect option:selected").val();
		$("#playerVodUrlPrefix").val(selectedUrlPrefix)
		url = selectedUrlPrefix + "/" + "${appName}" + "/" + inst + "/" + $("#vodPathVal").val() + "/playlist.m3u8";
		$('#completedUrl').html("<b>Result:</b> " + url);
	}

	return url;
}

function onInput() {

    var url = "";

	if ('${appType}' == 'vodedge') {
		url = getVodEdgeURL();
		}
	else if ('${appType}' == 'vod') {
		url = getVodURL();
	} else { url = getVodURL(); }

	if (url != "") {
		$('#completedUrl').html("<b>Result:</b> " + url);
	}
	else {
		$('#completedUrl').html("${pathNotice}");
	}
}
</script>
